/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileBase;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileLeaf;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;

public class ElevationProfileNode
extends ElevationProfileBase {
    private List<IElevationProfile> slices;

    public ElevationProfileNode(String trackName, IElevationProfile parent, List<WayPoint> wayPoints, int sliceSize) {
        super(trackName, parent, wayPoints, sliceSize);
        this.setSliceSize(sliceSize);
        this.createsSlices(wayPoints);
    }

    public int getNumberOfSlices() {
        return this.slices != null ? this.slices.size() : 0;
    }

    public void updateTrack(List<WayPoint> waypoints) {
        this.createsSlices(waypoints);
    }

    private void createsSlices(List<WayPoint> wayPoints) {
        if (wayPoints == null || this.getSliceSize() <= 0) {
            return;
        }
        if (this.slices == null) {
            this.slices = new ArrayList<IElevationProfile>();
        } else {
            this.slices.clear();
        }
        int i = 0;
        while (i < wayPoints.size()) {
            int to = Math.min(i + this.getSliceSize(), wayPoints.size());
            ElevationProfileLeaf ems = new ElevationProfileLeaf(this.getName(), this, wayPoints.subList(i, to));
            this.slices.add(ems);
            i += this.getSliceSize();
        }
        this.setWayPoints(WayPointHelper.downsampleWayPoints(wayPoints, this.getSliceSize()), false);
    }

    @Override
    public List<IElevationProfile> getChildren() {
        return this.slices;
    }
}

