/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class ColumbusCSVUtils {
    private ColumbusCSVUtils() {
    }

    public static void showErrorMessage(String txt) {
        ColumbusCSVUtils.showMessage(txt, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
    }

    public static void showInfoMessage(String txt) {
        ColumbusCSVUtils.showMessage(txt, I18n.tr((String)"Information", (Object[])new Object[0]), 1);
    }

    public static void showWarningMessage(String txt) {
        ColumbusCSVUtils.showMessage(txt, I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
    }

    public static void showMessage(String txt, String caption, int icon) {
        if (ColumbusCSVUtils.isStringNullOrEmpty(txt)) {
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)txt, (Object[])new Object[0]), caption, icon);
    }

    public static boolean isStringNullOrEmpty(String txt) {
        return txt == null || txt.length() == 0;
    }

    public static Float floatFromString(String txt) {
        Float f;
        if (ColumbusCSVUtils.isStringNullOrEmpty(txt)) {
            return Float.valueOf(Float.NaN);
        }
        try {
            f = Float.valueOf(Float.parseFloat(txt));
        }
        catch (NumberFormatException nex) {
            f = Float.valueOf(Float.NaN);
        }
        return f;
    }
}

