/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.plugins.fixAddresses.gui.IncompleteAddressesTableModel;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.ApplyAllGuessesAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.GuessAddressDataAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.RemoveAddressTagsAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.SelectAddressesInMapAction;
import org.openstreetmap.josm.tools.I18n;

public class IncompleteAddressesDialog
extends ToggleDialog
implements DataSetListener,
ListSelectionListener,
IAddressEditContainerListener {
    private static final String FIXED_DIALOG_TITLE = I18n.tr((String)"Incomplete Addresses");
    private AddressEditContainer container;
    private SelectAddressesInMapAction selectAction = new SelectAddressesInMapAction();
    private GuessAddressDataAction guessDataAction = new GuessAddressDataAction();
    private ApplyAllGuessesAction applyGuessesAction = new ApplyAllGuessesAction();
    private RemoveAddressTagsAction removeTagsAction = new RemoveAddressTagsAction();
    private AbstractAddressEditAction[] actions = new AbstractAddressEditAction[]{this.selectAction, this.guessDataAction, this.applyGuessesAction, this.removeTagsAction};
    private JTable incompleteAddr;

    public IncompleteAddressesDialog() {
        super(FIXED_DIALOG_TITLE, "incompleteaddress_24", I18n.tr((String)"Show incomplete addresses"), null, 150);
        this.container = new AddressEditContainer();
        this.container.addChangedListener(this);
        JPanel p = new JPanel(new BorderLayout());
        IncompleteAddressesTableModel model = new IncompleteAddressesTableModel(this.container);
        this.incompleteAddr = new JTable(model);
        JTableHeader header = this.incompleteAddr.getTableHeader();
        IncompleteAddressesTableModel incompleteAddressesTableModel = model;
        incompleteAddressesTableModel.getClass();
        header.addMouseListener(incompleteAddressesTableModel.new AddressEditTableModel.ColumnListener(this.incompleteAddr));
        this.incompleteAddr.getSelectionModel().addListSelectionListener(this);
        JScrollPane sp = new JScrollPane(this.incompleteAddr);
        p.add((Component)sp, "Center");
        this.add(p);
        JPanel buttonPanel = this.getButtonPanel(this.actions.length);
        for (int i = 0; i < this.actions.length; ++i) {
            SideButton sb = new SideButton((Action)((Object)this.actions[i]));
            buttonPanel.add((Component)sb);
        }
        this.add(buttonPanel, "South");
        for (AbstractAddressEditAction action : this.actions) {
            action.setContainer(this.container);
        }
    }

    public void hideNotify() {
        super.hideNotify();
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this);
    }

    public void showNotify() {
        super.showNotify();
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
    }

    public void dataChanged(DataChangedEvent event) {
        this.container.invalidate();
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.container.invalidate();
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.container.invalidate();
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.container.invalidate();
    }

    public void tagsChanged(TagsChangedEvent event) {
        this.container.invalidate();
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.container.invalidate();
    }

    public void valueChanged(ListSelectionEvent e) {
        AddressEditSelectionEvent event = new AddressEditSelectionEvent((Object)e, null, null, this.incompleteAddr, this.container);
        for (AbstractAddressEditAction action : this.actions) {
            action.setEvent(event);
        }
        OsmUtils.zoomAddresses(event.getSelectedIncompleteAddresses());
    }

    public void containerChanged(AddressEditContainer container) {
        if (container != null && container.getNumberOfIncompleteAddresses() > 0) {
            this.setTitle(String.format("%s (%d %s)", FIXED_DIALOG_TITLE, container.getNumberOfIncompleteAddresses(), I18n.tr((String)"items")));
        } else {
            this.setTitle(String.format("%s (%s)", FIXED_DIALOG_TITLE, I18n.tr((String)"no items")));
        }
    }

    public void entityChanged(IOSMEntity node) {
        this.container.invalidate();
    }
}

