/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.AddressProblem;
import org.openstreetmap.josm.plugins.fixAddresses.AddressSolution;
import org.openstreetmap.josm.plugins.fixAddresses.IAllKnowingTrashHeap;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.IProblem;
import org.openstreetmap.josm.plugins.fixAddresses.IProblemVisitor;
import org.openstreetmap.josm.plugins.fixAddresses.OSMEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.PostalCodeChecker;
import org.openstreetmap.josm.plugins.fixAddresses.SolutionType;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.ApplyAllGuessesAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.RemoveAddressTagsAction;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSMAddress
extends OSMEntityBase {
    public static final String MISSING_TAG = "?";
    public static final String INTERPOLATION_TAG = "x..y";
    private boolean isPartOfInterpolation;
    private boolean isPartOfAssocStreetRel;
    private HashMap<String, String> guessedValues = new HashMap();
    private HashMap<String, OsmPrimitive> guessedObjects = new HashMap();
    private HashMap<String, String> derivedValues = new HashMap();

    public OSMAddress(OsmPrimitive osmObject) {
        super(osmObject);
    }

    @Override
    public void setOsmObject(OsmPrimitive osmObject) {
        super.setOsmObject(osmObject);
        this.isPartOfInterpolation = OsmUtils.getValuesFromAddressInterpolation(this);
        this.isPartOfAssocStreetRel = OsmUtils.getValuesFromRelation(this);
    }

    public boolean isComplete() {
        boolean isComplete;
        boolean bl = isComplete = this.hasCity() && this.hasHouseNumber() && this.hasPostalCode() && PostalCodeChecker.hasValidPostalCode(this) && this.hasCity() && this.hasStreetName();
        if (TagUtils.isStateRequired()) {
            isComplete = isComplete && this.hasState();
        }
        return isComplete;
    }

    public String getStreetName() {
        return this.getTagValueWithGuess("addr:street");
    }

    private String getTagValueWithGuess(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            return MISSING_TAG;
        }
        if (this.osmObject == null) {
            return MISSING_TAG;
        }
        if (!this.osmObject.hasKey(tag) || StringUtils.isNullOrEmpty(this.osmObject.get(tag))) {
            if (!this.hasDerivedValue(tag)) {
                if (this.hasGuessedValue(tag)) {
                    return "*" + this.getGuessedValue(tag);
                }
                return MISSING_TAG;
            }
            return this.getDerivedValue(tag);
        }
        return this.osmObject.get(tag);
    }

    public boolean hasStreetName() {
        return this.hasTag("addr:street");
    }

    public String getGuessedStreetName() {
        return this.getGuessedValue("addr:street");
    }

    public void setGuessedStreetName(String guessedStreetName, OsmPrimitive srcObj) {
        this.setGuessedValue("addr:street", guessedStreetName, srcObj);
    }

    public boolean hasGuessedStreetName() {
        return this.hasGuessedValue("addr:street");
    }

    public String getGuessedPostalCode() {
        return this.getGuessedValue("addr:postcode");
    }

    public void setGuessedPostalCode(String guessedPostCode, OsmPrimitive srcObj) {
        this.setGuessedValue("addr:postcode", guessedPostCode, srcObj);
    }

    public boolean hasGuessedPostalCode() {
        return this.hasGuessedValue("addr:postcode");
    }

    public String getGuessedCity() {
        return this.getGuessedValue("addr:city");
    }

    public void setGuessedCity(String guessedCity, OsmPrimitive srcObj) {
        this.setGuessedValue("addr:city", guessedCity, srcObj);
    }

    public boolean hasGuessedCity() {
        return this.hasGuessedValue("addr:city");
    }

    public boolean hasGuesses() {
        return this.guessedValues.size() > 0;
    }

    public void applyAllGuesses() {
        for (String tag : this.guessedValues.keySet()) {
            this.applyGuessForTag(tag);
        }
        this.guessedValues.clear();
        this.guessedObjects.clear();
    }

    public void applyGuessForTag(String tag) {
        String val;
        if (this.guessedValues.containsKey(tag) && !StringUtils.isNullOrEmpty(val = this.guessedValues.get(tag))) {
            this.setOSMTag(tag, val);
        }
    }

    public String getPostalCode() {
        String pc = this.getTagValueWithGuess("addr:postcode");
        if (!MISSING_TAG.equals(pc) && !PostalCodeChecker.hasValidPostalCode(this.getCountry(), pc)) {
            pc = "(!)" + pc;
        }
        return pc;
    }

    public boolean hasValidPostalCode() {
        return PostalCodeChecker.hasValidPostalCode(this);
    }

    public boolean hasPostalCode() {
        return this.hasTag("addr:postcode");
    }

    public String getHouseNumber() {
        if (!TagUtils.hasAddrHousenumberTag(this.osmObject)) {
            if (!this.isPartOfInterpolation) {
                return MISSING_TAG;
            }
            return INTERPOLATION_TAG;
        }
        return TagUtils.getAddrHousenumberValue(this.osmObject);
    }

    public boolean hasHouseNumber() {
        return TagUtils.hasAddrHousenumberTag(this.osmObject) || this.isPartOfInterpolation;
    }

    @Override
    public String getName() {
        String name = TagUtils.getNameValue(this.osmObject);
        if (!StringUtils.isNullOrEmpty(name)) {
            return TagUtils.getAddrHousenameValue(this.osmObject);
        }
        return "";
    }

    protected boolean isPartOfInterpolation() {
        return this.isPartOfInterpolation;
    }

    protected boolean isPartOfRelation() {
        return this.isPartOfAssocStreetRel;
    }

    public String getCity() {
        return this.getTagValueWithGuess("addr:city");
    }

    public boolean hasCity() {
        return this.hasTag("addr:city");
    }

    public String getState() {
        return this.getTagValueWithGuess("addr:state");
    }

    public boolean hasState() {
        return this.hasTag("addr:state");
    }

    public String getCountry() {
        return this.getTagValueWithGuess("addr:country");
    }

    public boolean hasCountry() {
        return this.hasTag("addr:country");
    }

    public void removeAllAddressTags() {
        this.removeOSMTag("addr:city");
        this.removeOSMTag("addr:country");
        this.removeOSMTag("addr:postcode");
        this.removeOSMTag("addr:housenumber");
        this.removeOSMTag("addr:state");
        this.removeOSMTag("addr:street");
    }

    public boolean hasTag(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            return false;
        }
        return TagUtils.hasTag(this.osmObject, tag) || this.hasDerivedValue(tag);
    }

    @Override
    public int compareTo(IOSMEntity o) {
        if (o == null || !(o instanceof OSMAddress)) {
            return -1;
        }
        OSMAddress other = (OSMAddress)o;
        int cc = 0;
        cc = this.getCountry().compareTo(other.getCountry());
        if (cc == 0 && (cc = this.getState().compareTo(other.getState())) == 0 && (cc = this.getCity().compareTo(other.getCity())) == 0 && (cc = this.getStreetName().compareTo(other.getStreetName())) == 0) {
            if (this.hasGuessedStreetName()) {
                if (other.hasStreetName()) {
                    cc = this.getGuessedStreetName().compareTo(other.getStreetName());
                    if (cc == 0) {
                        cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                    }
                } else if (other.hasGuessedStreetName() && (cc = this.getGuessedStreetName().compareTo(other.getGuessedStreetName())) == 0) {
                    cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                }
            } else {
                cc = this.getHouseNumber().compareTo(other.getHouseNumber());
            }
        }
        return cc;
    }

    public void assignStreet(OSMStreet node) {
        if (node == null || !node.hasName()) {
            return;
        }
        if (!node.getName().equals(this.getStreetName())) {
            this.setStreetName(node.getName());
            node.addAddress(this);
            OSMAddress.fireEntityChanged(this);
        }
    }

    public String getGuessedValue(String tag) {
        CheckParameterUtil.ensureParameterNotNull((Object)tag, (String)"tag");
        if (!this.hasGuessedValue(tag)) {
            return null;
        }
        return this.guessedValues.get(tag);
    }

    public OsmPrimitive getGuessedObject(String tag) {
        CheckParameterUtil.ensureParameterNotNull((Object)tag, (String)"tag");
        if (this.guessedObjects.containsKey(tag)) {
            return this.guessedObjects.get(tag);
        }
        return null;
    }

    public Collection<OsmPrimitive> getGuessedObjects() {
        if (this.guessedObjects == null) {
            return null;
        }
        return this.guessedObjects.values();
    }

    public boolean needsGuess() {
        return this.needsGuessedValue("addr:city") || this.needsGuessedValue("addr:postcode") || this.needsGuessedValue("addr:country") || this.needsGuessedValue("addr:street");
    }

    public boolean needsGuessedValue(String tag) {
        return MISSING_TAG.equals(this.getTagValueWithGuess(tag));
    }

    public void clearAllGuesses() {
        this.guessedValues.clear();
    }

    private boolean hasGuessedValue(String tag) {
        CheckParameterUtil.ensureParameterNotNull((Object)tag, (String)"tag");
        return this.guessedValues.containsKey(tag) && !StringUtils.isNullOrEmpty(this.guessedValues.get(tag));
    }

    public void setGuessedValue(String tag, String value, OsmPrimitive osm) {
        CheckParameterUtil.ensureParameterNotNull((Object)tag, (String)"tag");
        if (value != null && osm != null) {
            this.guessedValues.put(tag, value);
            if (osm != null) {
                this.guessedObjects.put(tag, osm);
            }
            OSMAddress.fireEntityChanged(this);
        }
    }

    private boolean hasDerivedValue(String tag) {
        CheckParameterUtil.ensureParameterNotNull((Object)tag, (String)"tag");
        return this.derivedValues.containsKey(tag) && !StringUtils.isNullOrEmpty(this.derivedValues.get(tag));
    }

    public boolean hasDerivedValues() {
        return this.derivedValues.size() > 0;
    }

    public String getDerivedValue(String tag) {
        if (!this.hasDerivedValue(tag)) {
            return null;
        }
        return this.derivedValues.get(tag);
    }

    public void setDerivedValue(String tag, String value) {
        this.derivedValues.put(tag, value);
    }

    public void setStreetName(String streetName) {
        if (streetName != null && streetName.length() == 0) {
            return;
        }
        this.setOSMTag("addr:street", streetName);
    }

    public void setState(String state) {
        if (state != null && state.length() == 0) {
            return;
        }
        this.setOSMTag("addr:state", state);
    }

    public void setCountry(String country) {
        if (country != null && country.length() == 0) {
            return;
        }
        this.setOSMTag("addr:country", country);
    }

    public void setPostCode(String postCode) {
        if (postCode != null && postCode.length() == 0) {
            return;
        }
        this.setOSMTag("addr:postcode", postCode);
    }

    @Override
    public void visit(IAllKnowingTrashHeap trashHeap, IProblemVisitor visitor) {
        String tag;
        AddressProblem p;
        CheckParameterUtil.ensureParameterNotNull((Object)visitor, (String)"visitor");
        if (!this.hasStreetName()) {
            p = new AddressProblem(this, I18n.tr((String)"Address has no street"));
            if (this.hasGuessedStreetName()) {
                tag = "addr:street";
                this.addGuessValueSolution(p, tag);
            }
            this.addRemoveAddressTagsSolution(p);
            visitor.addProblem(p);
        } else if (!trashHeap.isValidStreetName(this.getStreetName())) {
            p = new AddressProblem(this, I18n.tr((String)"Address has no valid street"));
            String match = trashHeap.getClosestStreetName(this.getStreetName());
            if (!StringUtils.isNullOrEmpty(match)) {
                this.setGuessedStreetName(match, null);
                this.addGuessValueSolution(p, "addr:street");
            }
            visitor.addProblem(p);
        }
        if (!this.hasPostalCode()) {
            p = new AddressProblem(this, I18n.tr((String)"Address has no post code"));
            if (this.hasGuessedStreetName()) {
                tag = "addr:postcode";
                this.addGuessValueSolution(p, tag);
            }
            this.addRemoveAddressTagsSolution(p);
            visitor.addProblem(p);
        }
        if (!this.hasCity()) {
            p = new AddressProblem(this, I18n.tr((String)"Address has no city"));
            if (this.hasGuessedStreetName()) {
                tag = "addr:city";
                this.addGuessValueSolution(p, tag);
            }
            this.addRemoveAddressTagsSolution(p);
            visitor.addProblem(p);
        }
        if (!this.hasCountry()) {
            p = new AddressProblem(this, I18n.tr((String)"Address has no country"));
            this.addRemoveAddressTagsSolution(p);
            visitor.addProblem(p);
        }
    }

    private void addGuessValueSolution(AddressProblem p, String tag) {
        AddressSolution s = new AddressSolution(String.format("%s '%s'", I18n.tr((String)"Assign to"), this.getGuessedValue(tag)), new ApplyAllGuessesAction(tag), SolutionType.Change);
        p.addSolution(s);
    }

    private void addRemoveAddressTagsSolution(IProblem problem) {
        CheckParameterUtil.ensureParameterNotNull((Object)problem, (String)"problem");
        AddressSolution s = new AddressSolution(I18n.tr((String)"Remove all address tags"), new RemoveAddressTagsAction(), SolutionType.Remove);
        problem.addSolution(s);
    }

    @Override
    public String toString() {
        return OSMAddress.getFormatString(this);
    }

    public static String getFormatString(OSMAddress node) {
        String guessed = node.getGuessedStreetName();
        String sName = node.getStreetName();
        if (!StringUtils.isNullOrEmpty(guessed) && MISSING_TAG.equals(sName)) {
            sName = String.format("(%s)", guessed);
        }
        return String.format("%s %s, %s-%s %s (%s) ", sName, node.getHouseNumber(), node.getCountry(), node.getPostalCode(), node.getCity(), node.getState());
    }
}

