/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Triangle
implements Shape {
    private Polygon poly;

    public Triangle(Polygon p) {
        if (p == null || p.npoints != 3) {
            throw new RuntimeException("Given polygon was null or had invalid number of points");
        }
        this.poly = p;
    }

    public Triangle(Point p1, Point p2, Point p3) {
        this.poly = new Polygon();
        this.poly.addPoint(p1.x, p1.y);
        this.poly.addPoint(p2.x, p2.y);
        this.poly.addPoint(p3.x, p3.y);
    }

    public void draw(Graphics g) {
        g.drawPolygon(this.poly);
    }

    public void fill(Graphics g) {
        g.fillPolygon(this.poly);
    }

    public Rectangle getBounds() {
        return this.poly.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.poly.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.poly.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.poly.contains(p);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.poly.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.poly.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.poly.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.poly.intersects(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.poly.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.poly.getPathIterator(at, flatness);
    }
}

