/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressEditSelectionEvent
extends ActionEvent {
    private static final long serialVersionUID = -93034483427803409L;
    private JTable streetTable;
    private JTable unresolvedAddressTable;
    private JTable incompleteAddressTable;
    private AddressEditContainer addressContainer;
    private List<OSMAddress> unresolvedCache;
    private List<OSMAddress> incompleteCache;

    public AddressEditSelectionEvent(Object source, JTable selStreet, JTable unresolvedAddresses, JTable incompleteAddresses, AddressEditContainer container) {
        super(source, -1, "");
        this.streetTable = selStreet;
        this.unresolvedAddressTable = unresolvedAddresses;
        this.incompleteAddressTable = incompleteAddresses;
        this.addressContainer = container;
    }

    public JTable getStreetTable() {
        return this.streetTable;
    }

    public JTable getUnresolvedAddressTable() {
        return this.unresolvedAddressTable;
    }

    protected JTable getIncompleteAddressTable() {
        return this.incompleteAddressTable;
    }

    public AddressEditContainer getAddressContainer() {
        return this.addressContainer;
    }

    public OSMStreet getSelectedStreet() {
        if (this.streetTable != null && this.addressContainer != null && this.addressContainer.getStreetList() != null) {
            int selRows = this.streetTable.getSelectedRow();
            if (selRows < 0 || selRows >= this.addressContainer.getNumberOfStreets()) {
                return null;
            }
            return this.addressContainer.getStreetList().get(selRows);
        }
        return null;
    }

    public boolean hasAddresses() {
        return this.hasIncompleteAddresses() || this.hasUnresolvedAddresses();
    }

    public boolean hasIncompleteAddresses() {
        return this.getSelectedIncompleteAddresses() != null;
    }

    public boolean hasUnresolvedAddresses() {
        return this.getSelectedUnresolvedAddresses() != null;
    }

    public boolean hasAddressesWithGuesses() {
        if (this.hasIncompleteAddresses()) {
            for (OSMAddress addr : this.getSelectedIncompleteAddresses()) {
                if (!addr.hasGuesses()) continue;
                return true;
            }
        }
        if (this.hasUnresolvedAddresses()) {
            for (OSMAddress addr : this.getSelectedUnresolvedAddresses()) {
                if (!addr.hasGuesses()) continue;
                return true;
            }
        }
        return false;
    }

    public List<OSMAddress> getSelectedUnresolvedAddresses() {
        if (this.unresolvedAddressTable != null && this.addressContainer != null && this.unresolvedCache == null) {
            int[] selRows = this.unresolvedAddressTable.getSelectedRows();
            this.unresolvedCache = new ArrayList<OSMAddress>();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] < 0 || selRows[i] >= this.addressContainer.getNumberOfUnresolvedAddresses()) continue;
                this.unresolvedCache.add(this.addressContainer.getUnresolvedAddresses().get(selRows[i]));
            }
            return this.unresolvedCache;
        }
        return this.unresolvedCache;
    }

    public List<OSMAddress> getSelectedIncompleteAddresses() {
        if (this.incompleteAddressTable != null && this.addressContainer != null && this.incompleteCache == null) {
            int[] selRows = this.incompleteAddressTable.getSelectedRows();
            this.incompleteCache = new ArrayList<OSMAddress>();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] < 0 || selRows[i] >= this.addressContainer.getNumberOfIncompleteAddresses()) continue;
                this.incompleteCache.add(this.addressContainer.getIncompleteAddresses().get(selRows[i]));
            }
            return this.incompleteCache;
        }
        return this.incompleteCache;
    }
}

