/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileBase;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileNode;
import org.openstreetmap.josm.plugins.elevation.GpxIterator;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.IGpxVisitor;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElevationModel
extends ElevationProfileBase
implements IGpxVisitor {
    private int trackCounter;
    private GpxData gpxData;
    private List<IElevationProfile> tracks;
    private List<WayPoint> buffer = new ArrayList<WayPoint>(1000);
    private List<WayPoint> tmpWaypoints = new ArrayList<WayPoint>(1000);
    private List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private int numberOfWayPoints;

    public ElevationModel() {
        this("", null, 100);
    }

    public ElevationModel(String name, GpxData data, int sliceSize) {
        super(name);
        this.gpxData = data;
        this.setSliceSize(Math.max(sliceSize, 100));
    }

    @Override
    public void setSliceSize(int sliceSize) {
        super.setSliceSize(sliceSize);
        this.updateElevationData();
        this.fireModelChanged();
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    protected List<IElevationProfile> getTracks() {
        return this.tracks;
    }

    @Override
    public boolean hasElevationData() {
        return this.getMaxHeight() != this.getMinHeight();
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            listener.elevationProfileChanged(this);
        }
    }

    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void computeProfile() {
        if (this.gpxData == null) {
            return;
        }
        this.trackCounter = 0;
        super.updateValues();
        if (this.tracks == null) {
            this.tracks = new ArrayList<IElevationProfile>();
        } else {
            this.tmpWaypoints.clear();
            this.buffer.clear();
            this.tracks.clear();
        }
        this.setDistance(this.gpxData.length());
        GpxIterator.visit(this.gpxData, (IGpxVisitor)this);
        this.setWayPoints(WayPointHelper.downsampleWayPoints(this.tmpWaypoints, this.getSliceSize()), false);
    }

    @Override
    public void updateElevationData() {
        this.computeProfile();
    }

    public void visit(GpxRoute route, WayPoint wp) {
        this.processWayPoint(wp);
    }

    public void visit(GpxTrack track, GpxTrackSegment segment, WayPoint wp) {
        this.processWayPoint(wp);
    }

    @Override
    public void visit(WayPoint wp) {
        super.visit(wp);
        this.processWayPoint(wp);
    }

    @Override
    public void start() {
        this.buffer.clear();
    }

    @Override
    public void end() {
        String trackName = "Track#" + this.trackCounter;
        this.addTrackOrRoute(trackName);
    }

    private void addTrackOrRoute(String trackName) {
        if (this.getSliceSize() > 0) {
            ElevationProfileNode emt = new ElevationProfileNode(trackName, this, this.buffer, this.getSliceSize());
            this.tracks.add(emt);
        }
        ++this.trackCounter;
        this.buffer.clear();
    }

    private void processWayPoint(WayPoint wp) {
        if (wp == null) {
            throw new RuntimeException("WPT must not be null!");
        }
        this.buffer.add(wp);
        this.tmpWaypoints.add(wp);
        ++this.numberOfWayPoints;
    }

    @Override
    public List<IElevationProfile> getChildren() {
        return this.tracks;
    }
}

