/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.elevation.ElevationModel;
import org.openstreetmap.josm.plugins.elevation.GeoidCorrectionKind;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileLayer;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfilePanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ElevationProfileDialog
extends ToggleDialog
implements PropertyChangeListener,
MapView.LayerChangeListener,
MapView.EditLayerChangeListener,
ComponentListener {
    private static final String EMPTY_DATA_STRING = "-";
    private static final long serialVersionUID = -868463893732535577L;
    private ElevationModel profile;
    private GpxLayer activeLayer = null;
    private HashMap<GpxLayer, ElevationModel> layerMap = new HashMap();
    private ElevationProfilePanel profPanel;
    private JLabel minHeightLabel;
    private JLabel maxHeightLabel;
    private JLabel avrgHeightLabel;
    private JLabel elevationGainLabel;
    private JLabel totalTimeLabel;
    private JLabel distLabel;
    private JRadioButton geoidNone;
    private JRadioButton geoidAuto;
    private JRadioButton geoidFixed;
    private JTextField geoidFixedValue;
    private List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private ElevationProfileLayer profileLayer;

    public ElevationProfileDialog() {
        this(I18n.tr((String)"Elevation Profile"), "elevation", I18n.tr((String)"Open the elevation profile window."), null, 200, true);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        this(name, iconName, tooltip, shortcut, preferredHeight, false);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        super(name, iconName, tooltip, shortcut, preferredHeight, defShow);
        JPanel dataPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 6);
        dataPanel.setLayout(gridLayout);
        JLabel lbl = new JLabel(I18n.tr((String)"Min"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Avrg"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Max"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Dist"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Gain"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        lbl = new JLabel(I18n.tr((String)"Time"));
        lbl.setFont(this.getFont().deriveFont(1));
        dataPanel.add(lbl);
        this.minHeightLabel = new JLabel("0 m");
        dataPanel.add(this.minHeightLabel);
        this.avrgHeightLabel = new JLabel("0 m");
        dataPanel.add(this.avrgHeightLabel);
        this.maxHeightLabel = new JLabel("0 m");
        dataPanel.add(this.maxHeightLabel);
        this.distLabel = new JLabel("0 km");
        dataPanel.add(this.distLabel);
        this.elevationGainLabel = new JLabel("0 m");
        dataPanel.add(this.elevationGainLabel);
        this.totalTimeLabel = new JLabel("0");
        dataPanel.add(this.totalTimeLabel);
        JLabel geoidHead = new JLabel(I18n.tr((String)"Geoid"));
        geoidHead.setFont(this.getFont().deriveFont(1));
        dataPanel.add(geoidHead);
        this.geoidNone = new JRadioButton(I18n.tr((String)"None"));
        this.geoidNone.setSelected(true);
        this.geoidNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WayPointHelper.setGeoidKind(GeoidCorrectionKind.None);
                ElevationProfileDialog.this.geoidFixedValue.setEnabled(false);
                ElevationProfileDialog.this.getModel().updateElevationData();
                ElevationProfileDialog.this.updateView();
            }
        });
        this.geoidAuto = new JRadioButton(I18n.tr((String)"Automatic"));
        this.geoidAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WayPointHelper.setGeoidKind(GeoidCorrectionKind.Auto);
                ElevationProfileDialog.this.geoidFixedValue.setEnabled(false);
                ElevationProfileDialog.this.getModel().updateElevationData();
                ElevationProfileDialog.this.updateView();
            }
        });
        this.geoidFixed = new JRadioButton(I18n.tr((String)"Fixed value"));
        this.geoidFixed.setEnabled(false);
        this.geoidFixed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WayPointHelper.setGeoidKind(GeoidCorrectionKind.Fixed);
                ElevationProfileDialog.this.geoidFixedValue.setEnabled(true);
                ElevationProfileDialog.this.getModel().updateElevationData();
                ElevationProfileDialog.this.updateView();
            }
        });
        this.geoidFixedValue = new JTextField("0");
        this.geoidFixedValue.setEnabled(false);
        this.geoidFixedValue.setAlignmentX(1.0f);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.geoidAuto);
        grp.add(this.geoidNone);
        grp.add(this.geoidFixed);
        dataPanel.add(this.geoidNone);
        dataPanel.add(this.geoidAuto);
        dataPanel.add(this.geoidFixed);
        dataPanel.add(this.geoidFixedValue);
        dataPanel.add(new JLabel(" m"));
        this.add(dataPanel, "Last");
        this.profile = new ElevationModel();
        this.profPanel = new ElevationProfilePanel(null);
        this.add(this.profPanel, "Center");
        this.profPanel.addComponentListener(this);
        if (WayPointHelper.getGeoidKind() == GeoidCorrectionKind.Auto) {
            this.geoidAuto.setSelected(true);
        }
        if (WayPointHelper.getGeoidKind() == GeoidCorrectionKind.Fixed) {
            this.geoidFixed.setSelected(true);
        }
        this.dock();
    }

    public ElevationModel getModel() {
        return this.profile;
    }

    public void setModel(ElevationModel model) {
        if (this.profile != model) {
            this.profile = model;
            this.profPanel.setElevationModel(model);
            this.updateView();
        }
    }

    public ElevationProfileLayer getProfileLayer() {
        return this.profileLayer;
    }

    public void setProfileLayer(ElevationProfileLayer profileLayer) {
        if (this.profileLayer != profileLayer) {
            if (this.profileLayer != null) {
                this.profPanel.removeSelectionListener(this.profileLayer);
            }
            this.profileLayer = profileLayer;
            this.profPanel.addSelectionListener(this.profileLayer);
        }
    }

    private void updateView() {
        if (this.profile != null) {
            this.setTitle(String.format("%s: %s", I18n.tr((String)"Elevation Profile"), this.profile.getName()));
            if (this.profile.hasElevationData()) {
                this.minHeightLabel.setText(WayPointHelper.getElevationText(this.profile.getMinHeight()));
                this.maxHeightLabel.setText(WayPointHelper.getElevationText(this.profile.getMaxHeight()));
                this.avrgHeightLabel.setText(WayPointHelper.getElevationText(this.profile.getAverageHeight()));
                this.elevationGainLabel.setText(WayPointHelper.getElevationText(this.profile.getGain()));
            }
            long diff = this.profile.getTimeDifference();
            long minutes = diff / 60000L;
            long hours = minutes / 60L;
            double dist = this.profile.getDistance();
            this.totalTimeLabel.setText(String.format("%d:%d h", hours, minutes %= 60L));
            this.distLabel.setText(NavigatableComponent.getSystemOfMeasurement().getDistText(dist));
        } else {
            this.setTitle(String.format("%s: (No data)", I18n.tr((String)"Elevation Profile")));
            this.minHeightLabel.setText(EMPTY_DATA_STRING);
            this.maxHeightLabel.setText(EMPTY_DATA_STRING);
            this.avrgHeightLabel.setText(EMPTY_DATA_STRING);
            this.elevationGainLabel.setText(EMPTY_DATA_STRING);
            this.totalTimeLabel.setText(EMPTY_DATA_STRING);
            this.distLabel.setText(EMPTY_DATA_STRING);
        }
        this.fireModelChanged();
        this.repaint();
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            listener.elevationProfileChanged(this.getModel());
        }
    }

    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object src = event.getSource();
        if (src instanceof MapView) {
            MapView mapView = (MapView)src;
            Layer l = mapView.getActiveLayer();
            if (l instanceof GpxLayer) {
                this.setActiveLayer((GpxLayer)l);
            }
        } else if (src instanceof GpxLayer) {
            GpxLayer gpxLayer = (GpxLayer)src;
            this.setActiveLayer(gpxLayer);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof GpxLayer) {
            this.setActiveLayer((GpxLayer)newLayer);
        }
    }

    private void createLayer(Layer newLayer) {
        if (newLayer != null && newLayer instanceof GpxLayer) {
            newLayer.addPropertyChangeListener((PropertyChangeListener)this);
            GpxLayer gpxLayer = (GpxLayer)newLayer;
            this.setActiveLayer(gpxLayer);
        }
    }

    private void setActiveLayer(GpxLayer newLayer) {
        if (this.activeLayer != newLayer) {
            int slices = 250;
            if (this.profPanel != null && this.profPanel.getPlotArea().width > 0) {
                slices = this.profPanel.getPlotArea().width;
            }
            if (!this.layerMap.containsKey(newLayer)) {
                GpxData gpxData = newLayer.data;
                ElevationModel em = new ElevationModel(newLayer.getName(), gpxData, slices);
                this.layerMap.put(newLayer, em);
            }
            ElevationModel em = this.layerMap.get(newLayer);
            em.setSliceSize(slices);
            this.setModel(em);
        }
    }

    public void layerAdded(Layer newLayer) {
        this.createLayer(newLayer);
    }

    public void layerRemoved(Layer oldLayer) {
        if (this.layerMap.containsKey(oldLayer)) {
            this.layerMap.remove(oldLayer);
        }
        if (this.layerMap.size() == 0) {
            this.setModel(null);
            this.profileLayer.setProfile(null);
        }
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        int slices = 100;
        if (this.profPanel != null) {
            slices = this.profPanel.getPlotArea().width;
        }
        if (this.profile != null && this.profile.getSliceSize() != slices) {
            this.profile.setSliceSize(slices);
        }
    }

    public void componentShown(ComponentEvent e) {
    }
}

