/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fixAddresses.GuessedValueHandler;
import org.openstreetmap.josm.plugins.fixAddresses.IProgressMonitorFinishedListener;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GuessAddressRunnable
extends PleaseWaitRunnable
implements Visitor {
    private List<OSMAddress> addressesToGuess;
    private List<IProgressMonitorFinishedListener> finishListeners = new ArrayList<IProgressMonitorFinishedListener>();
    private double minDist;
    private OSMAddress curAddressNode;
    private boolean isRunning = false;
    private boolean cancelled;

    public GuessAddressRunnable(List<OSMAddress> addresses, String title) {
        super(title != null ? title : I18n.tr((String)"Searching"));
        this.setAddressEditContainer(addresses);
    }

    public void setAddressEditContainer(List<OSMAddress> nodes) {
        if (this.isRunning) {
            throw new ConcurrentModificationException();
        }
        this.addressesToGuess = nodes;
    }

    public List<OSMAddress> getAddressesToGuess() {
        return this.addressesToGuess;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addFinishListener(IProgressMonitorFinishedListener l) {
        this.finishListeners.add(l);
    }

    public void removeFinishListener(IProgressMonitorFinishedListener l) {
        this.finishListeners.remove(l);
    }

    protected void fireFinished() {
        for (IProgressMonitorFinishedListener l : this.finishListeners) {
            l.finished();
        }
        this.finishListeners.clear();
    }

    public void visit(Node n) {
        if (n == null) {
            return;
        }
        if (this.curAddressNode == null) {
            return;
        }
        LatLon ll = this.curAddressNode.getCoor();
        if (ll == null) {
            return;
        }
        double dist = ll.greatCircleDistance(n.getCoor());
        if (dist < this.minDist) {
            this.minDist = dist;
        }
    }

    public void visit(Way w) {
        if (!TagUtils.hasHighwayTag((OsmPrimitive)w)) {
            return;
        }
        if (!TagUtils.hasNameTag((OsmPrimitive)w)) {
            return;
        }
        for (Node node : w.getNodes()) {
            this.visit(node);
        }
    }

    public void visit(Relation e) {
    }

    public void visit(Changeset cs) {
    }

    protected void cancel() {
        this.cancelled = true;
    }

    protected void finish() {
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (Main.main.getCurrentDataSet() == null || this.addressesToGuess == null) {
            return;
        }
        this.isRunning = true;
        this.cancelled = false;
        this.progressMonitor.subTask(String.valueOf(I18n.tr((String)"Searching")) + "...");
        try {
            this.progressMonitor.setTicksCount(this.addressesToGuess.size());
            ArrayList<OSMAddress> shadowCopy = new ArrayList<OSMAddress>(this.addressesToGuess);
            for (OSMAddress aNode : shadowCopy) {
                this.minDist = Double.MAX_VALUE;
                this.curAddressNode = aNode;
                GuessedValueHandler[] guessers = new GuessedValueHandler[]{new GuessStreetValueHandler("addr:street", aNode), new GuessedValueHandler("addr:postcode", aNode, 500.0), new GuessedValueHandler("addr:city", aNode, 5000.0), new GuessedValueHandler("addr:state", aNode, 5000.0), new GuessedValueHandler("addr:country", aNode, 5000.0), new GuessedValueHandler("addr:city", aNode, 2000.0)};
                if (!aNode.needsGuess()) {
                    this.progressMonitor.worked(1);
                    continue;
                }
                if (this.cancelled) {
                    break;
                }
                this.progressMonitor.subTask(String.valueOf(I18n.tr((String)"Guess values for ")) + aNode);
                for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().allPrimitives()) {
                    if (this.cancelled) break;
                    int i = 0;
                    while (i < guessers.length) {
                        osmPrimitive.visit((Visitor)guessers[i]);
                        if (guessers[i].currentValue == null) {
                            // empty if block
                        }
                        ++i;
                    }
                }
                this.progressMonitor.worked(1);
            }
        }
        finally {
            this.isRunning = false;
            this.fireFinished();
        }
    }

    private class GuessStreetValueHandler
    extends GuessedValueHandler {
        public GuessStreetValueHandler(String tag, OSMAddress aNode) {
            super(tag, aNode, 200.0);
        }

        @Override
        public void visit(Node n) {
        }

        @Override
        public void visit(Way w) {
            OSMAddress aNode;
            double dist;
            if (TagUtils.isStreetSupportingHousenumbers(w) && (dist = OsmUtils.getMinimumDistanceToWay((aNode = this.getAddressNode()).getCoor(), w)) < this.minDist && dist < this.getMaxDistance()) {
                this.minDist = dist;
                this.currentValue = TagUtils.getNameValue((OsmPrimitive)w);
                aNode.setGuessedValue(this.getTag(), this.currentValue, (OsmPrimitive)w);
            }
        }
    }
}

