/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;

public final class TagUtils {
    private static String[] COUNTRIES_REQUIRE_STATE = new String[]{"en_US", "en_AU"};
    public static final String PARKING_TAG = "parking";
    public static final String SHOP_TAG = "shop";
    public static final String CRAFT_TAG = "craft";
    public static final String SURFACE_TAG = "surface";
    public static final String CUISINE_TAG = "cuisine";
    public static final String WOOD_TAG = "wood";
    public static final String FOOT_TAG = "foot";
    public static final String NAME_DE_TAG = "name:de";
    public static final String NAT_REF_TAG = "nat_ref";
    public static final String NOTE_DE_TAG = "note:de";
    public static final String ADDR_STREET_TAG = "addr:street";
    public static final String TYPE_TAG = "type";
    public static final String ADDR_CITY_TAG = "addr:city";
    public static final String BOUNDARY_TAG = "boundary";
    public static final String SMOOTHNESS_TAG = "smoothness";
    public static final String OPENING_HOURS_TAG = "opening_hours";
    public static final String BICYCLE_TAG = "bicycle";
    public static final String RELIGION_TAG = "religion";
    public static final String BARRIER_TAG = "barrier";
    public static final String POWER_TAG = "power";
    public static final String LANDUSE_TAG = "landuse";
    public static final String FIREPLACE_TAG = "fireplace";
    public static final String INT_REF_TAG = "int_ref";
    public static final String WHITEWATER_SECTION_GRADE_TAG = "whitewater:section_grade";
    public static final String DENOMINATION_TAG = "denomination";
    public static final String ADDR_POSTCODE_TAG = "addr:postcode";
    public static final String WIRES_TAG = "wires";
    public static final String LOC_REF_TAG = "loc_ref";
    public static final String WIDTH_TAG = "width";
    public static final String TOURISM_TAG = "tourism";
    public static final String LEISURE_TAG = "leisure";
    public static final String ELECTRIFIED_TAG = "electrified";
    public static final String JUNCTION_TAG = "junction";
    public static final String RAILWAY_TAG = "railway";
    public static final String VOLTAGE_TAG = "voltage";
    public static final String BRIDGE_TAG = "bridge";
    public static final String MOTOR_VEHICLE_TAG = "motor_vehicle";
    public static final String COMMENT_TAG = "comment";
    public static final String MAXSPEED_TAG = "maxspeed";
    public static final String NATURAL_TAG = "natural";
    public static final String BUILDING_HEIGHT_TAG = "building:height";
    public static final String SAC_SCALE_TAG = "sac_scale";
    public static final String TUNNEL_TAG = "tunnel";
    public static final String WATERWAY_TAG = "waterway";
    public static final String TRAIL_VISIBILITY_TAG = "trail_visibility";
    public static final String HIGHWAY_TAG = "highway";
    public static final String VEHICLE_TAG = "vehicle";
    public static final String HORSE_TAG = "horse";
    public static final String GOODS_TAG = "goods";
    public static final String FREQUENCY_TAG = "frequency";
    public static final String MAN_MADE_TAG = "man_made";
    public static final String ADDR_HOUSENUMBER_TAG = "addr:housenumber";
    public static final String AREA_TAG = "area";
    public static final String BUILDING_LEVELS_TAG = "building:levels";
    public static final String WHEELCHAIR_TAG = "wheelchair";
    public static final String NAME_TAG = "name";
    public static final String ONEWAY_TAG = "oneway";
    public static final String FIXME_TAG = "FIXME";
    public static final String CAPACITY_TAG = "capacity";
    public static final String MOTORCYCLE_TAG = "motorcycle";
    public static final String HGV_TAG = "hgv";
    public static final String CONSTRUCTION_TAG = "construction";
    public static final String ADDR_STATE_TAG = "addr:state";
    public static final String LANES_TAG = "lanes";
    public static final String NOTE_TAG = "note";
    public static final String LIT_TAG = "lit";
    public static final String BUILDING_TAG = "building";
    public static final String SEGREGATED_TAG = "segregated";
    public static final String ADDR_INCLUSION_TAG = "addr:inclusion";
    public static final String LAYER_TAG = "layer";
    public static final String SPORT_TAG = "sport";
    public static final String ADDR_INTERPOLATION_TAG = "addr:interpolation";
    public static final String CUTTING_TAG = "cutting";
    public static final String AMENITY_TAG = "amenity";
    public static final String ACCESS_TAG = "access";
    public static final String AGRICULTURAL_TAG = "agricultural";
    public static final String CAPACITY_DISABLED_TAG = "capacity:disabled";
    public static final String OPERATOR_TAG = "operator";
    public static final String REF_TAG = "ref";
    public static final String NOEXIT_TAG = "noexit";
    public static final String ADMIN_LEVEL_TAG = "admin_level";
    public static final String SOURCE_TAG = "source";
    public static final String TRACKTYPE_TAG = "tracktype";
    public static final String ADDR_COUNTRY_TAG = "addr:country";
    public static final String ROUTE_TAG = "route";
    public static final String CABLES_TAG = "cables";
    public static final String SERVICE_TAG = "service";
    public static final String MOTORCAR_TAG = "motorcar";
    public static final String WHITEWATER_TAG = "whitewater";
    public static final String EMBANKMENT_TAG = "embankment";
    public static final String ADDR_HOUSENAME_TAG = "addr:housename";
    public static final String HIGHWAY_CYCLEWAY_VALUE = "cycleway";
    public static final String HIGHWAY_FOOTWAY_VALUE = "footway";
    public static final String HIGHWAY_MOTORWAY_LINK_VALUE = "motorway_link";
    public static final String HIGHWAY_MOTORWAY_VALUE = "motorway";
    public static final String HIGHWAY_PATH_VALUE = "path";
    public static final String HIGHWAY_RESIDENTIAL_VALUE = "residential";
    public static final String HIGHWAY_LIVING_STREET_VALUE = "living_street";
    public static final String HIGHWAY_ROAD_VALUE = "road";
    public static final String HIGHWAY_SECONDARY_VALUE = "secondary";
    public static final String HIGHWAY_SERVICE_VALUE = "service";
    public static final String HIGHWAY_STEPS_VALUE = "steps";
    public static final String HIGHWAY_TERTIARY_VALUE = "tertiary";
    public static final String HIGHWAY_TRACK_VALUE = "track";
    public static final String HIGHWAY_TRUNK_LINK_VALUE = "trunk_link";
    public static final String HIGHWAY_TRUNK_VALUE = "trunk";
    public static final String HIGHWAY_UNCLASSIFIED_VALUE = "unclassified";
    public static final String RELATION_TYPE = "type";
    public static final String ASSOCIATEDSTREET_RELATION_TYPE = "associatedStreet";
    public static final String STREET_RELATION_ROLE = "street";
    public static final String HOUSE_RELATION_ROLE = "house";

    public static boolean hasTag(OsmPrimitive osm, String tag) {
        return osm != null && !StringUtils.isNullOrEmpty(osm.get(tag));
    }

    public static boolean isAddress(OsmPrimitive osmObject) {
        return TagUtils.hasAddrCityTag(osmObject) || TagUtils.hasAddrCountryTag(osmObject) || TagUtils.hasAddrHousenumberTag(osmObject) || TagUtils.hasAddrPostcodeTag(osmObject) || TagUtils.hasAddrStateTag(osmObject) || TagUtils.hasAddrStreetTag(osmObject);
    }

    public static boolean hasParkingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(PARKING_TAG) : false;
    }

    public static String getParkingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(PARKING_TAG) : null;
    }

    public static boolean hasShopTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SHOP_TAG) : false;
    }

    public static String getShopValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SHOP_TAG) : null;
    }

    public static boolean hasCraftTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CRAFT_TAG) : false;
    }

    public static String getCraftValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CRAFT_TAG) : null;
    }

    public static boolean hasSurfaceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SURFACE_TAG) : false;
    }

    public static String getSurfaceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SURFACE_TAG) : null;
    }

    public static boolean hasCuisineTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CUISINE_TAG) : false;
    }

    public static String getCuisineValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CUISINE_TAG) : null;
    }

    public static boolean hasWoodTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WOOD_TAG) : false;
    }

    public static String getWoodValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WOOD_TAG) : null;
    }

    public static boolean hasFootTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(FOOT_TAG) : false;
    }

    public static String getFootValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(FOOT_TAG) : null;
    }

    public static boolean hasNameDeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NAME_DE_TAG) : false;
    }

    public static String getNameDeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NAME_DE_TAG) : null;
    }

    public static boolean hasNatRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NAT_REF_TAG) : false;
    }

    public static String getNatRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NAT_REF_TAG) : null;
    }

    public static boolean hasNoteDeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NOTE_DE_TAG) : false;
    }

    public static String getNoteDeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NOTE_DE_TAG) : null;
    }

    public static boolean hasAddrStreetTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_STREET_TAG) : false;
    }

    public static String getAddrStreetValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_STREET_TAG) : null;
    }

    public static boolean hasTypeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("type") : false;
    }

    public static String getTypeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("type") : null;
    }

    public static boolean hasAddrCityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_CITY_TAG) : false;
    }

    public static String getAddrCityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_CITY_TAG) : null;
    }

    public static boolean hasBoundaryTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BOUNDARY_TAG) : false;
    }

    public static String getBoundaryValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BOUNDARY_TAG) : null;
    }

    public static boolean hasSmoothnessTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SMOOTHNESS_TAG) : false;
    }

    public static String getSmoothnessValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SMOOTHNESS_TAG) : null;
    }

    public static boolean hasOpeningHoursTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(OPENING_HOURS_TAG) : false;
    }

    public static String getOpeningHoursValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(OPENING_HOURS_TAG) : null;
    }

    public static boolean hasBicycleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BICYCLE_TAG) : false;
    }

    public static String getBicycleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BICYCLE_TAG) : null;
    }

    public static boolean hasReligionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(RELIGION_TAG) : false;
    }

    public static String getReligionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(RELIGION_TAG) : null;
    }

    public static boolean hasBarrierTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BARRIER_TAG) : false;
    }

    public static String getBarrierValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BARRIER_TAG) : null;
    }

    public static boolean hasPowerTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(POWER_TAG) : false;
    }

    public static String getPowerValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(POWER_TAG) : null;
    }

    public static boolean hasLanduseTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LANDUSE_TAG) : false;
    }

    public static String getLanduseValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LANDUSE_TAG) : null;
    }

    public static boolean hasFireplaceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(FIREPLACE_TAG) : false;
    }

    public static String getFireplaceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(FIREPLACE_TAG) : null;
    }

    public static boolean hasIntRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(INT_REF_TAG) : false;
    }

    public static String getIntRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(INT_REF_TAG) : null;
    }

    public static boolean hasWhitewaterSectionGradeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WHITEWATER_SECTION_GRADE_TAG) : false;
    }

    public static String getWhitewaterSectionGradeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WHITEWATER_SECTION_GRADE_TAG) : null;
    }

    public static boolean hasDenominationTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(DENOMINATION_TAG) : false;
    }

    public static String getDenominationValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(DENOMINATION_TAG) : null;
    }

    public static boolean hasAddrPostcodeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_POSTCODE_TAG) : false;
    }

    public static String getAddrPostcodeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_POSTCODE_TAG) : null;
    }

    public static boolean hasWiresTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WIRES_TAG) : false;
    }

    public static String getWiresValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WIRES_TAG) : null;
    }

    public static boolean hasLocRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LOC_REF_TAG) : false;
    }

    public static String getLocRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LOC_REF_TAG) : null;
    }

    public static boolean hasWidthTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WIDTH_TAG) : false;
    }

    public static String getWidthValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WIDTH_TAG) : null;
    }

    public static boolean hasTourismTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(TOURISM_TAG) : false;
    }

    public static String getTourismValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(TOURISM_TAG) : null;
    }

    public static boolean hasLeisureTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LEISURE_TAG) : false;
    }

    public static String getLeisureValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LEISURE_TAG) : null;
    }

    public static boolean hasElectrifiedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ELECTRIFIED_TAG) : false;
    }

    public static String getElectrifiedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ELECTRIFIED_TAG) : null;
    }

    public static boolean hasJunctionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(JUNCTION_TAG) : false;
    }

    public static String getJunctionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(JUNCTION_TAG) : null;
    }

    public static boolean hasRailwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(RAILWAY_TAG) : false;
    }

    public static String getRailwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(RAILWAY_TAG) : null;
    }

    public static boolean hasVoltageTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(VOLTAGE_TAG) : false;
    }

    public static String getVoltageValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(VOLTAGE_TAG) : null;
    }

    public static boolean hasBridgeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BRIDGE_TAG) : false;
    }

    public static String getBridgeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BRIDGE_TAG) : null;
    }

    public static boolean hasMotorVehicleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(MOTOR_VEHICLE_TAG) : false;
    }

    public static String getMotorVehicleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(MOTOR_VEHICLE_TAG) : null;
    }

    public static boolean hasCommentTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(COMMENT_TAG) : false;
    }

    public static String getCommentValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(COMMENT_TAG) : null;
    }

    public static boolean hasMaxspeedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(MAXSPEED_TAG) : false;
    }

    public static String getMaxspeedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(MAXSPEED_TAG) : null;
    }

    public static boolean hasNaturalTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NATURAL_TAG) : false;
    }

    public static String getNaturalValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NATURAL_TAG) : null;
    }

    public static boolean hasSacScaleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SAC_SCALE_TAG) : false;
    }

    public static String getSacScaleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SAC_SCALE_TAG) : null;
    }

    public static boolean hasTunnelTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(TUNNEL_TAG) : false;
    }

    public static String getTunnelValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(TUNNEL_TAG) : null;
    }

    public static boolean hasWaterwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WATERWAY_TAG) : false;
    }

    public static String getWaterwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WATERWAY_TAG) : null;
    }

    public static boolean hasTrailVisibilityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(TRAIL_VISIBILITY_TAG) : false;
    }

    public static String getTrailVisibilityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(TRAIL_VISIBILITY_TAG) : null;
    }

    public static boolean hasHighwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(HIGHWAY_TAG) : false;
    }

    public static String getHighwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(HIGHWAY_TAG) : null;
    }

    public static boolean hasVehicleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(VEHICLE_TAG) : false;
    }

    public static String getVehicleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(VEHICLE_TAG) : null;
    }

    public static boolean hasHorseTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(HORSE_TAG) : false;
    }

    public static String getHorseValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(HORSE_TAG) : null;
    }

    public static boolean hasGoodsTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(GOODS_TAG) : false;
    }

    public static String getGoodsValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(GOODS_TAG) : null;
    }

    public static boolean hasFrequencyTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(FREQUENCY_TAG) : false;
    }

    public static String getFrequencyValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(FREQUENCY_TAG) : null;
    }

    public static boolean hasManMadeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(MAN_MADE_TAG) : false;
    }

    public static String getManMadeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(MAN_MADE_TAG) : null;
    }

    public static boolean hasAddrHousenumberTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_HOUSENUMBER_TAG) : false;
    }

    public static String getAddrHousenumberValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_HOUSENUMBER_TAG) : null;
    }

    public static boolean hasAddrHousenameTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_HOUSENAME_TAG) : false;
    }

    public static String getAddrHousenameValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_HOUSENAME_TAG) : null;
    }

    public static boolean hasAreaTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(AREA_TAG) : false;
    }

    public static String getAreaValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(AREA_TAG) : null;
    }

    public static boolean hasBuildingLevelsTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BUILDING_LEVELS_TAG) : false;
    }

    public static String getBuildingLevelsValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BUILDING_LEVELS_TAG) : null;
    }

    public static boolean hasWheelchairTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WHEELCHAIR_TAG) : false;
    }

    public static String getWheelchairValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WHEELCHAIR_TAG) : null;
    }

    public static boolean hasNameTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NAME_TAG) : false;
    }

    public static String getNameValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NAME_TAG) : null;
    }

    public static boolean hasOnewayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ONEWAY_TAG) : false;
    }

    public static String getOnewayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ONEWAY_TAG) : null;
    }

    public static boolean hasFIXMETag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(FIXME_TAG) : false;
    }

    public static String getFIXMEValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(FIXME_TAG) : null;
    }

    public static boolean hasCapacityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CAPACITY_TAG) : false;
    }

    public static String getCapacityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CAPACITY_TAG) : null;
    }

    public static boolean hasMotorcycleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(MOTORCYCLE_TAG) : false;
    }

    public static String getMotorcycleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(MOTORCYCLE_TAG) : null;
    }

    public static boolean hasHgvTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(HGV_TAG) : false;
    }

    public static String getHgvValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(HGV_TAG) : null;
    }

    public static boolean hasConstructionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CONSTRUCTION_TAG) : false;
    }

    public static String getConstructionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CONSTRUCTION_TAG) : null;
    }

    public static boolean hasAddrStateTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_STATE_TAG) : false;
    }

    public static String getAddrStateValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_STATE_TAG) : null;
    }

    public static boolean hasLanesTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LANES_TAG) : false;
    }

    public static String getLanesValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LANES_TAG) : null;
    }

    public static boolean hasNoteTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NOTE_TAG) : false;
    }

    public static String getNoteValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NOTE_TAG) : null;
    }

    public static boolean hasLitTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LIT_TAG) : false;
    }

    public static String getLitValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LIT_TAG) : null;
    }

    public static boolean hasBuildingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(BUILDING_TAG) : false;
    }

    public static String getBuildingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(BUILDING_TAG) : null;
    }

    public static boolean hasSegregatedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SEGREGATED_TAG) : false;
    }

    public static String getSegregatedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SEGREGATED_TAG) : null;
    }

    public static boolean hasAddrInclusionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_INCLUSION_TAG) : false;
    }

    public static String getAddrInclusionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_INCLUSION_TAG) : null;
    }

    public static boolean hasLayerTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(LAYER_TAG) : false;
    }

    public static String getLayerValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(LAYER_TAG) : null;
    }

    public static boolean hasSportTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SPORT_TAG) : false;
    }

    public static String getSportValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SPORT_TAG) : null;
    }

    public static boolean hasAddrInterpolationTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_INTERPOLATION_TAG) : false;
    }

    public static String getAddrInterpolationValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_INTERPOLATION_TAG) : null;
    }

    public static boolean hasCuttingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CUTTING_TAG) : false;
    }

    public static String getCuttingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CUTTING_TAG) : null;
    }

    public static boolean hasAmenityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(AMENITY_TAG) : false;
    }

    public static String getAmenityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(AMENITY_TAG) : null;
    }

    public static boolean hasAccessTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ACCESS_TAG) : false;
    }

    public static String getAccessValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ACCESS_TAG) : null;
    }

    public static boolean hasAgriculturalTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(AGRICULTURAL_TAG) : false;
    }

    public static String getAgriculturalValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(AGRICULTURAL_TAG) : null;
    }

    public static boolean hasCapacityDisabledTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CAPACITY_DISABLED_TAG) : false;
    }

    public static String getCapacityDisabledValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CAPACITY_DISABLED_TAG) : null;
    }

    public static boolean hasOperatorTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(OPERATOR_TAG) : false;
    }

    public static String getOperatorValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(OPERATOR_TAG) : null;
    }

    public static boolean hasRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(REF_TAG) : false;
    }

    public static String getRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(REF_TAG) : null;
    }

    public static boolean hasNoexitTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(NOEXIT_TAG) : false;
    }

    public static String getNoexitValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(NOEXIT_TAG) : null;
    }

    public static boolean hasAdminLevelTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADMIN_LEVEL_TAG) : false;
    }

    public static String getAdminLevelValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADMIN_LEVEL_TAG) : null;
    }

    public static boolean hasSourceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(SOURCE_TAG) : false;
    }

    public static String getSourceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(SOURCE_TAG) : null;
    }

    public static boolean hasTracktypeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(TRACKTYPE_TAG) : false;
    }

    public static String getTracktypeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(TRACKTYPE_TAG) : null;
    }

    public static boolean hasAddrCountryTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ADDR_COUNTRY_TAG) : false;
    }

    public static String getAddrCountryValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ADDR_COUNTRY_TAG) : null;
    }

    public static boolean hasRouteTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(ROUTE_TAG) : false;
    }

    public static String getRouteValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(ROUTE_TAG) : null;
    }

    public static boolean hasCablesTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(CABLES_TAG) : false;
    }

    public static String getCablesValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(CABLES_TAG) : null;
    }

    public static boolean hasServiceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("service") : false;
    }

    public static String getServiceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("service") : null;
    }

    public static boolean hasMotorcarTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(MOTORCAR_TAG) : false;
    }

    public static String getMotorcarValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(MOTORCAR_TAG) : null;
    }

    public static boolean hasWhitewaterTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(WHITEWATER_TAG) : false;
    }

    public static String getWhitewaterValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(WHITEWATER_TAG) : null;
    }

    public static boolean hasEmbankmentTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey(EMBANKMENT_TAG) : false;
    }

    public static String getEmbankmentValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get(EMBANKMENT_TAG) : null;
    }

    public static boolean isStreetSupportingHousenumbers(Way w) {
        if (w == null) {
            return false;
        }
        return TagUtils.hasHighwayTag((OsmPrimitive)w);
    }

    public static boolean isAssociatedStreetRelation(Relation rel) {
        return rel != null && rel.hasKey("type") && ASSOCIATEDSTREET_RELATION_TYPE.equals(rel.get("type"));
    }

    public static boolean isStreetMember(RelationMember relMember) {
        return relMember != null && STREET_RELATION_ROLE.equals(relMember.getRole());
    }

    public static boolean isHouseMember(RelationMember relMember) {
        return relMember != null && STREET_RELATION_ROLE.equals(relMember.getRole());
    }

    public static boolean isStateRequired() {
        String loc = OsmUtils.getLocale();
        int i = 0;
        while (i < COUNTRIES_REQUIRE_STATE.length) {
            if (COUNTRIES_REQUIRE_STATE[i].equals(loc)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

