/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.HashMap;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreetSegment;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class OsmFactory {
    private static HashMap<String, OSMAddress> addressCache = new HashMap();

    public static OSMAddress createNode(Node node) {
        if (TagUtils.isAddress((OsmPrimitive)node)) {
            String aid = "" + node.getId();
            OSMAddress aNode = OsmFactory.lookup(aid);
            if (aNode == null) {
                aNode = new OSMAddress((OsmPrimitive)node);
                addressCache.put(aid, aNode);
            } else {
                aNode.setOsmObject((OsmPrimitive)node);
            }
            return aNode;
        }
        return null;
    }

    public static IOSMEntity createNodeFromWay(Way way) {
        if (TagUtils.hasHighwayTag((OsmPrimitive)way)) {
            return new OSMStreetSegment((OsmPrimitive)way);
        }
        if (way.isClosed() && TagUtils.hasBuildingTag((OsmPrimitive)way) && TagUtils.isAddress((OsmPrimitive)way)) {
            String aid = "" + way.getId();
            OSMAddress aNode = OsmFactory.lookup(aid);
            if (aNode == null) {
                aNode = new OSMAddress((OsmPrimitive)way);
                addressCache.put(aid, aNode);
            } else {
                aNode.setOsmObject((OsmPrimitive)way);
            }
            return aNode;
        }
        return null;
    }

    private static OSMAddress lookup(String aid) {
        if (addressCache.containsKey(aid)) {
            return addressCache.get(aid);
        }
        return null;
    }
}

