/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.GuessAddressRunnable;
import org.openstreetmap.josm.plugins.fixAddresses.IProgressMonitorFinishedListener;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class GuessAddressDataAction
extends AbstractAddressEditAction
implements IProgressMonitorFinishedListener {
    public GuessAddressDataAction() {
        super(I18n.tr((String)"Guess address data"), "guessstreets_24", I18n.tr((String)"Tries to guess address data by picking the name of the closest object with according tag."));
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev != null && ev.hasAddresses());
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfInvalidAddresses() > 0);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null || container.getNumberOfInvalidAddresses() == 0) {
            return;
        }
        this.internalGuessAddresses(container.getAllAddressesToFix());
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null || !ev.hasAddresses()) {
            return;
        }
        this.internalGuessAddresses(ev.getSelectedIncompleteAddresses());
        this.internalGuessAddresses(ev.getSelectedUnresolvedAddresses());
    }

    private void internalGuessAddresses(List<OSMAddress> nodes) {
        if (nodes == null) {
            return;
        }
        GuessAddressRunnable aft = new GuessAddressRunnable(nodes, I18n.tr((String)"Guessing address values"));
        aft.addFinishListener(this);
        Main.worker.submit((Runnable)((Object)aft));
    }

    @Override
    public void finished() {
        if (this.container != null) {
            this.container.invalidate();
        }
    }
}

