/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class StreetTableModel
extends AddressEditTableModel {
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Type"), I18n.tr((String)"Name"), I18n.tr((String)"Segments"), I18n.tr((String)"Addresses"), I18n.tr((String)"Relation")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, Integer.class, Boolean.class};
    private static final long serialVersionUID = 424009321818130586L;

    public StreetTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfStreets();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMStreet sNode = (OSMStreet)this.getEntityOfRow(row);
        if (sNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return sNode.getType();
            }
            case 1: {
                return sNode.getName();
            }
            case 2: {
                return sNode.getNumberOfSegments();
            }
            case 3: {
                return sNode.getNumberOfAddresses();
            }
            case 4: {
                return sNode.hasAssociatedStreetRelation();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfStreets()) {
            return null;
        }
        return this.addressContainer.getStreetList().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getStreetList() == null) {
            return -1;
        }
        return this.addressContainer.getStreetList().indexOf(entity);
    }
}

