/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;

public class GuessedValueHandler
implements Visitor {
    private static final double DEFAULT_MAX_DIST = 100.0;
    private String tag;
    protected double minDist;
    protected String currentValue;
    private OSMAddress aNode;
    private double maxDist = 100.0;

    public GuessedValueHandler(String tag, OSMAddress aNode) {
        this(tag, aNode, 100.0);
    }

    public GuessedValueHandler(String tag, OSMAddress aNode, double maxDist) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new RuntimeException("Tag must not be empty or null!");
        }
        if (aNode == null) {
            throw new RuntimeException("Address node must not be null!");
        }
        if (maxDist < 1.0) {
            maxDist = 1.0;
        }
        this.tag = tag;
        this.minDist = Double.MAX_VALUE;
        this.aNode = aNode;
        this.maxDist = maxDist;
    }

    protected OSMAddress getAddressNode() {
        return this.aNode;
    }

    protected double getMaxDistance() {
        return this.maxDist;
    }

    protected String getTag() {
        return this.tag;
    }

    protected double getMinimumDist() {
        return this.minDist;
    }

    protected String getCurrentValue() {
        return this.currentValue;
    }

    public boolean needsGuess() {
        return this.aNode.needsGuessedValue(this.tag);
    }

    public void visit(Node n) {
        double dist;
        if (n.hasKey(this.tag) && (dist = n.getCoor().greatCircleDistance(this.aNode.getCoor())) < this.minDist && dist < this.maxDist) {
            this.minDist = dist;
            this.currentValue = n.get(this.tag);
            this.aNode.setGuessedValue(this.tag, this.currentValue);
        }
    }

    public void visit(Way w) {
        double dist;
        if (w.hasKey(this.tag) && (dist = OsmUtils.getMinimumDistanceToWay(this.aNode.getCoor(), w)) < this.minDist && dist < this.maxDist) {
            this.minDist = dist;
            this.currentValue = w.get(this.tag);
            this.aNode.setGuessedValue(this.tag, this.currentValue);
        }
    }

    public void visit(Relation e) {
    }

    public void visit(Changeset cs) {
    }
}

