/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.StreetNode;
import org.openstreetmap.josm.tools.I18n;

public class AddressEditModel {
    private List<StreetNode> streets;
    private List<AddressNode> unresolvedAddresses;
    private List<AddressNode> incompleteAddresses = new ArrayList<AddressNode>();
    private DefaultMutableTreeNode streetRoot;
    private DefaultMutableTreeNode unresolvedRoot;
    private DefaultMutableTreeNode incompleteRoot;

    public AddressEditModel(List<StreetNode> streets, List<AddressNode> unresolvedAddresses) {
        this.streets = streets;
        this.unresolvedAddresses = unresolvedAddresses;
    }

    public TreeNode getStreetsTree() {
        if (this.streets == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)"));
        }
        if (this.streetRoot == null) {
            this.streetRoot = new DefaultMutableTreeNode();
            for (StreetNode sNode : this.streets) {
                DefaultMutableTreeNode treeStreetNode = new DefaultMutableTreeNode(sNode);
                DefaultMutableTreeNode segmentsNode = new DefaultMutableTreeNode(I18n.tr((String)"Segments"));
                treeStreetNode.add(segmentsNode);
                for (INodeEntity child : sNode.getChildren()) {
                    segmentsNode.add(new DefaultMutableTreeNode(child));
                }
                if (sNode.hasAddresses()) {
                    DefaultMutableTreeNode addressNode = new DefaultMutableTreeNode(I18n.tr((String)"Addresses"));
                    treeStreetNode.add(addressNode);
                    for (AddressNode addr : sNode.getAddresses()) {
                        addressNode.add(new DefaultMutableTreeNode(addr));
                        if (addr.isComplete()) continue;
                        this.incompleteAddresses.add(addr);
                    }
                }
                this.streetRoot.add(treeStreetNode);
            }
        }
        return this.streetRoot;
    }

    public TreeNode getUnresolvedAddressesTree() {
        if (this.unresolvedAddresses == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)"));
        }
        if (this.unresolvedRoot == null) {
            this.unresolvedRoot = new DefaultMutableTreeNode();
            for (AddressNode addr : this.unresolvedAddresses) {
                this.unresolvedRoot.add(new DefaultMutableTreeNode(addr));
            }
        }
        return this.unresolvedRoot;
    }

    public TreeNode getIncompleteAddressesTree() {
        if (this.incompleteAddresses == null) {
            return new DefaultMutableTreeNode(I18n.tr((String)"(No data)"));
        }
        if (this.incompleteRoot == null) {
            this.incompleteRoot = new DefaultMutableTreeNode();
            for (AddressNode addr : this.incompleteAddresses) {
                this.incompleteRoot.add(new DefaultMutableTreeNode(addr));
            }
        }
        return this.incompleteRoot;
    }
}

