/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.HashMap;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.StreetSegmentNode;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class NodeFactory {
    private static HashMap<String, AddressNode> addressCache = new HashMap();

    public static AddressNode createNode(Node node) {
        if (TagUtils.isAddress((OsmPrimitive)node)) {
            String aid = "" + node.getId();
            AddressNode aNode = NodeFactory.lookup(aid);
            if (aNode == null) {
                aNode = new AddressNode((OsmPrimitive)node);
                addressCache.put(aid, aNode);
            } else {
                aNode.setOsmObject((OsmPrimitive)node);
            }
            return aNode;
        }
        return null;
    }

    public static INodeEntity createNodeFromWay(Way way) {
        if (TagUtils.hasHighwayTag((OsmPrimitive)way)) {
            return new StreetSegmentNode((OsmPrimitive)way);
        }
        if (way.isClosed() && TagUtils.hasBuildingTag((OsmPrimitive)way) && TagUtils.isAddress((OsmPrimitive)way)) {
            String aid = "" + way.getId();
            AddressNode aNode = NodeFactory.lookup(aid);
            if (aNode == null) {
                aNode = new AddressNode((OsmPrimitive)way);
                addressCache.put(aid, aNode);
            } else {
                aNode.setOsmObject((OsmPrimitive)way);
            }
            return aNode;
        }
        return null;
    }

    private static AddressNode lookup(String aid) {
        if (addressCache.containsKey(aid)) {
            return addressCache.get(aid);
        }
        return null;
    }
}

