/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.StreetNode;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

public class AssignAddressToStreetAction
extends AbstractAddressEditAction {
    private static final long serialVersionUID = -6180491357232121384L;

    public AssignAddressToStreetAction() {
        super(I18n.tr((String)"Assign address to street"), "assignstreet_24", "Assign the selected address(es) to the selected street.");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        StreetNode streetNode = ev.getSelectedStreet();
        if (streetNode != null && ev.getSelectedUnresolvedAddresses() != null) {
            this.beginTransaction(String.valueOf(I18n.tr((String)"Set street name")) + " '" + streetNode.getName() + "'");
            for (AddressNode addrNode : ev.getSelectedUnresolvedAddresses()) {
                this.beginObjectTransaction(addrNode);
                addrNode.assignStreet(streetNode);
                this.finishObjectTransaction(addrNode);
            }
            this.finishTransaction();
        }
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev.getSelectedStreet() != null && ev.getSelectedUnresolvedAddresses() != null);
    }

    @Override
    public void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
    }
}

