/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.NodeEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.StreetSegmentNode;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class StreetNode
extends NodeEntityBase {
    private List<INodeEntity> children;
    private List<AddressNode> addresses;

    public StreetNode(OsmPrimitive osmPrimitive) {
        super(osmPrimitive);
    }

    @Override
    public List<INodeEntity> getChildren() {
        return this.children;
    }

    public void addStreetSegment(StreetSegmentNode segment) {
        this.lazyCreateChildren();
        this.children.add(segment);
        Collections.sort(this.children);
    }

    private void lazyCreateChildren() {
        if (this.children == null) {
            this.children = new ArrayList<INodeEntity>();
        }
    }

    public void addAddress(AddressNode aNode) {
        this.lazyCreateAddresses();
        this.addresses.add(aNode);
    }

    private void lazyCreateAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<AddressNode>();
        }
    }

    public boolean hasAddresses() {
        return this.addresses != null && this.addresses.size() > 0;
    }

    public List<AddressNode> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<AddressNode> addresses) {
        this.addresses = addresses;
    }

    public int getNumberOfAddresses() {
        if (this.addresses == null) {
            return 0;
        }
        return this.addresses.size();
    }

    public int getNumberOfSegments() {
        if (this.children == null) {
            return 0;
        }
        int sc = 0;
        for (INodeEntity node : this.children) {
            if (!(node instanceof StreetSegmentNode)) continue;
            ++sc;
        }
        return sc;
    }

    public String getType() {
        ArrayList<String> types = new ArrayList<String>();
        for (INodeEntity seg : this.getChildren()) {
            String val;
            OsmPrimitive osmPrim = seg.getOsmObject();
            if (!TagUtils.hasHighwayTag(osmPrim) || types.contains(val = osmPrim.get("highway"))) continue;
            types.add(val);
        }
        StringBuffer sb = new StringBuffer(20);
        for (String string : types) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(string);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName());
        if (this.children != null) {
            sb.append(String.format(", %d segments", this.children.size()));
        }
        if (this.addresses != null) {
            sb.append(String.format(", %d address entries", this.addresses.size()));
        }
        return sb.toString();
    }
}

