/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.INodeEntity;
import org.openstreetmap.josm.plugins.fixAddresses.NodeEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.StreetNode;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class AddressNode
extends NodeEntityBase {
    public static final String MISSING_TAG = "?";
    private String guessedStreetName;

    public AddressNode(OsmPrimitive osmObject) {
        super(osmObject);
    }

    @Override
    public void setOsmObject(OsmPrimitive osmObject) {
        super.setOsmObject(osmObject);
    }

    public boolean isComplete() {
        return TagUtils.hasAddrCityTag(this.osmObject) && TagUtils.hasAddrCountryTag(this.osmObject) && TagUtils.hasAddrHousenumberTag(this.osmObject) && TagUtils.hasAddrPostcodeTag(this.osmObject) && TagUtils.hasAddrStateTag(this.osmObject) && TagUtils.hasAddrStreetTag(this.osmObject);
    }

    public String getStreet() {
        if (this.osmObject == null) {
            return MISSING_TAG;
        }
        if (!TagUtils.hasAddrStreetTag(this.osmObject)) {
            return MISSING_TAG;
        }
        String sName = TagUtils.getAddrStreetValue(this.osmObject);
        if (!StringUtils.isNullOrEmpty(sName)) {
            return sName;
        }
        return MISSING_TAG;
    }

    public boolean hasStreetName() {
        return TagUtils.hasAddrStreetTag(this.osmObject);
    }

    public String getGuessedStreetName() {
        return this.guessedStreetName;
    }

    public void setGuessedStreetName(String guessedStreetName) {
        this.guessedStreetName = guessedStreetName;
    }

    public boolean hasGuessedStreetName() {
        return !StringUtils.isNullOrEmpty(this.guessedStreetName);
    }

    public boolean hasGuesses() {
        return this.hasGuessedStreetName();
    }

    public void applyAllGuesses() {
        if (this.hasGuessedStreetName()) {
            this.applyGuessedStreet();
        }
    }

    public String getPostCode() {
        if (!TagUtils.hasAddrPostcodeTag(this.osmObject)) {
            return MISSING_TAG;
        }
        return TagUtils.getAddrPostcodeValue(this.osmObject);
    }

    public String getHouseNumber() {
        if (!TagUtils.hasAddrHousenumberTag(this.osmObject)) {
            return MISSING_TAG;
        }
        return TagUtils.getAddrHousenumberValue(this.osmObject);
    }

    public String getCity() {
        if (!TagUtils.hasAddrCityTag(this.osmObject)) {
            return MISSING_TAG;
        }
        return TagUtils.getAddrCityValue(this.osmObject);
    }

    public String getState() {
        if (!TagUtils.hasAddrStateTag(this.osmObject)) {
            return MISSING_TAG;
        }
        return TagUtils.getAddrStateValue(this.osmObject);
    }

    public String getCountry() {
        if (!TagUtils.hasAddrCountryTag(this.osmObject)) {
            return MISSING_TAG;
        }
        return TagUtils.getAddrCountryValue(this.osmObject);
    }

    public void removeAllAddressTags() {
        this.removeOSMTag("addr:city");
        this.removeOSMTag("addr:country");
        this.removeOSMTag("addr:postcode");
        this.removeOSMTag("addr:housenumber");
        this.removeOSMTag("addr:state");
        this.removeOSMTag("addr:street");
    }

    @Override
    public int compareTo(INodeEntity o) {
        if (o == null || !(o instanceof AddressNode)) {
            return -1;
        }
        AddressNode other = (AddressNode)o;
        int cc = 0;
        cc = this.getCountry().compareTo(other.getCountry());
        if (cc == 0 && (cc = this.getState().compareTo(other.getState())) == 0 && (cc = this.getCity().compareTo(other.getCity())) == 0 && (cc = this.getStreet().compareTo(other.getStreet())) == 0) {
            if (this.hasGuessedStreetName()) {
                if (other.hasStreetName()) {
                    cc = this.getGuessedStreetName().compareTo(other.getStreet());
                    if (cc == 0) {
                        cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                    }
                } else if (other.hasGuessedStreetName() && (cc = this.getGuessedStreetName().compareTo(other.getGuessedStreetName())) == 0) {
                    cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                }
            } else {
                cc = this.getHouseNumber().compareTo(other.getHouseNumber());
            }
        }
        return cc;
    }

    public void assignStreet(StreetNode node) {
        if (node == null || !node.hasName()) {
            return;
        }
        if (!node.getName().equals(this.getStreet())) {
            this.setStreetName(node.getName());
            node.addAddress(this);
            AddressNode.fireEntityChanged(this);
        }
    }

    public void applyGuessedStreet() {
        if (this.hasGuessedStreetName()) {
            this.setOSMTag("addr:street", this.guessedStreetName);
        }
    }

    public void setStreetName(String streetName) {
        if (streetName != null && streetName.length() == 0) {
            return;
        }
        this.setOSMTag("addr:street", streetName);
    }

    public void setState(String state) {
        if (state != null && state.length() == 0) {
            return;
        }
        this.setOSMTag("addr:state", state);
    }

    public void setCountry(String country) {
        if (country != null && country.length() == 0) {
            return;
        }
        this.setOSMTag("addr:country", country);
    }

    public void setPostCode(String postCode) {
        if (postCode != null && postCode.length() == 0) {
            return;
        }
        this.setOSMTag("addr:postcode", postCode);
    }

    @Override
    public String toString() {
        return AddressNode.getFormatString(this);
    }

    public static String getFormatString(AddressNode node) {
        String guessed = node.getGuessedStreetName();
        String sName = node.getStreet();
        if (!StringUtils.isNullOrEmpty(guessed) && MISSING_TAG.equals(sName)) {
            sName = String.format("(%s)", guessed);
        }
        return String.format("%s %s, %s-%s %s (%s) ", sName, node.getHouseNumber(), node.getCountry(), node.getPostCode(), node.getCity(), node.getState());
    }
}

