/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.AddressFinderThread;
import org.openstreetmap.josm.plugins.fixAddresses.AddressNode;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AbstractAddressEditAction;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuessAddressDataAction
extends AbstractAddressEditAction {
    private static final int THREAD_COUNT = 5;
    private AddressFinderThread[] threads = new AddressFinderThread[5];

    public GuessAddressDataAction() {
        super(I18n.tr((String)"Guess address data"), "guessstreets_24", "Tries to guess the street name by picking the name of the closest way.");
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev != null && ev.getUnresolvedAddressTable() != null);
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfIncompleteAddresses() > 0);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null) {
            return;
        }
        if (container.getUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(container.getIncompleteAddresses());
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null || ev.getSelectedUnresolvedAddresses() == null) {
            return;
        }
        this.internalGuessAddresses(ev.getSelectedUnresolvedAddresses());
    }

    private void internalGuessAddresses(List<AddressNode> nodes) {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new AddressFinderThread();
        }
        ArrayList<AddressNode> addrNodes = new ArrayList<AddressNode>(nodes);
        for (AddressNode aNode : addrNodes) {
            if (aNode.hasStreetName()) continue;
            while (!this.scheduleNode(aNode)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        this.container.containerChanged(this.container);
    }

    private boolean scheduleNode(AddressNode aNode) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i].isRunning()) continue;
            this.threads[i].setAddressNode(aNode);
            this.threads[i].run();
            return true;
        }
        return false;
    }
}

