/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral;

import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheAdaptor;
import org.apache.commons.jcs3.engine.CacheEventQueueFactory;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LateralCacheNoWait<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(LateralCacheNoWait.class);
    private final LateralCache<K, V> cache;
    private String identityKey;
    private ICacheEventQueue<K, V> eventQueue;
    private int getCount;
    private int removeCount;
    private int putCount;

    public LateralCacheNoWait(LateralCache<K, V> cache) {
        this.cache = cache;
        this.identityKey = cache.getCacheName();
        this.setCacheEventLogger(cache.getCacheEventLogger());
        this.setElementSerializer(cache.getElementSerializer());
        log.debug("Constructing LateralCacheNoWait, LateralCache = [{0}]", cache);
        CacheEventQueueFactory<K, V> fact = new CacheEventQueueFactory<K, V>();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor<K, V>(cache), CacheInfo.listenerId, cache.getCacheName(), this.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.getAuxiliaryCacheAttributes().getEventQueueType());
        if (cache.getStatus() == CacheStatus.ERROR) {
            this.eventQueue.destroy();
        }
    }

    public String getIdentityKey() {
        return this.identityKey;
    }

    public void setIdentityKey(String identityKey) {
        this.identityKey = identityKey;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        ++this.putCount;
        try {
            this.eventQueue.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        ++this.getCount;
        if (this.getStatus() != CacheStatus.ERROR) {
            try {
                return this.cache.get(key);
            }
            catch (UnmarshalException ue) {
                log.debug("Retrying the get owing to UnmarshalException...");
                try {
                    return this.cache.get(key);
                }
                catch (IOException ex) {
                    log.error("Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            return keys.stream().collect(Collectors.toMap(key -> key, this::get)).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return new HashMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        ++this.getCount;
        if (this.getStatus() != CacheStatus.ERROR) {
            try {
                return this.cache.getMatching(pattern);
            }
            catch (UnmarshalException ue) {
                log.debug("Retrying the get owing to UnmarshalException.");
                try {
                    return this.cache.getMatching(pattern);
                }
                catch (IOException ex) {
                    log.error("Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        try {
            return this.cache.getKeySet();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
            return Collections.emptySet();
        }
    }

    @Override
    public boolean remove(K key) {
        ++this.removeCount;
        try {
            this.eventQueue.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
        return false;
    }

    @Override
    public void removeAll() {
        try {
            this.eventQueue.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public void dispose() {
        try {
            this.eventQueue.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public int getSize() {
        return this.cache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return this.cache.getCacheType();
    }

    @Override
    public CacheStatus getStatus() {
        return this.eventQueue.isWorking() ? this.cache.getStatus() : CacheStatus.ERROR;
    }

    @Override
    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(ICacheServiceNonLocal<K, V> lateral) {
        this.cache.fixCache(lateral);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.eventQueue.isWorking()) {
            this.eventQueue.destroy();
        }
        CacheEventQueueFactory<K, V> fact = new CacheEventQueueFactory<K, V>();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor<K, V>(this.cache), CacheInfo.listenerId, this.cache.getCacheName(), this.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.getAuxiliaryCacheAttributes().getEventQueueType());
    }

    @Override
    public ILateralCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cache.getAuxiliaryCacheAttributes();
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait");
        IStats eqStats = this.eventQueue.getStatistics();
        ArrayList elems = new ArrayList(eqStats.getStatElements());
        elems.add(new StatElement<Integer>("Get Count", this.getCount));
        elems.add(new StatElement<Integer>("Remove Count", this.removeCount));
        elems.add(new StatElement<Integer>("Put Count", this.putCount));
        elems.add(new StatElement<ILateralCacheAttributes>("Attributes", this.cache.getAuxiliaryCacheAttributes()));
        stats.setStatElements(elems);
        return stats;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" LateralCacheNoWait ");
        buf.append(" Status = " + (Object)((Object)this.getStatus()));
        buf.append(" cache = [" + this.cache.toString() + "]");
        return buf.toString();
    }
}

