/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage.viewers.projections;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.viewers.projections.Equirectangular;
import org.openstreetmap.josm.gui.layer.geoimage.viewers.projections.IImageViewer;
import org.openstreetmap.josm.gui.layer.geoimage.viewers.projections.Perspective;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class ImageProjectionRegistry {
    private static final EnumMap<Projections, Class<? extends IImageViewer>> DEFAULT_VIEWERS = new EnumMap(Projections.class);

    private ImageProjectionRegistry() {
    }

    public static boolean registerViewer(Class<? extends IImageViewer> clazz) throws ReflectiveOperationException {
        Objects.requireNonNull(clazz, "null classes are hard to instantiate");
        IImageViewer object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        boolean changed = false;
        for (Projections projections : object.getSupportedProjections()) {
            changed = clazz.equals(DEFAULT_VIEWERS.put(projections, clazz)) || changed;
        }
        return changed;
    }

    public static boolean removeViewer(Class<? extends IImageViewer> clazz) {
        boolean changed = false;
        for (Projections projections : DEFAULT_VIEWERS.entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(clazz)).map(Map.Entry::getKey).collect(Collectors.toList())) {
            changed = DEFAULT_VIEWERS.remove((Object)projections, clazz) || changed;
        }
        return changed;
    }

    public static Class<? extends IImageViewer> getViewer(Projections projection) {
        return DEFAULT_VIEWERS.getOrDefault((Object)projection, DEFAULT_VIEWERS.getOrDefault((Object)Projections.UNKNOWN, Perspective.class));
    }

    static {
        try {
            ImageProjectionRegistry.registerViewer(Perspective.class);
            ImageProjectionRegistry.registerViewer(Equirectangular.class);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException(e);
        }
    }
}

