/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.I18n;
import java.util.ArrayList;
import java.util.List;

public enum WeekDay {
    MO("Mo"),
    TU("Tu"),
    WE("We"),
    TH("Th"),
    FR("Fr"),
    SA("Sa"),
    SU("Su");

    private final String name;

    private WeekDay(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static WeekDay getValue(String day) {
        for (WeekDay w : WeekDay.values()) {
            if (!w.toString().equals(day)) continue;
            return w;
        }
        throw new IllegalArgumentException(I18n.tr("invalid_week_day", day));
    }

    public static List<String> nameValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (WeekDay w : WeekDay.values()) {
            result.add(w.toString());
        }
        return result;
    }
}

