/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UrlPatterns;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public String[] getPatterns() {
        return DownloadOsmChangeTask.patterns(UrlPatterns.OsmChangeUrlPattern.class);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Change", new Object[0]);
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        Optional<UrlPatterns.OsmChangeUrlPattern> urlPattern = Arrays.stream(UrlPatterns.OsmChangeUrlPattern.values()).filter(p -> p.matches(url)).findFirst();
        String newUrl = url;
        Matcher matcher = UrlPatterns.OsmChangeUrlPattern.OSM_WEBSITE.matcher(url);
        if (matcher.matches()) {
            newUrl = OsmApi.getOsmApi().getBaseUrl() + "changeset/" + Long.parseLong(matcher.group(2)) + "/download";
        }
        this.downloadTask = new DownloadTask(settings, (OsmServerReader)new OsmServerLocationReader(newUrl), progressMonitor, true, Compression.byExtension(newUrl));
        this.extractOsmFilename(settings, urlPattern.orElse(UrlPatterns.OsmChangeUrlPattern.EXTERNAL_OSC_FILE).pattern(), newUrl);
        return MainApplication.worker.submit(this.downloadTask);
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload, Compression compression) {
            super(DownloadOsmChangeTask.this, settings, reader, progressMonitor, zoomAfterDownload, compression);
        }

        @Override
        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false), this.compression);
        }

        @Override
        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                HashMap<OsmPrimitive, Instant> toLoad = new HashMap<OsmPrimitive, Instant>();
                for (OsmPrimitive p : ((DataSet)DownloadOsmChangeTask.this.downloadedData).allNonDeletedPrimitives()) {
                    if (!p.isIncomplete()) continue;
                    Instant timestamp = p.getReferrers().stream().filter(ref -> !ref.isTimestampEmpty()).findFirst().map(AbstractPrimitive::getInstant).orElse(null);
                    toLoad.put(p, timestamp);
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoad));
            }
            catch (RejectedExecutionException e) {
                DownloadOsmChangeTask.this.rememberException(e);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }

    private static final class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Instant> toLoad;

        private HistoryLoaderAndListener(Map<OsmPrimitive, Instant> toLoad) {
            this.toLoad = toLoad;
            this.setChangesetDataNeeded(false);
            this.addOsmPrimitives(toLoad.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet source, PrimitiveId id) {
            HashMap<OsmPrimitive, Instant> toLoadNext = new HashMap<OsmPrimitive, Instant>();
            Iterator<Map.Entry<OsmPrimitive, Instant>> it = this.toLoad.entrySet().iterator();
            while (it.hasNext()) {
                PrimitiveData data;
                HistoryOsmPrimitive hp;
                Map.Entry<OsmPrimitive, Instant> entry = it.next();
                OsmPrimitive p = entry.getKey();
                History history = source.getHistory(p.getPrimitiveId());
                Instant date = entry.getValue();
                if (history == null || date == null || (hp = history.getByDate(Date.from(date))) == null) continue;
                switch (p.getType()) {
                    case NODE: {
                        data = ((HistoryNode)hp).fillPrimitiveData(new NodeData());
                        break;
                    }
                    case WAY: {
                        data = ((HistoryWay)hp).fillPrimitiveData(new WayData());
                        for (Long nodeId : ((HistoryWay)hp).getNodes()) {
                            if (p.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE) != null) continue;
                            Node n = new Node(nodeId);
                            p.getDataSet().addPrimitive(n);
                            toLoadNext.put(n, date);
                        }
                        break;
                    }
                    case RELATION: {
                        data = ((HistoryRelation)hp).fillPrimitiveData(new RelationData());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                try {
                    p.load(data);
                    it.remove();
                }
                catch (AssertionError e) {
                    Logging.log(Logging.LEVEL_ERROR, "Cannot load " + p + ':', (Throwable)((Object)e));
                }
            }
            source.removeHistoryDataSetListener(this);
            if (toLoadNext.isEmpty()) {
                MainApplication.getMap().repaint();
            } else {
                MainApplication.worker.submit(new HistoryLoaderAndListener(toLoadNext));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet source) {
        }
    }
}

