/* MapCSSParser.java */
/* Generated By:JavaCC: Do not edit this line. MapCSSParser.java */
package org.openstreetmap.josm.gui.mappaint.mapcss.parsergen;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition.Context;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory.KeyMatchType;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory.Op;
import org.openstreetmap.josm.gui.mappaint.mapcss.Declaration;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory.NullExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.LiteralExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.ChildOrParentSelector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.GeneralSelector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.LinkSelector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Subpart;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

/**
 * MapCSS parser.
 *
 * Contains two independent grammars:
 * (a) the preprocessor and (b) the main mapcss parser.
 *
 * The preprocessor handles @supports syntax.
 * Basically this allows to write one style for different versions of JOSM (or different editors).
 * When the @supports condition is not fulfilled, it should simply skip over
 * the whole section and not attempt to parse the possibly unknown
 * grammar. It preserves whitespace and comments, in order to keep the
 * line and column numbers in the error messages correct for the second pass.
 *
 */
public class MapCSSParser implements MapCSSParserConstants {
    MapCSSStyleSource sheet;
    StringBuilder sb;
    int declarationCounter;

    /**
     * Nicer way to refer to a lexical state.
     */
    public enum LexicalState {
        /** the preprocessor */
        PREPROCESSOR(0),
        /** the main parser */
        DEFAULT(2);

        final int idx; // the integer, which javacc assigns to this state

        LexicalState(int idx) {
            if (!this.name().equals(MapCSSParserTokenManager.lexStateNames[idx])) {
                throw new JosmRuntimeException("Wrong name for index " + idx);
            }
            this.idx = idx;
        }
    }

    /**
     * Constructor which initializes the parser with a certain lexical state.
     * @param in input
     * @param encoding contents encoding
     * @param initState initial state
     */
    @Deprecated
    public MapCSSParser(InputStream in, String encoding, LexicalState initState) {
        this(createTokenManager(in, encoding, initState));
        declarationCounter = 0;
    }

    @Deprecated
    protected static MapCSSParserTokenManager createTokenManager(InputStream in, String encoding, LexicalState initState) {
        SimpleCharStream scs;
        try {
            scs = new SimpleCharStream(in, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new JosmRuntimeException(e);
        }
        return new MapCSSParserTokenManager(scs, initState.idx);
    }

    /**
     * Constructor which initializes the parser with a certain lexical state.
     * @param in input
     * @param initState initial state
     */
    public MapCSSParser(Reader in, LexicalState initState) {
        this(createTokenManager(in, initState));
        declarationCounter = 0;
    }

    protected static MapCSSParserTokenManager createTokenManager(Reader in, LexicalState initState) {
        final SimpleCharStream scs = new SimpleCharStream(in, 1, 1);
        return new MapCSSParserTokenManager(scs, initState.idx);
    }

/*
 * Preprocessor parser definitions:
 *
 * <pre>
 *
 * {@literal @media} { ... } queries are supported, following http://www.w3.org/TR/css3-mediaqueries/#syntax
 *
 *                               media_query
 *         ___________________________|_______________________________
 *        |                                                           |
 * {@literal @media} all and (min-josm-version: 7789) and (max-josm-version: 7790), all and (user-agent: xyz) { ... }
 *                |______________________|
 *                          |
 *                    media_expression
 * </pre>
 */


/**
 * root method for the preprocessor.
 * @param sheet MapCSS style source
 * @return result string
 * @throws ParseException in case of parsing error
 */
  final public String pp_root(MapCSSStyleSource sheet) throws ParseException {
sb = new StringBuilder(); this.sheet = sheet;
    pp_black_box(true);
    jj_consume_token(0);
{if ("" != null) return sb.toString();}
    throw new Error("Missing return statement in function");
}

/**
 * Parse any unknown grammar (black box).
 *
 * Only stop when "@media" is encountered and keep track of correct number of
 * opening and closing curly brackets.
 *
 * @param write false if this content should be skipped (@pp_media condition is not fulfilled), true otherwise
 * @throws ParseException in case of parsing error
 */
  final public void pp_black_box(boolean write) throws ParseException {Token t;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PP_AND:
      case PP_OR:
      case PP_NOT:
      case PP_SUPPORTS:
      case PP_NEWLINECHAR:
      case PP_WHITESPACE:
      case PP_COMMENT_START:
      case IDENT:
      case UINT:
      case STRING:
      case REGEX:
      case LBRACE:
      case LPAR:
      case RPAR:
      case COMMA:
      case COLON:
      case PP_SOMETHING_ELSE:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PP_AND:
      case PP_OR:
      case PP_NOT:
      case IDENT:
      case UINT:
      case STRING:
      case REGEX:
      case LPAR:
      case RPAR:
      case COMMA:
      case COLON:
      case PP_SOMETHING_ELSE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PP_AND:{
          t = jj_consume_token(PP_AND);
          break;
          }
        case PP_OR:{
          t = jj_consume_token(PP_OR);
          break;
          }
        case PP_NOT:{
          t = jj_consume_token(PP_NOT);
          break;
          }
        case UINT:{
          t = jj_consume_token(UINT);
          break;
          }
        case STRING:{
          t = jj_consume_token(STRING);
          break;
          }
        case REGEX:{
          t = jj_consume_token(REGEX);
          break;
          }
        case LPAR:{
          t = jj_consume_token(LPAR);
          break;
          }
        case RPAR:{
          t = jj_consume_token(RPAR);
          break;
          }
        case COMMA:{
          t = jj_consume_token(COMMA);
          break;
          }
        case COLON:{
          t = jj_consume_token(COLON);
          break;
          }
        case IDENT:{
          t = jj_consume_token(IDENT);
          break;
          }
        case PP_SOMETHING_ELSE:{
          t = jj_consume_token(PP_SOMETHING_ELSE);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
if (write) sb.append(t.image);
        break;
        }
      case PP_NEWLINECHAR:
      case PP_WHITESPACE:
      case PP_COMMENT_START:{
        pp_w1();
        break;
        }
      case PP_SUPPORTS:{
        pp_supports(!write);
        break;
        }
      case LBRACE:{
        t = jj_consume_token(LBRACE);
if (write) sb.append(t.image);
        pp_black_box(write);
        t = jj_consume_token(RBRACE);
if (write) sb.append(t.image);
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/**
 * Parses an @supports rule.
 *
 * @param ignore if the content of this rule should be ignored
 * (because we are already inside a @supports block that didn't pass)
 * @throws ParseException in case of parsing error
 */
  final public void pp_supports(boolean ignore) throws ParseException {boolean pass;
    jj_consume_token(PP_SUPPORTS);
    pp_w();
    pass = pp_supports_condition();
    jj_consume_token(LBRACE);
    pp_black_box(pass && !ignore);
    jj_consume_token(RBRACE);
}

/**
 * Parses the condition of the @supports rule.
 *
 * Unlike other parsing rules, grabs trailing whitespace.
 * @return true, if the condition is fulfilled
 * @throws ParseException in case of parsing error
 */
  final public boolean pp_supports_condition() throws ParseException {boolean pass;
    boolean q;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PP_NOT:{
      jj_consume_token(PP_NOT);
      pp_w();
      q = pp_supports_condition_in_parens();
pass = !q;
      pp_w();
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      if (jj_2_1(2147483647)) {
        pass = pp_supports_condition_in_parens();
        pp_w();
        label_2:
        while (true) {
          jj_consume_token(PP_AND);
          pp_w();
          q = pp_supports_condition_in_parens();
pass = pass && q;
          pp_w();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PP_AND:{
            ;
            break;
            }
          default:
            jj_la1[3] = jj_gen;
            break label_2;
          }
        }
      } else if (jj_2_2(2147483647)) {
        pass = pp_supports_condition_in_parens();
        pp_w();
        label_3:
        while (true) {
          jj_consume_token(PP_OR);
          pp_w();
          q = pp_supports_condition_in_parens();
pass = pass || q;
          pp_w();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PP_OR:{
            ;
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAR:{
          pass = pp_supports_condition_in_parens();
          pp_w();
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return pass;}
    throw new Error("Missing return statement in function");
}

/**
 * Parses something in parenthesis inside the condition of the @supports rule.
 *
 * @return true, if the condition is fulfilled
 * @throws ParseException in case of parsing error
 */
  final public boolean pp_supports_condition_in_parens() throws ParseException {boolean pass;
    if (jj_2_3(2147483647)) {
      pass = pp_supports_declaration_condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAR:{
        jj_consume_token(LPAR);
        pp_w();
        pass = pp_supports_condition();
        jj_consume_token(RPAR);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return pass;}
    throw new Error("Missing return statement in function");
}

/**
 * Parse an @supports declaration condition, e.&nbsp;g. a single (key:value) or (key) statement.
 *
 * The parsing rule {@link #literal()} from the main mapcss parser is reused here.
 *
 * @return true if the condition is fulfilled
 * @throws ParseException in case of parsing error
 */
  final public boolean pp_supports_declaration_condition() throws ParseException {Token t;
    String feature;
    Object val = null;
    jj_consume_token(LPAR);
    pp_w();
    t = jj_consume_token(IDENT);
feature = t.image;
    pp_w();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      pp_w();
      val = literal();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(RPAR);
{if ("" != null) return this.sheet.evalSupportsDeclCondition(feature, val);}
    throw new Error("Missing return statement in function");
}

  final public void pp_w1() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PP_NEWLINECHAR:{
      t = jj_consume_token(PP_NEWLINECHAR);
sb.append(t.image);
      break;
      }
    case PP_WHITESPACE:{
      t = jj_consume_token(PP_WHITESPACE);
sb.append(t.image);
      break;
      }
    case PP_COMMENT_START:{
      t = jj_consume_token(PP_COMMENT_START);
sb.append(t.image);
      t = jj_consume_token(PP_COMMENT_END);
sb.append(t.image);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void pp_w() throws ParseException {
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PP_NEWLINECHAR:
      case PP_WHITESPACE:
      case PP_COMMENT_START:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      pp_w1();
    }
}

/*
 * Parser definition for the main MapCSS parser:
 *
 * <pre>
 *
 *                       rule
 *  _______________________|______________________________
 * |                                                      |
 *        selector                      declaration
 *  _________|___________________   _________|____________
 * |                             | |                      |
 *
 * way|z11-12[highway=residential] { color: red; width: 3 }
 *
 *    |_____||___________________|   |_________|
 *       |            |                   |
 *     zoom       condition          instruction
 *
 * more general:
 *
 * way|z13-[a=b][c=d]::subpart, way|z-3[u=v]:closed::subpart2 { p1 : val; p2 : val; }
 *
 * 'val' can be a literal, or an expression like "prop(width, default) + 0.8".
 *
 * </pre>
 */
  final public 
int uint() throws ParseException {Token i;
    i = jj_consume_token(UINT);
{if ("" != null) return Integer.parseInt(i.image);}
    throw new Error("Missing return statement in function");
}

  final public int int_() throws ParseException {int i;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
      i = uint();
{if ("" != null) return -i;}
      break;
      }
    case UINT:{
      i = uint();
{if ("" != null) return i;}
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public float ufloat() throws ParseException {Token f;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case UFLOAT:{
      f = jj_consume_token(UFLOAT);
      break;
      }
    case UINT:{
      f = jj_consume_token(UINT);
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return Float.parseFloat(f.image);}
    throw new Error("Missing return statement in function");
}

  final public float float_() throws ParseException {float f;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
      f = ufloat();
{if ("" != null) return -f;}
      break;
      }
    case UINT:
    case UFLOAT:{
      f = ufloat();
{if ("" != null) return f;}
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String string() throws ParseException {Token t;
    t = jj_consume_token(STRING);
{if ("" != null) return t.image.substring(1, t.image.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");}
    throw new Error("Missing return statement in function");
}

  final public String ident() throws ParseException {Token t;
    String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      t = jj_consume_token(IDENT);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t.image;}
    throw new Error("Missing return statement in function");
}

  final public String string_or_ident() throws ParseException {Token t;
    String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SET:
    case IDENT:{
      s = ident();
      break;
      }
    case STRING:{
      s = string();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public String regex() throws ParseException {Token t;
    t = jj_consume_token(REGEX);
{if ("" != null) return t.image.substring(1, t.image.length() - 1);}
    throw new Error("Missing return statement in function");
}

/**
 * white-space
 * @throws ParseException in case of parsing error
 */
  final public void s() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
}

/**
 * mix of white-space and comments
 * @throws ParseException in case of parsing error
 */
  final public void w() throws ParseException {
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:
      case COMMENT_START:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      case COMMENT_START:{
        jj_consume_token(COMMENT_START);
        jj_consume_token(COMMENT_END);
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/**
 * comma delimited list of floats (at least 2, all &gt;= 0)
 * @return list of floats
 * @throws ParseException in case of parsing error 
 */
  final public List<Float> float_array() throws ParseException {float f;
    List<Float> fs = new ArrayList<Float>();
    f = ufloat();
fs.add(f);
    label_6:
    while (true) {
      jj_consume_token(COMMA);
      s();
      f = ufloat();
fs.add(f);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_6;
      }
    }
{if ("" != null) return fs;}
    throw new Error("Missing return statement in function");
}

/**
 * entry point for the main parser
 * @param sheet MapCSS style source
 * @throws ParseException in case of parsing error
 */
  final public void sheet(MapCSSStyleSource sheet) throws ParseException {
this.sheet = sheet;
    w();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case STAR:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_7;
      }
      try {
        rule();
        w();
      } catch (MapCSSException mex) {
Logging.error(mex);
            error_skipto(RBRACE, mex);
            w();
      } catch (ParseException ex) {
error_skipto(RBRACE, null);
            w();
      }
    }
    jj_consume_token(0);
}

  final public void rule() throws ParseException {List<Selector> selectors;
    Declaration decl;
    selectors = selectors();
    decl = declaration();
sheet.rules.add(new MapCSSRule(selectors, decl));
}

/** Read selectors, make sure that we read all tokens  See #17746 */
  final public List<Selector> selectors_for_search() throws ParseException {List<Selector> selectors;
    selectors = selectors();
    jj_consume_token(0);
{if ("" != null) return selectors;}
    throw new Error("Missing return statement in function");
}

  final public List<Selector> selectors() throws ParseException {List<Selector> selectors = new ArrayList<Selector>();
    Selector sel;
    sel = child_selector();
selectors.add(sel);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      w();
      sel = child_selector();
selectors.add(sel);
    }
{if ("" != null) return selectors;}
    throw new Error("Missing return statement in function");
}

  final public Selector child_selector() throws ParseException {Selector.ChildOrParentSelectorType type = null;
    Condition c;
    List<Condition> conditions = new ArrayList<Condition>();
    Selector selLeft;
    LinkSelector selLink = null;
    Selector selRight = null;
    selLeft = selector();
    w();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case STAR:
    case GREATER:
    case LESS:
    case PLUS:
    case SUBSET_OR_EQUAL:
    case NOT_SUBSET_OR_EQUAL:
    case SUPERSET_OR_EQUAL:
    case NOT_SUPERSET_OR_EQUAL:
    case CROSSING:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GREATER:
      case LESS:
      case PLUS:
      case SUBSET_OR_EQUAL:
      case NOT_SUBSET_OR_EQUAL:
      case SUPERSET_OR_EQUAL:
      case NOT_SUPERSET_OR_EQUAL:
      case CROSSING:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER:
        case LESS:
        case PLUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case GREATER:{
            jj_consume_token(GREATER);
type = Selector.ChildOrParentSelectorType.CHILD;
            break;
            }
          case LESS:{
            jj_consume_token(LESS);
type = Selector.ChildOrParentSelectorType.PARENT;
            break;
            }
          case PLUS:{
            jj_consume_token(PLUS);
type = Selector.ChildOrParentSelectorType.SIBLING;
            break;
            }
          default:
            jj_la1[22] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_9:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COLON:
            case LSQUARE:
            case EXCLAMATION:
            case FULLSTOP:{
              ;
              break;
              }
            default:
              jj_la1[23] = jj_gen;
              break label_9;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LSQUARE:{
              c = condition(Context.LINK);
              break;
              }
            case COLON:
            case EXCLAMATION:
            case FULLSTOP:{
              c = class_or_pseudoclass(Context.LINK);
              break;
              }
            default:
              jj_la1[24] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
if (c!= null) conditions.add(c);
          }
          break;
          }
        case SUBSET_OR_EQUAL:{
          jj_consume_token(SUBSET_OR_EQUAL);
type = Selector.ChildOrParentSelectorType.SUBSET_OR_EQUAL;
          break;
          }
        case NOT_SUBSET_OR_EQUAL:{
          jj_consume_token(NOT_SUBSET_OR_EQUAL);
type = Selector.ChildOrParentSelectorType.NOT_SUBSET_OR_EQUAL;
          break;
          }
        case SUPERSET_OR_EQUAL:{
          jj_consume_token(SUPERSET_OR_EQUAL);
type = Selector.ChildOrParentSelectorType.SUPERSET_OR_EQUAL;
          break;
          }
        case NOT_SUPERSET_OR_EQUAL:{
          jj_consume_token(NOT_SUPERSET_OR_EQUAL);
type = Selector.ChildOrParentSelectorType.NOT_SUPERSET_OR_EQUAL;
          break;
          }
        case CROSSING:{
          jj_consume_token(CROSSING);
type = Selector.ChildOrParentSelectorType.CROSSING;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        w();
        break;
        }
      default:
        jj_la1[26] = jj_gen;
/* <GREATER> is optional for child selector */ type = Selector.ChildOrParentSelectorType.CHILD;
      }
selLink = new LinkSelector(conditions);
      selRight = selector();
      w();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
{if ("" != null) return selRight != null ? new ChildOrParentSelector(selLeft, selLink, selRight, type) : selLeft;}
    throw new Error("Missing return statement in function");
}

  final public Selector selector() throws ParseException {Token base;
    Condition c;
    Range r = Range.ZERO_TO_INFINITY;
    List<Condition> conditions = new ArrayList<Condition>();
    Subpart sub = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      base = jj_consume_token(IDENT);
      break;
      }
    case STAR:{
      base = jj_consume_token(STAR);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PIPE_Z:{
      r = zoom();
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:
      case LSQUARE:
      case EXCLAMATION:
      case FULLSTOP:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSQUARE:{
        c = condition(Context.PRIMITIVE);
        break;
        }
      case COLON:
      case EXCLAMATION:
      case FULLSTOP:{
        c = class_or_pseudoclass(Context.PRIMITIVE);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (c!= null) conditions.add(c);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DCOLON:{
      sub = subpart();
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
{if ("" != null) return new GeneralSelector(base.image, r, conditions, sub);}
    throw new Error("Missing return statement in function");
}

  final public Range zoom() throws ParseException {Integer min = 0;
    Integer max = Integer.MAX_VALUE;
    jj_consume_token(PIPE_Z);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
      max = uint();
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      if (jj_2_4(2)) {
        min = uint();
        jj_consume_token(MINUS);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case UINT:{
          max = uint();
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case UINT:{
          min = uint();
max = min;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return GeneralSelector.fromLevel(min, max);}
    throw new Error("Missing return statement in function");
}

  final public Condition condition(Context context) throws ParseException {Condition c;
    Expression e;
    jj_consume_token(LSQUARE);
    s();
    if (jj_2_5(2147483647)) {
      c = simple_key_condition(context);
      s();
      jj_consume_token(RSQUARE);
{if ("" != null) return c;}
    } else if (jj_2_6(2147483647)) {
      c = simple_key_value_condition(context);
      s();
      jj_consume_token(RSQUARE);
{if ("" != null) return c;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SET:
      case IDENT:
      case UINT:
      case STRING:
      case LPAR:
      case UFLOAT:
      case HEXCOLOR:
      case EXCLAMATION:
      case PLUS:
      case MINUS:{
        e = expression();
        jj_consume_token(RSQUARE);
{if ("" != null) return ConditionFactory.createExpressionCondition(e, context);}
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public String tag_key() throws ParseException {String s, s2;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      s = string();
{if ("" != null) return s;}
      break;
      }
    case SET:
    case IDENT:{
      s = ident();
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_11;
        }
        jj_consume_token(COLON);
        s2 = ident();
s += ':' + s2;
      }
{if ("" != null) return s;}
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Condition simple_key_condition(Context context) throws ParseException {boolean not = false;
    KeyMatchType matchType = null;;
    String key;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXCLAMATION:{
      jj_consume_token(EXCLAMATION);
not = true;
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REGEX:{
matchType = KeyMatchType.REGEX;
      key = regex();
      break;
      }
    case SET:
    case IDENT:
    case STRING:{
      key = tag_key();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_7(2)) {
      jj_consume_token(QUESTION);
      jj_consume_token(EXCLAMATION);
matchType = KeyMatchType.FALSE;
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
matchType = KeyMatchType.TRUE;
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
{if ("" != null) return ConditionFactory.createKeyCondition(key, not, matchType, context);}
    throw new Error("Missing return statement in function");
}

  final public Condition simple_key_value_condition(Context context) throws ParseException {String key;
    String val;
    float f;
    int i;
    KeyMatchType matchType = null;;
    Op op;
    boolean considerValAsKey = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REGEX:{
      key = regex();
      s();
matchType = KeyMatchType.REGEX;
      break;
      }
    case SET:
    case IDENT:
    case STRING:{
      key = tag_key();
      s();
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_9(3)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQUAL:{
        jj_consume_token(EQUAL);
        jj_consume_token(TILDE);
op=Op.REGEX;
        break;
        }
      case EXCLAMATION:{
        jj_consume_token(EXCLAMATION);
        jj_consume_token(TILDE);
op=Op.NREGEX;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      s();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
considerValAsKey=true;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      val = regex();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:
      case EQUAL:
      case EXCLAMATION:
      case TILDE:
      case DOLLAR:
      case CARET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EXCLAMATION:{
          jj_consume_token(EXCLAMATION);
          jj_consume_token(EQUAL);
op=Op.NEQ;
          break;
          }
        case EQUAL:{
          jj_consume_token(EQUAL);
op=Op.EQ;
          break;
          }
        case TILDE:{
          jj_consume_token(TILDE);
          jj_consume_token(EQUAL);
op=Op.ONE_OF;
          break;
          }
        case CARET:{
          jj_consume_token(CARET);
          jj_consume_token(EQUAL);
op=Op.BEGINS_WITH;
          break;
          }
        case DOLLAR:{
          jj_consume_token(DOLLAR);
          jj_consume_token(EQUAL);
op=Op.ENDS_WITH;
          break;
          }
        case STAR:{
          jj_consume_token(STAR);
          jj_consume_token(EQUAL);
op=Op.CONTAINS;
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        s();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STAR:{
          jj_consume_token(STAR);
considerValAsKey=true;
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          ;
        }
        if (jj_2_8(2)) {
          i = int_();
val=Integer.toString(i);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case UINT:
          case UFLOAT:
          case MINUS:{
            f = float_();
val=Float.toString(f);
            break;
            }
          case SET:
          case IDENT:
          case STRING:{
            val = string_or_ident();
            break;
            }
          default:
            jj_la1[47] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case GREATER_EQUAL:
      case LESS_EQUAL:
      case GREATER:
      case LESS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER_EQUAL:{
          jj_consume_token(GREATER_EQUAL);
op=Op.GREATER_OR_EQUAL;
          break;
          }
        case GREATER:{
          jj_consume_token(GREATER);
op=Op.GREATER;
          break;
          }
        case LESS_EQUAL:{
          jj_consume_token(LESS_EQUAL);
op=Op.LESS_OR_EQUAL;
          break;
          }
        case LESS:{
          jj_consume_token(LESS);
op=Op.LESS;
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        s();
        f = float_();
val=Float.toString(f);
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return KeyMatchType.REGEX == matchType
            ? ConditionFactory.createRegexpKeyRegexpValueCondition(key, val, op)
            : ConditionFactory.createKeyValueCondition(key, val, op, context, considerValAsKey);}
    throw new Error("Missing return statement in function");
}

  final public Condition class_or_pseudoclass(Context context) throws ParseException {String s;
    boolean not = false;
    boolean pseudo;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXCLAMATION:{
      jj_consume_token(EXCLAMATION);
not = true;
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FULLSTOP:{
      jj_consume_token(FULLSTOP);
pseudo = false;
      break;
      }
    case COLON:{
      jj_consume_token(COLON);
pseudo = true;
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    s = ident();
if (pseudo && sheet != null && sheet.isRemoveAreaStylePseudoClass() && s.matches("areaStyle|area-style|area_style")) {
            Logging.warn("Removing 'areaStyle' pseudo-class. This class is only meant for validator");
            {if ("" != null) return null;}
        } else if (pseudo) {
            {if ("" != null) return ConditionFactory.createPseudoClassCondition(s, not, context);}
        } else {
            {if ("" != null) return ConditionFactory.createClassCondition(s, not, context);}
        }
    throw new Error("Missing return statement in function");
}

  final public Subpart subpart() throws ParseException {String s;
    Expression e;
    jj_consume_token(DCOLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SET:
    case IDENT:{
      s = ident();
{if ("" != null) return new Subpart.StringSubpart(s);}
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
{if ("" != null) return new Subpart.StringSubpart("*");}
      break;
      }
    case LPAR:{
      jj_consume_token(LPAR);
      e = expression();
      jj_consume_token(RPAR);
{if ("" != null) return new Subpart.ExpressionSubpart(e);}
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Declaration declaration() throws ParseException {List<Instruction> ins = new ArrayList<Instruction>();
    Instruction i;
    Token key;
    Object val = null;
    jj_consume_token(LBRACE);
    w();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SET:
      case IDENT:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SET:{
        jj_consume_token(SET);
        w();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FULLSTOP:{
          jj_consume_token(FULLSTOP);
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          ;
        }
        // specification allows "set .class" to set "class". we also support "set class"
                    key = jj_consume_token(IDENT);
        w();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:{
          jj_consume_token(EQUAL);
          val = expression();
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          ;
        }
ins.add(new Instruction.AssignmentInstruction(key.image, val == null ? true : val, true));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case RBRACE:{
          jj_consume_token(RBRACE);
{if ("" != null) return new Declaration(ins, declarationCounter++);}
          break;
          }
        case SEMICOLON:{
          jj_consume_token(SEMICOLON);
          w();
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
        jj_consume_token(IDENT);
        w();
        jj_consume_token(COLON);
        w();
        expression();
        jj_consume_token(SEMICOLON);
        w();
        break;
        }
      case IDENT:{
        key = jj_consume_token(IDENT);
        w();
        jj_consume_token(COLON);
        w();
        if (jj_2_10(2147483647)) {
          val = float_array();
ins.add(new Instruction.AssignmentInstruction(key.image, val, false));
          w();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case RBRACE:{
            jj_consume_token(RBRACE);
{if ("" != null) return new Declaration(ins, declarationCounter++);}
            break;
            }
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            w();
            break;
            }
          default:
            jj_la1[57] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else if (jj_2_11(2147483647)) {
          val = expression();
ins.add(new Instruction.AssignmentInstruction(key.image, val, false));
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case RBRACE:{
            jj_consume_token(RBRACE);
{if ("" != null) return new Declaration(ins, declarationCounter++);}
            break;
            }
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            w();
            break;
            }
          default:
            jj_la1[58] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          val = readRaw();
          w();
ins.add(new Instruction.AssignmentInstruction(key.image, val, false));
        }
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new Declaration(ins, declarationCounter++);}
    throw new Error("Missing return statement in function");
}

/**
 * General expression.
 * Separate production rule for each level of operator precedence (recursive descent).
 */
  final public Expression expression() throws ParseException {Expression e;
    e = conditional_expression();
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression conditional_expression() throws ParseException {Expression e, e1, e2;
    String op = null;
    e = or_expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
      w();
      e1 = conditional_expression();
      jj_consume_token(COLON);
      w();
      e2 = conditional_expression();
e = ExpressionFactory.createFunctionExpression("cond", Arrays.asList(e, e1, e2));
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression or_expression() throws ParseException {Expression e, e2;
    String op = null;
    e = and_expression();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PIPE:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_13;
      }
      jj_consume_token(PIPE);
      jj_consume_token(PIPE);
      w();
      e2 = and_expression();
e = ExpressionFactory.createFunctionExpression("or", Arrays.asList(e, e2));
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression and_expression() throws ParseException {Expression e, e2;
    String op = null;
    e = relational_expression();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AMPERSAND:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_14;
      }
      jj_consume_token(AMPERSAND);
      jj_consume_token(AMPERSAND);
      w();
      e2 = relational_expression();
e = ExpressionFactory.createFunctionExpression("and", Arrays.asList(e, e2));
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression relational_expression() throws ParseException {Expression e, e2;
    String op = null;
    e = additive_expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GREATER_EQUAL:
    case LESS_EQUAL:
    case GREATER:
    case LESS:
    case EQUAL:
    case EXCLAMATION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GREATER_EQUAL:{
        jj_consume_token(GREATER_EQUAL);
op = "greater_equal";
        break;
        }
      case LESS_EQUAL:{
        jj_consume_token(LESS_EQUAL);
op = "less_equal";
        break;
        }
      case GREATER:{
        jj_consume_token(GREATER);
op = "greater";
        break;
        }
      case LESS:{
        jj_consume_token(LESS);
op = "less";
        break;
        }
      case EQUAL:{
        jj_consume_token(EQUAL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:{
          jj_consume_token(EQUAL);
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          ;
        }
op = "equal";
        break;
        }
      case EXCLAMATION:{
        jj_consume_token(EXCLAMATION);
        jj_consume_token(EQUAL);
op = "not_equal";
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      w();
      e2 = additive_expression();
e = ExpressionFactory.createFunctionExpression(op, Arrays.asList(e, e2));
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression additive_expression() throws ParseException {Expression e, e2;
    String op = null;
    e = multiplicative_expression();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = "plus";
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = "minus";
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      w();
      e2 = multiplicative_expression();
e = ExpressionFactory.createFunctionExpression(op, Arrays.asList(e, e2));
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression multiplicative_expression() throws ParseException {Expression e, e2;
    String op = null;
    e = unary_expression();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:
      case SLASH:{
        ;
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
op = "times";
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
op = "divided_by";
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      w();
      e2 = unary_expression();
e = ExpressionFactory.createFunctionExpression(op, Arrays.asList(e, e2));
    }
{if ("" != null) return e;}
    throw new Error("Missing return statement in function");
}

  final public Expression unary_expression() throws ParseException {Expression e;
    String op = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXCLAMATION:
    case MINUS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:{
        jj_consume_token(MINUS);
op = "minus";
        w();
        break;
        }
      case EXCLAMATION:{
        jj_consume_token(EXCLAMATION);
op = "not";
        w();
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    e = primary();
    w();
if (op == null)
            {if ("" != null) return e;}
        {if ("" != null) return ExpressionFactory.createFunctionExpression(op, Collections.singletonList(e));}
    throw new Error("Missing return statement in function");
}

  final public Expression primary() throws ParseException {Expression nested;
    Expression fn;
    Object lit;
    if (jj_2_12(3)) {
      // both function and identifier start with an identifier (+ optional whitespace)
              fn = function();
{if ("" != null) return fn;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SET:
      case IDENT:
      case UINT:
      case STRING:
      case UFLOAT:
      case HEXCOLOR:
      case PLUS:{
        lit = literal();
if (lit == null)
                {if ("" != null) return NullExpression.INSTANCE;}
            {if ("" != null) return new LiteralExpression(lit);}
        break;
        }
      case LPAR:{
        jj_consume_token(LPAR);
        w();
        nested = expression();
        jj_consume_token(RPAR);
{if ("" != null) return nested;}
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Expression function() throws ParseException {Expression arg;
    String name;
    List<Expression> args = new ArrayList<Expression>();
    name = ident();
    w();
    jj_consume_token(LPAR);
    w();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SET:
    case IDENT:
    case UINT:
    case STRING:
    case LPAR:
    case UFLOAT:
    case HEXCOLOR:
    case EXCLAMATION:
    case PLUS:
    case MINUS:{
      arg = expression();
args.add(arg);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        w();
        arg = expression();
args.add(arg);
      }
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    jj_consume_token(RPAR);
{if ("" != null) return ExpressionFactory.createFunctionExpression(name, args);}
    throw new Error("Missing return statement in function");
}

  final public Object literal() throws ParseException {String val, pref;
    Token t;
    Float f;
    if (jj_2_13(2)) {
      pref = ident();
      t = jj_consume_token(HEXCOLOR);
{if ("" != null) return new NamedColorProperty(
                    NamedColorProperty.COLOR_CATEGORY_MAPPAINT,
                    sheet == null ? "MapCSS" : sheet.title, pref,
                    ColorHelper.html2color(t.image)).get();}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        t = jj_consume_token(IDENT);
{if ("" != null) return new Keyword(t.image);}
        break;
        }
      case STRING:{
        val = string();
{if ("" != null) return val;}
        break;
        }
      case PLUS:{
        jj_consume_token(PLUS);
        f = ufloat();
{if ("" != null) return new Instruction.RelativeFloat(f);}
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        if (jj_2_14(2)) {
          f = ufloat_unit();
{if ("" != null) return f;}
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case UINT:
          case UFLOAT:{
            f = ufloat();
{if ("" != null) return f;}
            break;
            }
          case HEXCOLOR:{
            t = jj_consume_token(HEXCOLOR);
{if ("" != null) return ColorHelper.html2color(t.image);}
            break;
            }
          default:
            jj_la1[76] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
}

/**
 * Number followed by a unit.
 *
 * Returns angles in radians and lengths in pixels.
 */
  final public Float ufloat_unit() throws ParseException {float f;
    String u;
    f = ufloat();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SET:
    case IDENT:{
      u = ident();
      break;
      }
    case DEG:{
      jj_consume_token(DEG);
u = "\u00b0";
      break;
      }
    case PERCENT:{
      jj_consume_token(PERCENT);
u = "%";
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Double m = unit_factor(u);
        if (m == null)
            {if ("" != null) return null;}
        {if ("" != null) return (float) (f * m);}
    throw new Error("Missing return statement in function");
}

  private Double unit_factor(String unit) throws ParseException {switch (unit) {
        case "deg":
        case "\u00b0": return Math.PI / 180;
        case "rad": return 1.;
        case "grad": return Math.PI / 200;
        case "turn": return 2 * Math.PI;
        case "%": return 0.01;
        case "px": return 1.;
        case "cm": return 96/2.54;
        case "mm": return 9.6/2.54;
        case "in": return 96.;
        case "q": return 2.4/2.54;
        case "pc": return 16.;
        case "pt": return 96./72;
        default: return null;
    }
  }

  void error_skipto(int kind, MapCSSException me) throws ParseException {if (token.kind == EOF)
        throw new ParseException("Reached end of file while parsing");

    Exception e = null;
    ParseException pe = generateParseException();

    if (me != null) {
        final Token token = Utils.firstNonNull(pe.currentToken.next, pe.currentToken);
        me.setLine(token.beginLine);
        me.setColumn(token.beginColumn);
        e = me;
    } else {
        e = new ParseException(pe.getMessage()); // prevent memory leak
    }

    Logging.error("Skipping to the next rule, because of an error:");
    Logging.error(e);
    if (sheet != null) {
        sheet.logError(e);
    }
    Token t;
    do {
        t = getNextToken();
    } while (t.kind != kind && t.kind != EOF);
    if (t.kind == EOF)
        throw new ParseException("Reached end of file while parsing");
  }

/**
 * read everything to the next semicolon
 */
  String readRaw() throws ParseException {Token t;
    StringBuilder s = new StringBuilder();
    while (true) {
        t = getNextToken();
        if ((t.kind == S || t.kind == STRING || t.kind == UNEXPECTED_CHAR) &&
                t.image.contains("\n")) {
            ParseException e = new ParseException(String.format("Warning: end of line while reading an unquoted string at line %s column %s.", t.beginLine, t.beginColumn));
            Logging.error(e);
            if (sheet != null) {
                sheet.logError(e);
            }
        }
        if (t.kind == SEMICOLON || t.kind == EOF)
            break;
        s.append(t.image);
    }
    if (t.kind == EOF)
        throw new ParseException("Reached end of file while parsing");
    return s.toString();
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_3R_and_expression_942_9_105()
 {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_relational_expression_959_5_104()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_pp_supports_declaration_condition_379_5_20()) return true;
    return false;
  }

  private boolean jj_3R_ufloat_unit_1119_18_55()
 {
    if (jj_3R_ident_477_5_34()) return true;
    return false;
  }

  private boolean jj_3R_and_expression_940_5_96()
 {
    if (jj_3R_relational_expression_959_5_104()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_and_expression_942_9_105()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_747_21_26()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_749_21_27()) return true;
    }
    if (jj_3R_s_506_5_23()) return true;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_752_15_28()) jj_scanpos = xsp;
    if (jj_3R_regex_494_5_29()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_742_9_45()
 {
    if (jj_3R_tag_key_705_9_61()) return true;
    if (jj_3R_s_506_5_23()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_in_parens_359_9_37()
 {
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_3R_pp_supports_condition_328_5_58()) return true;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_740_9_44()
 {
    if (jj_3R_regex_494_5_29()) return true;
    if (jj_3R_s_506_5_23()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_in_parens_356_9_36()
 {
    if (jj_3R_pp_supports_declaration_condition_379_5_20()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_739_5_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_740_9_44()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_742_9_45()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_755_13_46()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_779_13_47()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_simple_key_condition_724_20_43()
 {
    if (jj_scan_token(QUESTION)) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_in_parens_355_5_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_pp_supports_condition_in_parens_356_9_36()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_supports_condition_in_parens_359_9_37()) return true;
    }
    return false;
  }

  private boolean jj_3R_ufloat_unit_1119_5_35()
 {
    if (jj_3R_ufloat_450_5_50()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ufloat_unit_1119_18_55()) {
    jj_scanpos = xsp;
    if (jj_3R_ufloat_unit_1119_30_56()) {
    jj_scanpos = xsp;
    if (jj_3R_ufloat_unit_1119_51_57()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_or_expression_923_9_97()
 {
    if (jj_scan_token(PIPE)) return true;
    if (jj_scan_token(PIPE)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_and_expression_940_5_96()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_scan_token(PP_OR)) return true;
    return false;
  }

  private boolean jj_3R_or_expression_921_5_77()
 {
    if (jj_3R_and_expression_940_5_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_or_expression_923_9_97()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_float_array_533_9_51()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_s_506_5_23()) return true;
    if (jj_3R_ufloat_450_5_50()) return true;
    return false;
  }

  private boolean jj_3R_literal_1105_9_90()
 {
    if (jj_scan_token(HEXCOLOR)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_scan_token(PP_AND)) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_337_11_99()
 {
    if (jj_scan_token(PP_OR)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    return false;
  }

  private boolean jj_3R_literal_1103_9_89()
 {
    if (jj_3R_ufloat_450_5_50()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_339_9_82()
 {
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(QUESTION)) return true;
    if (jj_scan_token(EXCLAMATION)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_condition_721_9_42()
 {
    if (jj_3R_tag_key_705_9_61()) return true;
    return false;
  }

  private boolean jj_3R_tag_key_707_21_101()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_ident_477_5_34()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_condition_719_9_41()
 {
    if (jj_3R_regex_494_5_29()) return true;
    return false;
  }

  private boolean jj_3R_float_array_531_5_30()
 {
    if (jj_3R_ufloat_450_5_50()) return true;
    Token xsp;
    if (jj_3R_float_array_533_9_51()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_float_array_533_9_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_ufloat_unit_1119_5_35()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_333_11_98()
 {
    if (jj_scan_token(PP_AND)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_335_9_81()
 {
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    Token xsp;
    if (jj_3R_pp_supports_condition_337_11_99()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_pp_supports_condition_337_11_99()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_literal_1098_9_88()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_ufloat_450_5_50()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_condition_717_7_40()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    return false;
  }

  private boolean jj_3R_literal_1096_9_87()
 {
    if (jj_3R_string_467_5_100()) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_331_9_80()
 {
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    Token xsp;
    if (jj_3R_pp_supports_condition_333_11_98()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_pp_supports_condition_333_11_98()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_simple_key_condition_717_5_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_condition_717_7_40()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_condition_719_9_41()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_condition_721_9_42()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_condition_724_20_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_literal_1094_9_86()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_w_517_13_76()
 {
    if (jj_scan_token(COMMENT_START)) return true;
    if (jj_scan_token(COMMENT_END)) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_condition_329_9_79()
 {
    if (jj_scan_token(PP_NOT)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_3R_pp_supports_condition_in_parens_355_5_18()) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    return false;
  }

  private boolean jj_3R_conditional_expression_902_9_78()
 {
    if (jj_scan_token(QUESTION)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_conditional_expression_900_5_53()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_conditional_expression_900_5_53()) return true;
    return false;
  }

  private boolean jj_3R_tag_key_707_9_92()
 {
    if (jj_3R_ident_477_5_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_tag_key_707_21_101()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_pp_supports_condition_328_5_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_pp_supports_condition_329_9_79()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_supports_condition_331_9_80()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_supports_condition_335_9_81()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_supports_condition_339_9_82()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_w_517_7_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_3R_w_517_13_76()) return true;
    }
    return false;
  }

  private boolean jj_3R_tag_key_705_9_91()
 {
    if (jj_3R_string_467_5_100()) return true;
    return false;
  }

  private boolean jj_3R_tag_key_705_9_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_tag_key_705_9_91()) {
    jj_scanpos = xsp;
    if (jj_3R_tag_key_707_9_92()) return true;
    }
    return false;
  }

  private boolean jj_3R_conditional_expression_900_5_53()
 {
    if (jj_3R_or_expression_921_5_77()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_conditional_expression_902_9_78()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_w_517_5_31()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_w_517_7_52()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_simple_key_value_condition_739_5_24()) return true;
    if (jj_3R_s_506_5_23()) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_ident_477_5_34()) return true;
    if (jj_scan_token(HEXCOLOR)) return true;
    return false;
  }

  private boolean jj_3R_literal_1085_9_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_1094_9_86()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_1096_9_87()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_1098_9_88()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_1103_9_89()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_1105_9_90()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_simple_key_condition_717_5_22()) return true;
    if (jj_3R_s_506_5_23()) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_s_506_5_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_expression_888_5_32()
 {
    if (jj_3R_conditional_expression_900_5_53()) return true;
    return false;
  }

  private boolean jj_3R_function_1072_11_128()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_expression_888_5_32()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_expression_888_5_32()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) return true;
    }
    return false;
  }

  private boolean jj_3R_function_1071_9_54()
 {
    if (jj_3R_expression_888_5_32()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_function_1072_11_128()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_string_or_ident_486_19_103()
 {
    if (jj_3R_string_467_5_100()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_float_array_531_5_30()) return true;
    if (jj_3R_w_517_5_31()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) return true;
    }
    return false;
  }

  private boolean jj_3R_float__459_41_95()
 {
    if (jj_3R_ufloat_450_5_50()) return true;
    return false;
  }

  private boolean jj_3R_function_1068_5_33()
 {
    if (jj_3R_ident_477_5_34()) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_w_517_5_31()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_function_1071_9_54()) jj_scanpos = xsp;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  private boolean jj_3R_regex_494_5_29()
 {
    if (jj_scan_token(REGEX)) return true;
    return false;
  }

  private boolean jj_3R_primary_1058_9_127()
 {
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_expression_888_5_32()) return true;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  private boolean jj_3R_string_or_ident_486_7_102()
 {
    if (jj_3R_ident_477_5_34()) return true;
    return false;
  }

  private boolean jj_3R_string_or_ident_486_5_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_string_or_ident_486_7_102()) {
    jj_scanpos = xsp;
    if (jj_3R_string_or_ident_486_19_103()) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_uint_434_5_21()) return true;
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_primary_1051_9_126()
 {
    if (jj_3R_literal_1085_9_60()) return true;
    return false;
  }

  private boolean jj_3R_ident_477_5_34()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) return true;
    }
    return false;
  }

  private boolean jj_3R_int__442_39_49()
 {
    if (jj_3R_uint_434_5_21()) return true;
    return false;
  }

  private boolean jj_3R_primary_1048_5_121()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_primary_1051_9_126()) {
    jj_scanpos = xsp;
    if (jj_3R_primary_1058_9_127()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_function_1068_5_33()) return true;
    return false;
  }

  private boolean jj_3R_multiplicative_expression_1011_38_123()
 {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_string_467_5_100()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_unary_expression_1031_9_125()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_3R_w_517_5_31()) return true;
    return false;
  }

  private boolean jj_3R_unary_expression_1029_9_124()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_w_517_5_31()) return true;
    return false;
  }

  private boolean jj_3R_unary_expression_1029_9_120()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_unary_expression_1029_9_124()) {
    jj_scanpos = xsp;
    if (jj_3R_unary_expression_1031_9_125()) return true;
    }
    return false;
  }

  private boolean jj_3R_float__459_5_94()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_ufloat_450_5_50()) return true;
    return false;
  }

  private boolean jj_3R_float__459_5_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_float__459_5_94()) {
    jj_scanpos = xsp;
    if (jj_3R_float__459_41_95()) return true;
    }
    return false;
  }

  private boolean jj_3R_unary_expression_1028_5_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_unary_expression_1029_9_120()) jj_scanpos = xsp;
    if (jj_3R_primary_1048_5_121()) return true;
    if (jj_3R_w_517_5_31()) return true;
    return false;
  }

  private boolean jj_3R_additive_expression_992_37_119()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_ufloat_450_5_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    return false;
  }

  private boolean jj_3R_multiplicative_expression_1011_11_122()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_multiplicative_expression_1011_9_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_multiplicative_expression_1011_11_122()) {
    jj_scanpos = xsp;
    if (jj_3R_multiplicative_expression_1011_38_123()) return true;
    }
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_unary_expression_1028_5_116()) return true;
    return false;
  }

  private boolean jj_3R_int__442_5_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_int__442_5_48()) {
    jj_scanpos = xsp;
    if (jj_3R_int__442_39_49()) return true;
    }
    return false;
  }

  private boolean jj_3R_int__442_5_48()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_uint_434_5_21()) return true;
    return false;
  }

  private boolean jj_3R_multiplicative_expression_1009_5_108()
 {
    if (jj_3R_unary_expression_1028_5_116()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_multiplicative_expression_1011_9_117()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_pp_supports_declaration_condition_379_61_39()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_3R_literal_1085_9_60()) return true;
    return false;
  }

  private boolean jj_3R_uint_434_5_21()
 {
    if (jj_scan_token(UINT)) return true;
    return false;
  }

  private boolean jj_3R_additive_expression_992_11_118()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_additive_expression_992_9_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_additive_expression_992_11_118()) {
    jj_scanpos = xsp;
    if (jj_3R_additive_expression_992_37_119()) return true;
    }
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_multiplicative_expression_1009_5_108()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_786_21_74()
 {
    if (jj_scan_token(LESS)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_784_21_73()
 {
    if (jj_scan_token(LESS_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_additive_expression_990_5_106()
 {
    if (jj_3R_multiplicative_expression_1009_5_108()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_additive_expression_992_9_109()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_782_21_72()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_776_25_70()
 {
    if (jj_3R_string_or_ident_486_5_93()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_780_21_71()
 {
    if (jj_scan_token(GREATER_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_774_25_69()
 {
    if (jj_3R_float__459_5_75()) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_972_13_115()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_970_13_114()
 {
    if (jj_scan_token(EQUAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_779_13_47()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_780_21_71()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_782_21_72()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_784_21_73()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_786_21_74()) return true;
    }
    }
    }
    if (jj_3R_s_506_5_23()) return true;
    if (jj_3R_float__459_5_75()) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_968_13_113()
 {
    if (jj_scan_token(LESS)) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_966_13_112()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_int__442_5_25()) return true;
    return false;
  }

  private boolean jj_3R_ufloat_unit_1119_51_57()
 {
    if (jj_scan_token(PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_766_21_67()
 {
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_964_13_111()
 {
    if (jj_scan_token(LESS_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_pp_w_399_4_38()
 {
    if (jj_3R_pp_w1_388_5_59()) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_764_21_66()
 {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_962_13_110()
 {
    if (jj_scan_token(GREATER_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_769_15_68()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_pp_w_399_2_19()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_pp_w_399_4_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_762_21_65()
 {
    if (jj_scan_token(CARET)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_760_21_64()
 {
    if (jj_scan_token(TILDE)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_relational_expression_961_9_107()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_relational_expression_962_13_110()) {
    jj_scanpos = xsp;
    if (jj_3R_relational_expression_964_13_111()) {
    jj_scanpos = xsp;
    if (jj_3R_relational_expression_966_13_112()) {
    jj_scanpos = xsp;
    if (jj_3R_relational_expression_968_13_113()) {
    jj_scanpos = xsp;
    if (jj_3R_relational_expression_970_13_114()) {
    jj_scanpos = xsp;
    if (jj_3R_relational_expression_972_13_115()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_w_517_5_31()) return true;
    if (jj_3R_additive_expression_990_5_106()) return true;
    return false;
  }

  private boolean jj_3R_pp_w1_392_5_85()
 {
    if (jj_scan_token(PP_COMMENT_START)) return true;
    if (jj_scan_token(PP_COMMENT_END)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_758_21_63()
 {
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_pp_w1_390_5_84()
 {
    if (jj_scan_token(PP_WHITESPACE)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_756_21_62()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_pp_w1_388_5_83()
 {
    if (jj_scan_token(PP_NEWLINECHAR)) return true;
    return false;
  }

  private boolean jj_3R_pp_w1_388_5_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_pp_w1_388_5_83()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_w1_390_5_84()) {
    jj_scanpos = xsp;
    if (jj_3R_pp_w1_392_5_85()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_relational_expression_959_5_104()
 {
    if (jj_3R_additive_expression_990_5_106()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_relational_expression_961_9_107()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_749_21_27()
 {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_747_21_26()
 {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_755_13_46()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_756_21_62()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_758_21_63()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_760_21_64()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_762_21_65()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_764_21_66()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_766_21_67()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_s_506_5_23()) return true;
    xsp = jj_scanpos;
    if (jj_3R_simple_key_value_condition_769_15_68()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_774_25_69()) {
    jj_scanpos = xsp;
    if (jj_3R_simple_key_value_condition_776_25_70()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_simple_key_value_condition_752_15_28()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_ufloat_unit_1119_30_56()
 {
    if (jj_scan_token(DEG)) return true;
    return false;
  }

  private boolean jj_3R_pp_supports_declaration_condition_379_5_20()
 {
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    if (jj_scan_token(IDENT)) return true;
    if (jj_3R_pp_w_399_2_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_pp_supports_declaration_condition_379_61_39()) jj_scanpos = xsp;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public MapCSSParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[78];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xfb38fe,0xf9380e,0xfb38fe,0x2,0x4,0x8,0x80000,0x80000,0x400000,0xe0,0xe0,0x1000,0x1001000,0x1001000,0xc00,0x2c00,0x8000000,0x8000000,0x8000000,0x200000,0x10000800,0x200000,0x0,0x40400000,0x40400000,0x0,0x0,0x10000800,0x10000800,0x0,0x40400000,0x40400000,0x0,0x1000,0x0,0x1000,0x5083c00,0x400000,0x2c00,0x0,0x12c00,0x0,0x12c00,0x0,0x10000000,0x10000000,0x10000000,0x1003c00,0x0,0x10000000,0x0,0x400000,0x10080c00,0xc00,0x0,0x0,0x40000,0x40000,0x40000,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x0,0x5083c00,0x200000,0x5083c00,0x2800,0x5001000,0xc00,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x1000,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x80c,0x20020,0x20020,0xf8080c,0xf8080c,0xf8080c,0x0,0x400,0x20020,0x20020,0x80,0x0,0x1000,0x0,0x1820,0x0,0x0,0x20,0x0,0x4000,0x0,0x30,0x0,0x18070,0x0,0x1000,0xf,0x1807f,0x20,0x20000,0x0,0x1000,0x20000,0x10,0x100,0x100,0x100,0x1000,0x4000,0x200,0x2000,0x10,0x3f,0x3f,0x1800,0x1800,0x0,0x0,0x1020,0x1020,0x800,0x0,0x1820,0x800,0x0,0x1040000,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[14];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public MapCSSParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MapCSSParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new MapCSSParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public MapCSSParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new MapCSSParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new MapCSSParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public MapCSSParser(MapCSSParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(MapCSSParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 78; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[61];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 78; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 61; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 14; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
