/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaInstance;

public class HandleInvocation
implements StackManipulation {
    private static final String METHOD_HANDLE_NAME = "java/lang/invoke/MethodHandle";
    private static final String INVOKE_EXACT = "invokeExact";
    private final JavaInstance.MethodType methodType;

    public HandleInvocation(JavaInstance.MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitMethodInsn(182, METHOD_HANDLE_NAME, INVOKE_EXACT, this.methodType.getDescriptor(), false);
        int size = this.methodType.getReturnType().getStackSize().getSize() - this.methodType.getParameterTypes().getStackSize();
        return new StackManipulation.Size(size, Math.max(size, 0));
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.methodType.equals(((HandleInvocation)other).methodType);
    }

    public int hashCode() {
        return this.methodType.hashCode();
    }

    public String toString() {
        return "HandleInvocation{methodType=" + this.methodType + '}';
    }
}

