/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.RuntimeType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.CompoundList;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface AllArguments {
    public Assignment value() default Assignment.STRICT;

    public boolean includeSelf() default false;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<AllArguments>
    {
        INSTANCE;


        @Override
        public Class<AllArguments> getHandledType() {
            return AllArguments.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<AllArguments> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            if (!target.getType().isArray()) {
                throw new IllegalStateException("Expected an array type for all argument annotation on " + source);
            }
            ArrayFactory arrayFactory = ArrayFactory.forType(target.getType().getComponentType());
            boolean includeThis = !source.isStatic() && annotation.loadSilent().includeSelf();
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(source.getParameters().size() + (includeThis ? 1 : 0));
            int offset = source.isStatic() || includeThis ? 0 : 1;
            for (TypeDescription.Generic sourceParameter : includeThis ? CompoundList.of(implementationTarget.getInstrumentedType().asGenericType(), source.getParameters().asTypeList()) : source.getParameters().asTypeList()) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.of(sourceParameter).loadOffset(offset), assigner.assign(sourceParameter, arrayFactory.getComponentType(), RuntimeType.Verifier.check(target)));
                if (stackManipulation.isValid()) {
                    stackManipulations.add(stackManipulation);
                } else if (annotation.loadSilent().value().isStrict()) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }
                offset += sourceParameter.getStackSize().getSize();
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(arrayFactory.withValues(stackManipulations));
        }

        public String toString() {
            return "AllArguments.Binder." + this.name();
        }
    }

    public static enum Assignment {
        STRICT(true),
        SLACK(false);

        private final boolean strict;

        private Assignment(boolean strict) {
            this.strict = strict;
        }

        protected boolean isStrict() {
            return this.strict;
        }

        public String toString() {
            return "AllArguments.Assignment." + this.name();
        }
    }
}

