/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.enumeration.EnumerationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDefinition;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.Removal;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.ClassConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.FloatConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.LongConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.NullConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.TextConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.CompoundList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaInstance;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public class InvokeDynamic
implements Implementation.Composable {
    protected final MethodDescription.InDefinedShape bootstrapMethod;
    protected final List<?> handleArguments;
    protected final InvocationProvider invocationProvider;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected InvokeDynamic(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.bootstrapMethod = bootstrapMethod;
        this.handleArguments = handleArguments;
        this.invocationProvider = invocationProvider;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithImplicitTarget bootstrap(Method method, Object ... rawArgument) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), rawArgument);
    }

    public static WithImplicitTarget bootstrap(Method method, List<?> rawArguments) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), rawArguments);
    }

    public static WithImplicitTarget bootstrap(Constructor<?> constructor, Object ... rawArgument) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), rawArgument);
    }

    public static WithImplicitTarget bootstrap(Constructor<?> constructor, List<?> rawArguments) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), rawArguments);
    }

    public static WithImplicitTarget bootstrap(MethodDescription.InDefinedShape bootstrapMethod, Object ... rawArgument) {
        return InvokeDynamic.bootstrap(bootstrapMethod, Arrays.asList(rawArgument));
    }

    public static WithImplicitTarget bootstrap(MethodDescription.InDefinedShape bootstrapMethod, List<?> rawArguments) {
        ArrayList arguments = new ArrayList(rawArguments.size());
        for (Object argument : rawArguments) {
            if (argument instanceof Class) {
                argument = new TypeDescription.ForLoadedType((Class)argument);
            } else if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(argument)) {
                argument = JavaInstance.MethodHandle.ofLoaded(argument);
            } else if (JavaType.METHOD_TYPE.getTypeStub().isInstance(argument)) {
                argument = JavaInstance.MethodType.ofLoaded(argument);
            }
            arguments.add(argument);
        }
        if (!bootstrapMethod.isBootstrap(arguments)) {
            throw new IllegalArgumentException("Not a valid bootstrap method " + bootstrapMethod + " for " + arguments);
        }
        ArrayList serializedArguments = new ArrayList(arguments.size());
        for (Object anArgument : arguments) {
            if (anArgument instanceof TypeDescription) {
                anArgument = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getType(((TypeDescription)anArgument).getDescriptor());
            } else if (anArgument instanceof JavaInstance) {
                anArgument = ((JavaInstance)anArgument).asConstantPoolValue();
            }
            serializedArguments.add(anArgument);
        }
        return new WithImplicitTarget(bootstrapMethod, serializedArguments, new InvocationProvider.Default(), TerminationHandler.ForMethodReturn.INSTANCE, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public InvokeDynamic withBooleanValue(boolean ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (boolean aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForBooleanConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withByteValue(byte ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (byte aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForByteConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withShortValue(short ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (short aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForShortConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withCharacterValue(char ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (char aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForCharacterConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withIntegerValue(int ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (int aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForIntegerConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withLongValue(long ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (long aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForLongConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withFloatValue(float ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (float aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForFloatConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withDoubleValue(double ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (double aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForDoubleConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withValue(Object ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (Object aValue : value) {
            argumentProviders.add(InvocationProvider.ArgumentProvider.ConstantPoolWrapper.of(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public WithImplicitFieldType withReference(Object value) {
        return new WithImplicitFieldType(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, this.assigner, this.typing, value);
    }

    public InvokeDynamic withReference(Object ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (Object aValue : value) {
            argumentProviders.add(InvocationProvider.ArgumentProvider.ForStaticField.of(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withType(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForClassConstant(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withEnumeration(EnumerationDescription ... enumerationDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(enumerationDescription.length);
        for (EnumerationDescription anEnumerationDescription : enumerationDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForEnumerationValue(anEnumerationDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withInstance(JavaInstance ... javaInstance) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(javaInstance.length);
        for (JavaInstance aJavaInstance : javaInstance) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForJavaInstance(aJavaInstance));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withNullValue(Class<?> ... type) {
        return this.withNullValue(new TypeList.ForLoadedTypes(type).toArray(new TypeDescription[type.length]));
    }

    public InvokeDynamic withNullValue(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            if (aTypeDescription.isPrimitive()) {
                throw new IllegalArgumentException("Cannot assign null to primitive type: " + aTypeDescription);
            }
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForNullValue(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withArgument(int ... index) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Method parameter indices cannot be negative: " + anIndex);
            }
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForMethodParameter(anIndex));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public WithImplicitArgumentType withArgument(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Method parameter indices cannot be negative: " + index);
        }
        return new WithImplicitArgumentType(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, this.assigner, this.typing, index);
    }

    public InvokeDynamic withThis(Class<?> ... type) {
        return this.withThis(new TypeList.ForLoadedTypes(type).toArray(new TypeDescription[type.length]));
    }

    public InvokeDynamic withThis(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForThisInstance(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withMethodArguments() {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(InvocationProvider.ArgumentProvider.ForInterceptedMethodParameters.INSTANCE), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withImplicitAndMethodArguments() {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(InvocationProvider.ArgumentProvider.ForInterceptedMethodInstanceAndParameters.INSTANCE), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withInstanceField(String fieldName, Type fieldType) {
        return this.withInstanceField(fieldName, TypeDefinition.Sort.describe(fieldType));
    }

    public InvokeDynamic withInstanceField(String fieldName, TypeDefinition fieldType) {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForInstanceField(fieldName, fieldType.asGenericType())), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withField(String ... fieldName) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(fieldName.length);
        for (String aFieldName : fieldName) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForExistingField(aFieldName));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider, TerminationHandler.ForChainedInvocation.INSTANCE, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.invocationProvider.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget.getInstrumentedType());
    }

    protected InvocationProvider getInvocationProvider() {
        return this.invocationProvider;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InvokeDynamic)) {
            return false;
        }
        InvokeDynamic that = (InvokeDynamic)other;
        return this.typing == that.typing && this.assigner.equals(that.assigner) && this.bootstrapMethod.equals(that.bootstrapMethod) && this.handleArguments.equals(that.handleArguments) && this.invocationProvider.equals(that.getInvocationProvider()) && this.terminationHandler.equals(that.terminationHandler);
    }

    public int hashCode() {
        int result = this.bootstrapMethod.hashCode();
        result = 31 * result + this.handleArguments.hashCode();
        result = 31 * result + this.getInvocationProvider().hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.typing.hashCode();
        return result;
    }

    public String toString() {
        return "InvokeDynamic{bootstrapMethod=" + this.bootstrapMethod + ", handleArguments=" + this.handleArguments + ", invocationProvider=" + this.invocationProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
    }

    protected class Appender
    implements ByteCodeAppender {
        private final TypeDescription instrumentedType;

        public Appender(TypeDescription instrumentedType) {
            this.instrumentedType = instrumentedType;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            InvocationProvider.Target.Resolved target = InvokeDynamic.this.invocationProvider.make(instrumentedMethod).resolve(this.instrumentedType, InvokeDynamic.this.assigner, InvokeDynamic.this.typing);
            StackManipulation.Size size = new StackManipulation.Compound(target.getStackManipulation(), MethodInvocation.invoke(InvokeDynamic.this.bootstrapMethod).dynamic(target.getInternalName(), target.getReturnType(), target.getParameterTypes(), InvokeDynamic.this.handleArguments), InvokeDynamic.this.terminationHandler.resolve(instrumentedMethod, target.getReturnType(), InvokeDynamic.this.assigner, InvokeDynamic.this.typing)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.instrumentedType.equals(appender.instrumentedType) && InvokeDynamic.this.equals(appender.getOuter());
        }

        private InvokeDynamic getOuter() {
            return InvokeDynamic.this;
        }

        public int hashCode() {
            return this.instrumentedType.hashCode();
        }

        public String toString() {
            return "InvokeDynamic.Appender{invokeDynamic=" + InvokeDynamic.this + ", instrumentedType=" + this.instrumentedType + '}';
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Super type implementation convers use case")
    public static class WithImplicitArgumentType
    extends AbstractDelegator {
        private final int index;

        protected WithImplicitArgumentType(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing, int index) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
            this.index = index;
        }

        public InvokeDynamic as(Class<?> type) {
            return this.as(new TypeDescription.ForLoadedType(type));
        }

        public InvokeDynamic as(TypeDescription typeDescription) {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForExplicitTypedMethodParameter(this.index, typeDescription)), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        protected InvokeDynamic materialize() {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForMethodParameter(this.index)), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        public InvokeDynamic withAssigner(Assigner assigner, Assigner.Typing typing) {
            return this.materialize().withAssigner(assigner, typing);
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return this.materialize().andThen(implementation);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return this.materialize().prepare(instrumentedType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this.materialize().appender(implementationTarget);
        }

        @Override
        protected InvocationProvider getInvocationProvider() {
            return this.materialize().getInvocationProvider();
        }

        @Override
        public String toString() {
            return "InvokeDynamic.WithImplicitArgumentType{bootstrapMethod=" + this.bootstrapMethod + ", handleArguments=" + this.handleArguments + ", invocationProvider=" + this.invocationProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", index=" + this.index + '}';
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Super type implementation convers use case")
    public static class WithImplicitFieldType
    extends AbstractDelegator {
        private final Object value;
        private final InvocationProvider.ArgumentProvider argumentProvider;

        protected WithImplicitFieldType(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing, Object value) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
            this.value = value;
            this.argumentProvider = InvocationProvider.ArgumentProvider.ForStaticField.of(value);
        }

        public InvokeDynamic as(Type type) {
            return this.as(TypeDefinition.Sort.describe(type));
        }

        public InvokeDynamic as(TypeDefinition typeDefinition) {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForStaticField(this.value, typeDefinition.asGenericType())), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        protected InvokeDynamic materialize() {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(this.argumentProvider), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        public InvokeDynamic withAssigner(Assigner assigner, Assigner.Typing typing) {
            return this.materialize().withAssigner(assigner, typing);
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return this.materialize().andThen(implementation);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return this.materialize().prepare(instrumentedType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this.materialize().appender(implementationTarget);
        }

        @Override
        protected InvocationProvider getInvocationProvider() {
            return this.materialize().getInvocationProvider();
        }

        @Override
        public String toString() {
            return "InvokeDynamic.WithImplicitFieldType{bootstrapMethod=" + this.bootstrapMethod + ", handleArguments=" + this.handleArguments + ", invocationProvider=" + this.invocationProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", value=" + this.value + '}';
        }
    }

    public static class WithImplicitTarget
    extends WithImplicitArguments {
        protected WithImplicitTarget(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        public WithImplicitArguments invoke(Class<?> returnType) {
            return this.invoke(new TypeDescription.ForLoadedType(returnType));
        }

        public WithImplicitArguments invoke(TypeDescription returnType) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withReturnTypeProvider(new InvocationProvider.ReturnTypeProvider.ForExplicitType(returnType)), this.terminationHandler, this.assigner, this.typing);
        }

        public WithImplicitArguments invoke(String methodName) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withNameProvider(new InvocationProvider.NameProvider.ForExplicitName(methodName)), this.terminationHandler, this.assigner, this.typing);
        }

        public WithImplicitArguments invoke(String methodName, Class<?> returnType) {
            return this.invoke(methodName, new TypeDescription.ForLoadedType(returnType));
        }

        public WithImplicitArguments invoke(String methodName, TypeDescription returnType) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withNameProvider(new InvocationProvider.NameProvider.ForExplicitName(methodName)).withReturnTypeProvider(new InvocationProvider.ReturnTypeProvider.ForExplicitType(returnType)), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        public String toString() {
            return "InvokeDynamic.WithImplicitTarget{bootstrapMethod=" + this.bootstrapMethod + ", handleArguments=" + this.handleArguments + ", invocationProvider=" + this.invocationProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }
    }

    public static class WithImplicitArguments
    extends AbstractDelegator {
        protected WithImplicitArguments(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        public InvokeDynamic withoutArguments() {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withoutArguments(), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        protected InvokeDynamic materialize() {
            return this.withoutArguments();
        }

        @Override
        public WithImplicitArguments withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, assigner, typing);
        }

        @Override
        public String toString() {
            return "InvokeDynamic.WithImplicitArguments{bootstrapMethod=" + this.bootstrapMethod + ", handleArguments=" + this.handleArguments + ", invocationProvider=" + this.invocationProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }
    }

    protected static abstract class AbstractDelegator
    extends InvokeDynamic {
        public AbstractDelegator(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        protected abstract InvokeDynamic materialize();

        @Override
        public InvokeDynamic withBooleanValue(boolean ... value) {
            return this.materialize().withBooleanValue(value);
        }

        @Override
        public InvokeDynamic withByteValue(byte ... value) {
            return this.materialize().withByteValue(value);
        }

        @Override
        public InvokeDynamic withShortValue(short ... value) {
            return this.materialize().withShortValue(value);
        }

        @Override
        public InvokeDynamic withCharacterValue(char ... value) {
            return this.materialize().withCharacterValue(value);
        }

        @Override
        public InvokeDynamic withIntegerValue(int ... value) {
            return this.materialize().withIntegerValue(value);
        }

        @Override
        public InvokeDynamic withLongValue(long ... value) {
            return this.materialize().withLongValue(value);
        }

        @Override
        public InvokeDynamic withFloatValue(float ... value) {
            return this.materialize().withFloatValue(value);
        }

        @Override
        public InvokeDynamic withDoubleValue(double ... value) {
            return this.materialize().withDoubleValue(value);
        }

        @Override
        public InvokeDynamic withValue(Object ... value) {
            return this.materialize().withValue(value);
        }

        @Override
        public WithImplicitFieldType withReference(Object value) {
            return this.materialize().withReference(value);
        }

        @Override
        public InvokeDynamic withReference(Object ... value) {
            return this.materialize().withReference(value);
        }

        @Override
        public InvokeDynamic withType(TypeDescription ... typeDescription) {
            return this.materialize().withType(typeDescription);
        }

        @Override
        public InvokeDynamic withInstance(JavaInstance ... javaInstance) {
            return this.materialize().withInstance(javaInstance);
        }

        @Override
        public InvokeDynamic withNullValue(Class<?> ... type) {
            return this.materialize().withNullValue(type);
        }

        @Override
        public InvokeDynamic withNullValue(TypeDescription ... typeDescription) {
            return this.materialize().withNullValue(typeDescription);
        }

        @Override
        public InvokeDynamic withArgument(int ... index) {
            return this.materialize().withArgument(index);
        }

        @Override
        public WithImplicitArgumentType withArgument(int index) {
            return this.materialize().withArgument(index);
        }

        @Override
        public InvokeDynamic withThis(Class<?> ... type) {
            return this.materialize().withThis(type);
        }

        @Override
        public InvokeDynamic withThis(TypeDescription ... typeDescription) {
            return this.materialize().withThis(typeDescription);
        }

        @Override
        public InvokeDynamic withMethodArguments() {
            return this.materialize().withMethodArguments();
        }

        @Override
        public InvokeDynamic withImplicitAndMethodArguments() {
            return this.materialize().withImplicitAndMethodArguments();
        }

        @Override
        public InvokeDynamic withInstanceField(String fieldName, Type fieldType) {
            return this.materialize().withInstanceField(fieldName, fieldType);
        }

        @Override
        public InvokeDynamic withInstanceField(String fieldName, TypeDefinition fieldType) {
            return this.materialize().withInstanceField(fieldName, fieldType);
        }

        @Override
        public InvokeDynamic withField(String ... fieldName) {
            return this.materialize().withField(fieldName);
        }
    }

    protected static interface TerminationHandler {
        public StackManipulation resolve(MethodDescription var1, TypeDescription var2, Assigner var3, Assigner.Typing var4);

        public static enum ForChainedInvocation implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription interceptedMethod, TypeDescription returnType, Assigner assigner, Assigner.Typing typing) {
                return Removal.pop(interceptedMethod.isConstructor() ? interceptedMethod.getDeclaringType().asErasure() : interceptedMethod.getReturnType().asErasure());
            }

            public String toString() {
                return "InvokeDynamic.TerminationHandler.ForChainedInvocation." + this.name();
            }
        }

        public static enum ForMethodReturn implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription interceptedMethod, TypeDescription returnType, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(returnType.asGenericType(), interceptedMethod.getReturnType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + returnType + " from " + interceptedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.returning(interceptedMethod.getReturnType().asErasure()));
            }

            public String toString() {
                return "InvokeDynamic.TerminationHandler.ForMethodReturn." + this.name();
            }
        }
    }

    protected static interface InvocationProvider {
        public Target make(MethodDescription var1);

        public InvocationProvider appendArguments(List<ArgumentProvider> var1);

        public InvocationProvider appendArgument(ArgumentProvider var1);

        public InvocationProvider withoutArguments();

        public InvocationProvider withNameProvider(NameProvider var1);

        public InvocationProvider withReturnTypeProvider(ReturnTypeProvider var1);

        public InstrumentedType prepare(InstrumentedType var1);

        public static class Default
        implements InvocationProvider {
            private final NameProvider nameProvider;
            private final ReturnTypeProvider returnTypeProvider;
            private final List<ArgumentProvider> argumentProviders;

            public Default() {
                this(NameProvider.ForInterceptedMethod.INSTANCE, ReturnTypeProvider.ForInterceptedMethod.INSTANCE, Collections.singletonList(ArgumentProvider.ForInterceptedMethodInstanceAndParameters.INSTANCE));
            }

            public Default(NameProvider nameProvider, ReturnTypeProvider returnTypeProvider, List<ArgumentProvider> argumentProviders) {
                this.nameProvider = nameProvider;
                this.returnTypeProvider = returnTypeProvider;
                this.argumentProviders = argumentProviders;
            }

            @Override
            public Target make(MethodDescription methodDescription) {
                return new Target(this.nameProvider.resolve(methodDescription), this.returnTypeProvider.resolve(methodDescription), this.argumentProviders, methodDescription);
            }

            @Override
            public InvocationProvider appendArguments(List<ArgumentProvider> argumentProviders) {
                return new Default(this.nameProvider, this.returnTypeProvider, CompoundList.of(this.argumentProviders, argumentProviders));
            }

            @Override
            public InvocationProvider appendArgument(ArgumentProvider argumentProvider) {
                return new Default(this.nameProvider, this.returnTypeProvider, CompoundList.of(this.argumentProviders, argumentProvider));
            }

            @Override
            public InvocationProvider withoutArguments() {
                return new Default(this.nameProvider, this.returnTypeProvider, Collections.<ArgumentProvider>emptyList());
            }

            @Override
            public InvocationProvider withNameProvider(NameProvider nameProvider) {
                return new Default(nameProvider, this.returnTypeProvider, this.argumentProviders);
            }

            @Override
            public InvocationProvider withReturnTypeProvider(ReturnTypeProvider returnTypeProvider) {
                return new Default(this.nameProvider, returnTypeProvider, this.argumentProviders);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                for (ArgumentProvider argumentProvider : this.argumentProviders) {
                    instrumentedType = argumentProvider.prepare(instrumentedType);
                }
                return instrumentedType;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Default that = (Default)other;
                return this.argumentProviders.equals(that.argumentProviders) && this.nameProvider.equals(that.nameProvider) && this.returnTypeProvider.equals(that.returnTypeProvider);
            }

            public int hashCode() {
                int result = this.nameProvider.hashCode();
                result = 31 * result + this.returnTypeProvider.hashCode();
                result = 31 * result + this.argumentProviders.hashCode();
                return result;
            }

            public String toString() {
                return "InvokeDynamic.InvocationProvider.Default{nameProvider=" + this.nameProvider + ", returnTypeProvider=" + this.returnTypeProvider + ", argumentProviders=" + this.argumentProviders + '}';
            }

            protected static class Target
            implements nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.InvokeDynamic$InvocationProvider$Target {
                private final String internalName;
                private final TypeDescription returnType;
                private final List<ArgumentProvider> argumentProviders;
                private final MethodDescription instrumentedMethod;

                public Target(String internalName, TypeDescription returnType, List<ArgumentProvider> argumentProviders, MethodDescription instrumentedMethod) {
                    this.internalName = internalName;
                    this.returnType = returnType;
                    this.argumentProviders = argumentProviders;
                    this.instrumentedMethod = instrumentedMethod;
                }

                @Override
                public Target.Resolved resolve(TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                    StackManipulation[] stackManipulation = new StackManipulation[this.argumentProviders.size()];
                    ArrayList<TypeDescription> parameterTypes = new ArrayList<TypeDescription>();
                    int index = 0;
                    for (ArgumentProvider argumentProvider : this.argumentProviders) {
                        ArgumentProvider.Resolved resolved = argumentProvider.resolve(instrumentedType, this.instrumentedMethod, assigner, typing);
                        parameterTypes.addAll(resolved.getLoadedTypes());
                        stackManipulation[index++] = resolved.getLoadInstruction();
                    }
                    return new Target.Resolved.Simple(new StackManipulation.Compound(stackManipulation), this.internalName, this.returnType, parameterTypes);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Target target = (Target)other;
                    return this.argumentProviders.equals(target.argumentProviders) && this.instrumentedMethod.equals(target.instrumentedMethod) && this.internalName.equals(target.internalName) && this.returnType.equals(target.returnType);
                }

                public int hashCode() {
                    int result = this.internalName.hashCode();
                    result = 31 * result + this.returnType.hashCode();
                    result = 31 * result + this.argumentProviders.hashCode();
                    result = 31 * result + this.instrumentedMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.Default.Target{internalName='" + this.internalName + '\'' + ", returnType=" + this.returnType + ", argumentProviders=" + this.argumentProviders + ", instrumentedMethod=" + this.instrumentedMethod + '}';
                }
            }
        }

        public static interface ReturnTypeProvider {
            public TypeDescription resolve(MethodDescription var1);

            public static class ForExplicitType
            implements ReturnTypeProvider {
                private final TypeDescription typeDescription;

                public ForExplicitType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public TypeDescription resolve(MethodDescription methodDescription) {
                    return this.typeDescription;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForExplicitType)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ReturnTypeProvider.ForExplicitType{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static enum ForInterceptedMethod implements ReturnTypeProvider
            {
                INSTANCE;


                @Override
                public TypeDescription resolve(MethodDescription methodDescription) {
                    return methodDescription.getReturnType().asErasure();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ReturnTypeProvider.ForInterceptedMethod." + this.name();
                }
            }
        }

        public static interface NameProvider {
            public String resolve(MethodDescription var1);

            public static class ForExplicitName
            implements NameProvider {
                private final String internalName;

                public ForExplicitName(String internalName) {
                    this.internalName = internalName;
                }

                @Override
                public String resolve(MethodDescription methodDescription) {
                    return this.internalName;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.internalName.equals(((ForExplicitName)other).internalName);
                }

                public int hashCode() {
                    return this.internalName.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.NameProvider.ForExplicitName{internalName='" + this.internalName + '\'' + '}';
                }
            }

            public static enum ForInterceptedMethod implements NameProvider
            {
                INSTANCE;


                @Override
                public String resolve(MethodDescription methodDescription) {
                    return methodDescription.getInternalName();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.NameProvider.ForInterceptedMethod." + this.name();
                }
            }
        }

        public static interface ArgumentProvider {
            public Resolved resolve(TypeDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);

            public InstrumentedType prepare(InstrumentedType var1);

            public static class ForJavaInstance
            implements ArgumentProvider {
                private final JavaInstance javaInstance;

                public ForJavaInstance(JavaInstance javaInstance) {
                    this.javaInstance = javaInstance;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(this.javaInstance.asStackManipulation(), this.javaInstance.getInstanceType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.javaInstance.equals(((ForJavaInstance)other).javaInstance);
                }

                public int hashCode() {
                    return this.javaInstance.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForJavaInstance{javaInstance=" + this.javaInstance + '}';
                }
            }

            public static class ForNullValue
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                public ForNullValue(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)NullConstant.INSTANCE, this.typeDescription);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForNullValue)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForNullValue{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static class ForEnumerationValue
            implements ArgumentProvider {
                private final EnumerationDescription enumerationDescription;

                public ForEnumerationValue(EnumerationDescription enumerationDescription) {
                    this.enumerationDescription = enumerationDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(FieldAccess.forEnumeration(this.enumerationDescription), this.enumerationDescription.getEnumerationType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.enumerationDescription.equals(((ForEnumerationValue)other).enumerationDescription);
                }

                public int hashCode() {
                    return this.enumerationDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForEnumerationValue{enumerationDescription=" + this.enumerationDescription + '}';
                }
            }

            public static class ForClassConstant
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                public ForClassConstant(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(ClassConstant.of(this.typeDescription), TypeDescription.CLASS);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForClassConstant)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForClassConstant{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static class ForStringConstant
            implements ArgumentProvider {
                private final String value;

                public ForStringConstant(String value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)new TextConstant(this.value), TypeDescription.STRING);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value.equals(((ForStringConstant)other).value);
                }

                public int hashCode() {
                    return this.value.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForStringConstant{value='" + this.value + '\'' + '}';
                }
            }

            public static class ForDoubleConstant
            implements ArgumentProvider {
                private final double value;

                public ForDoubleConstant(double value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(DoubleConstant.forValue(this.value), new TypeDescription.ForLoadedType(Double.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && Double.compare(((ForDoubleConstant)other).value, this.value) == 0;
                }

                public int hashCode() {
                    long temp = Double.doubleToLongBits(this.value);
                    return (int)(temp ^ temp >>> 32);
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForDoubleConstant{value=" + this.value + '}';
                }
            }

            public static class ForFloatConstant
            implements ArgumentProvider {
                private final float value;

                public ForFloatConstant(float value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(FloatConstant.forValue(this.value), new TypeDescription.ForLoadedType(Float.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && Float.compare(((ForFloatConstant)other).value, this.value) == 0;
                }

                public int hashCode() {
                    return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForFloatConstant{value=" + this.value + '}';
                }
            }

            public static class ForLongConstant
            implements ArgumentProvider {
                private final long value;

                public ForLongConstant(long value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(LongConstant.forValue(this.value), new TypeDescription.ForLoadedType(Long.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForLongConstant)other).value;
                }

                public int hashCode() {
                    return (int)(this.value ^ this.value >>> 32);
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForLongConstant{value=" + this.value + '}';
                }
            }

            public static class ForIntegerConstant
            implements ArgumentProvider {
                private final int value;

                public ForIntegerConstant(int value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Integer.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForIntegerConstant)other).value;
                }

                public int hashCode() {
                    return this.value;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForIntegerConstant{value=" + this.value + '}';
                }
            }

            public static class ForCharacterConstant
            implements ArgumentProvider {
                private final char value;

                public ForCharacterConstant(char value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Character.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForCharacterConstant)other).value;
                }

                public int hashCode() {
                    return this.value;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForCharacterConstant{value=" + this.value + '}';
                }
            }

            public static class ForShortConstant
            implements ArgumentProvider {
                private final short value;

                public ForShortConstant(short value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Short.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForShortConstant)other).value;
                }

                public int hashCode() {
                    return this.value;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForShortConstant{value=" + this.value + '}';
                }
            }

            public static class ForByteConstant
            implements ArgumentProvider {
                private final byte value;

                public ForByteConstant(byte value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Byte.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForByteConstant)other).value;
                }

                public int hashCode() {
                    return this.value;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForByteConstant{value=" + this.value + '}';
                }
            }

            public static class ForBooleanConstant
            implements ArgumentProvider {
                private final boolean value;

                public ForBooleanConstant(boolean value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Boolean.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForBooleanConstant)other).value;
                }

                public int hashCode() {
                    return this.value ? 1 : 0;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForBooleanConstant{value=" + this.value + '}';
                }
            }

            public static class ForExplicitTypedMethodParameter
            implements ArgumentProvider {
                private final int index;
                private final TypeDescription typeDescription;

                public ForExplicitTypedMethodParameter(int index, TypeDescription typeDescription) {
                    this.index = index;
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (this.index >= parameters.size()) {
                        throw new IllegalStateException("No parameter " + this.index + " for " + instrumentedMethod);
                    }
                    StackManipulation stackManipulation = assigner.assign(((ParameterDescription)parameters.get(this.index)).getType(), this.typeDescription.asGenericType(), typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalArgumentException("Cannot assign " + parameters.get(this.index) + " to " + this.typeDescription);
                    }
                    return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(MethodVariableAccess.of(((ParameterDescription)parameters.get(this.index)).getType().asErasure()).loadOffset(((ParameterDescription)parameters.get(this.index)).getOffset()), stackManipulation), this.typeDescription);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.index == ((ForExplicitTypedMethodParameter)other).index && this.typeDescription.equals(((ForExplicitTypedMethodParameter)other).typeDescription);
                }

                public int hashCode() {
                    return this.index + 31 * this.typeDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForExplicitTypedMethodParameter{index=" + this.index + ", typeDescription=" + this.typeDescription + '}';
                }
            }

            public static class ForMethodParameter
            implements ArgumentProvider {
                private final int index;

                public ForMethodParameter(int index) {
                    this.index = index;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (this.index >= parameters.size()) {
                        throw new IllegalStateException("No parameter " + this.index + " for " + instrumentedMethod);
                    }
                    return new Resolved.Simple(MethodVariableAccess.of(((ParameterDescription)parameters.get(this.index)).getType().asErasure()).loadOffset(((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getOffset()), ((ParameterDescription)parameters.get(this.index)).getType().asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.index == ((ForMethodParameter)other).index;
                }

                public int hashCode() {
                    return this.index;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForMethodParameter{index=" + this.index + '}';
                }
            }

            public static class ForExistingField
            implements ArgumentProvider {
                private final String fieldName;

                public ForExistingField(String fieldName) {
                    this.fieldName = fieldName;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    FieldDescription fieldDescription = this.locate(instrumentedType);
                    if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot access non-static " + fieldDescription + " from " + instrumentedMethod);
                    }
                    return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(fieldDescription).getter()), fieldDescription.getType().asErasure());
                }

                private FieldDescription locate(TypeDescription instrumentedType) {
                    for (TypeDefinition currentType : instrumentedType) {
                        FieldList fieldList = (FieldList)currentType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName).and(ElementMatchers.isVisibleTo(instrumentedType)));
                        if (fieldList.size() == 0) continue;
                        return (FieldDescription)fieldList.getOnly();
                    }
                    throw new IllegalStateException(instrumentedType + " does not define a visible field " + this.fieldName);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForExistingField)other).fieldName);
                }

                public int hashCode() {
                    return this.fieldName.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForExistingField{fieldName='" + this.fieldName + '\'' + '}';
                }
            }

            public static class ForInstanceField
            implements ArgumentProvider {
                private final String fieldName;
                private final TypeDescription.Generic fieldType;

                public ForInstanceField(String fieldName, TypeDescription.Generic fieldType) {
                    this.fieldName = fieldName;
                    this.fieldType = fieldType;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot access " + this.fieldName + " from " + instrumentedMethod);
                    }
                    return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter()), this.fieldType.asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4097, this.fieldType));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForInstanceField that = (ForInstanceField)other;
                    return this.fieldName.equals(that.fieldName) && this.fieldType.equals(that.fieldType);
                }

                public int hashCode() {
                    int result = this.fieldName.hashCode();
                    result = 31 * result + this.fieldType.hashCode();
                    return result;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
                }
            }

            public static class ForStaticField
            implements ArgumentProvider {
                private static final String FIELD_PREFIX = "invokeDynamic";
                private final Object value;
                private final TypeDescription.Generic fieldType;
                private final String name;

                public ForStaticField(Object value, TypeDescription.Generic fieldType) {
                    this.value = value;
                    this.fieldType = fieldType;
                    this.name = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
                }

                public static ArgumentProvider of(Object value) {
                    return new ForStaticField(value, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(value.getClass()));
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    FieldDescription fieldDescription = (FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly();
                    StackManipulation stackManipulation = assigner.assign(fieldDescription.getType(), this.fieldType, typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + this.fieldType);
                    }
                    return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(FieldAccess.forField(fieldDescription).getter(), stackManipulation), fieldDescription.getType().asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.value));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldType.equals(((ForStaticField)other).fieldType) && this.value.equals(((ForStaticField)other).value);
                }

                public int hashCode() {
                    return 31 * this.value.hashCode() + this.fieldType.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForStaticField{value=" + this.value + ", fieldType=" + this.fieldType + ", name='" + this.name + '\'' + '}';
                }
            }

            public static class ForThisInstance
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                public ForThisInstance(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot get this instance from static method: " + instrumentedMethod);
                    }
                    if (!instrumentedType.isAssignableTo(this.typeDescription)) {
                        throw new IllegalStateException(instrumentedType + " is not assignable to " + instrumentedType);
                    }
                    return new Resolved.Simple(MethodVariableAccess.REFERENCE.loadOffset(0), this.typeDescription);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForThisInstance)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForThisInstance{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static interface Resolved {
                public StackManipulation getLoadInstruction();

                public List<TypeDescription> getLoadedTypes();

                public static class Simple
                implements Resolved {
                    private final StackManipulation stackManipulation;
                    private final List<TypeDescription> loadedTypes;

                    public Simple(StackManipulation stackManipulation, TypeDescription loadedType) {
                        this(stackManipulation, Collections.singletonList(loadedType));
                    }

                    public Simple(StackManipulation stackManipulation, List<TypeDescription> loadedTypes) {
                        this.stackManipulation = stackManipulation;
                        this.loadedTypes = loadedTypes;
                    }

                    @Override
                    public StackManipulation getLoadInstruction() {
                        return this.stackManipulation;
                    }

                    @Override
                    public List<TypeDescription> getLoadedTypes() {
                        return this.loadedTypes;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Simple simple = (Simple)other;
                        return this.loadedTypes.equals(simple.loadedTypes) && this.stackManipulation.equals(simple.stackManipulation);
                    }

                    public int hashCode() {
                        int result = this.stackManipulation.hashCode();
                        result = 31 * result + this.loadedTypes.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "InvokeDynamic.InvocationProvider.ArgumentProvider.Resolved.Simple{stackManipulation=" + this.stackManipulation + ", loadedTypes=" + this.loadedTypes + '}';
                    }
                }
            }

            public static enum ConstantPoolWrapper {
                BOOLEAN((Class)Boolean.TYPE, (Class)Boolean.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue((Boolean)value));
                    }
                }
                ,
                BYTE((Class)Byte.TYPE, (Class)Byte.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Byte)value).byteValue()));
                    }
                }
                ,
                SHORT((Class)Short.TYPE, (Class)Short.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Short)value).shortValue()));
                    }
                }
                ,
                CHARACTER((Class)Character.TYPE, (Class)Character.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Character)value).charValue()));
                    }
                }
                ,
                INTEGER((Class)Integer.TYPE, (Class)Integer.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue((Integer)value));
                    }
                }
                ,
                LONG((Class)Long.TYPE, (Class)Long.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(LongConstant.forValue((Long)value));
                    }
                }
                ,
                FLOAT((Class)Float.TYPE, (Class)Float.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(FloatConstant.forValue(((Float)value).floatValue()));
                    }
                }
                ,
                DOUBLE((Class)Double.TYPE, (Class)Double.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(DoubleConstant.forValue((Double)value));
                    }
                };

                private final TypeDescription primitiveType;
                private final TypeDescription wrapperType;

                private ConstantPoolWrapper(Class<?> primitiveType, Class<?> wrapperType) {
                    this.primitiveType = new TypeDescription.ForLoadedType(primitiveType);
                    this.wrapperType = new TypeDescription.ForLoadedType(wrapperType);
                }

                public static ArgumentProvider of(Object value) {
                    if (value instanceof Boolean) {
                        return BOOLEAN.make(value);
                    }
                    if (value instanceof Byte) {
                        return BYTE.make(value);
                    }
                    if (value instanceof Short) {
                        return SHORT.make(value);
                    }
                    if (value instanceof Character) {
                        return CHARACTER.make(value);
                    }
                    if (value instanceof Integer) {
                        return INTEGER.make(value);
                    }
                    if (value instanceof Long) {
                        return LONG.make(value);
                    }
                    if (value instanceof Float) {
                        return FLOAT.make(value);
                    }
                    if (value instanceof Double) {
                        return DOUBLE.make(value);
                    }
                    if (value instanceof String) {
                        return new ForStringConstant((String)value);
                    }
                    if (value instanceof Class) {
                        return new ForClassConstant(new TypeDescription.ForLoadedType((Class)value));
                    }
                    if (value instanceof Enum) {
                        return new ForEnumerationValue(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                        return new ForJavaInstance(JavaInstance.MethodHandle.ofLoaded(value));
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                        return new ForJavaInstance(JavaInstance.MethodType.ofLoaded(value));
                    }
                    return ForStaticField.of(value);
                }

                protected abstract ArgumentProvider make(Object var1);

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ConstantPoolWrapper." + this.name();
                }

                protected class WrappingArgumentProvider
                implements ArgumentProvider {
                    private final StackManipulation stackManipulation;

                    protected WrappingArgumentProvider(StackManipulation stackManipulation) {
                        this.stackManipulation = stackManipulation;
                    }

                    @Override
                    public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                        return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(this.stackManipulation, assigner.assign(ConstantPoolWrapper.this.primitiveType.asGenericType(), ConstantPoolWrapper.this.wrapperType.asGenericType(), typing)), ConstantPoolWrapper.this.wrapperType);
                    }

                    @Override
                    public InstrumentedType prepare(InstrumentedType instrumentedType) {
                        return instrumentedType;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && ConstantPoolWrapper.this.equals((Object)((WrappingArgumentProvider)other).getOuter()) && this.stackManipulation.equals(((WrappingArgumentProvider)other).stackManipulation);
                    }

                    private ConstantPoolWrapper getOuter() {
                        return ConstantPoolWrapper.this;
                    }

                    public int hashCode() {
                        return this.stackManipulation.hashCode() + 31 * ConstantPoolWrapper.this.hashCode();
                    }

                    public String toString() {
                        return "InvokeDynamic.InvocationProvider.ArgumentProvider.ConstantPoolWrapper.WrappingArgumentProvider{constantPoolWrapper=" + (Object)((Object)ConstantPoolWrapper.this) + ", stackManipulation=" + this.stackManipulation + '}';
                    }
                }
            }

            public static enum ForInterceptedMethodParameters implements ArgumentProvider
            {
                INSTANCE;


                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)MethodVariableAccess.allArgumentsOf(instrumentedMethod), instrumentedMethod.getParameters().asTypeList().asErasures());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForInterceptedMethodParameters." + this.name();
                }
            }

            public static enum ForInterceptedMethodInstanceAndParameters implements ArgumentProvider
            {
                INSTANCE;


                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), instrumentedMethod.isStatic() ? instrumentedMethod.getParameters().asTypeList().asErasures() : CompoundList.of(instrumentedMethod.getDeclaringType().asErasure(), instrumentedMethod.getParameters().asTypeList().asErasures()));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.ArgumentProvider.ForInterceptedMethodInstanceAndParameters." + this.name();
                }
            }
        }

        public static interface Target {
            public Resolved resolve(TypeDescription var1, Assigner var2, Assigner.Typing var3);

            public static class ForMethodDescription
            implements Target,
            Resolved {
                private final MethodDescription.InDefinedShape methodDescription;

                protected ForMethodDescription(MethodDescription.InDefinedShape methodDescription) {
                    this.methodDescription = methodDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                    return this;
                }

                @Override
                public String getInternalName() {
                    return this.methodDescription.getInternalName();
                }

                @Override
                public TypeDescription getReturnType() {
                    return this.methodDescription.getReturnType().asErasure();
                }

                @Override
                public StackManipulation getStackManipulation() {
                    return MethodVariableAccess.allArgumentsOf(this.methodDescription).prependThisReference();
                }

                @Override
                public List<TypeDescription> getParameterTypes() {
                    return this.methodDescription.isStatic() ? this.methodDescription.getParameters().asTypeList().asErasures() : CompoundList.of(this.methodDescription.getDeclaringType().asErasure(), this.methodDescription.getParameters().asTypeList().asErasures());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForMethodDescription)other).methodDescription);
                }

                public int hashCode() {
                    return this.methodDescription.hashCode();
                }

                public String toString() {
                    return "InvokeDynamic.InvocationProvider.Target.ForMethodDescription{methodDescription=" + this.methodDescription + '}';
                }
            }

            public static interface Resolved {
                public StackManipulation getStackManipulation();

                public TypeDescription getReturnType();

                public String getInternalName();

                public List<TypeDescription> getParameterTypes();

                public static class Simple
                implements Resolved {
                    private final StackManipulation stackManipulation;
                    private final String internalName;
                    private final TypeDescription returnType;
                    private final List<TypeDescription> parameterTypes;

                    public Simple(StackManipulation stackManipulation, String internalName, TypeDescription returnType, List<TypeDescription> parameterTypes) {
                        this.stackManipulation = stackManipulation;
                        this.internalName = internalName;
                        this.returnType = returnType;
                        this.parameterTypes = parameterTypes;
                    }

                    @Override
                    public StackManipulation getStackManipulation() {
                        return this.stackManipulation;
                    }

                    @Override
                    public TypeDescription getReturnType() {
                        return this.returnType;
                    }

                    @Override
                    public String getInternalName() {
                        return this.internalName;
                    }

                    @Override
                    public List<TypeDescription> getParameterTypes() {
                        return this.parameterTypes;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Simple simple = (Simple)other;
                        return this.internalName.equals(simple.internalName) && this.parameterTypes.equals(simple.parameterTypes) && this.returnType.equals(simple.returnType) && this.stackManipulation.equals(simple.stackManipulation);
                    }

                    public int hashCode() {
                        int result = this.stackManipulation.hashCode();
                        result = 31 * result + this.internalName.hashCode();
                        result = 31 * result + this.returnType.hashCode();
                        result = 31 * result + this.parameterTypes.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "InvokeDynamic.InvocationProvider.Target.Resolved.Simple{stackManipulation=" + this.stackManipulation + ", internalName='" + this.internalName + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
                    }
                }
            }
        }
    }
}

