/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.internal.Assert;
import nl.jqno.equalsverifier.internal.ClassAccessor;
import nl.jqno.equalsverifier.internal.FieldIterable;
import nl.jqno.equalsverifier.internal.Formatter;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

class AbstractDelegationChecker<T>
implements Checker {
    private final Class<T> type;
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final ClassAccessor<T> classAccessor;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public AbstractDelegationChecker(Configuration<T> config) {
        this.type = config.getType();
        this.typeTag = config.getTypeTag();
        this.prefabValues = config.getPrefabValues();
        this.classAccessor = config.createClassAccessor();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkAbstractEqualsAndHashCode();
        this.checkAbstractDelegationInFields();
        Object instance = this.prefabValues.giveRed(this.typeTag);
        Object copy = this.prefabValues.giveBlack(this.typeTag);
        this.checkAbstractDelegation(instance, copy);
        this.checkAbstractDelegationInSuper();
    }

    private void checkAbstractEqualsAndHashCode() {
        boolean equalsIsAbstract = this.classAccessor.isEqualsAbstract();
        boolean hashCodeIsAbstract = this.classAccessor.isHashCodeAbstract();
        if (equalsIsAbstract && hashCodeIsAbstract) {
            Assert.fail(Formatter.of("Abstract delegation: %%'s equals and hashCode methods are both abstract. They should be concrete.", this.type.getSimpleName()));
        } else if (equalsIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, true, true));
        } else if (hashCodeIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, false, true));
        }
    }

    private void checkAbstractDelegationInFields() {
        for (Field field : FieldIterable.of(this.type)) {
            TypeTag tag = TypeTag.of(field, this.typeTag);
            Tuple tuple = this.safelyGetTuple(tag);
            if (tuple == null) continue;
            Object instance = tuple.getRed();
            Object copy = tuple.getBlack();
            this.checkAbstractMethods(tag.getType(), instance, copy, true);
        }
    }

    private <U> Tuple<U> safelyGetTuple(TypeTag tag) {
        try {
            return this.prefabValues.giveTuple(tag);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void checkAbstractDelegation(T instance, T copy) {
        this.checkAbstractMethods(this.type, instance, copy, false);
    }

    private void checkAbstractDelegationInSuper() {
        boolean hashCodeIsAbstract;
        Class<T> superclass = this.type.getSuperclass();
        ClassAccessor<T> superAccessor = this.classAccessor.getSuperAccessor();
        boolean equalsIsAbstract = superAccessor.isEqualsAbstract();
        if (equalsIsAbstract != (hashCodeIsAbstract = superAccessor.isHashCodeAbstract())) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(superclass, equalsIsAbstract, false));
        }
        if (equalsIsAbstract && hashCodeIsAbstract) {
            return;
        }
        Object instance = this.prefabValues.giveRed(new TypeTag(superclass, new TypeTag[0]));
        Object copy = this.prefabValues.giveBlack(this.typeTag);
        this.checkAbstractMethods(superclass, instance, copy, false);
    }

    private Formatter buildSingleAbstractMethodErrorMessage(Class<?> c, boolean isEqualsAbstract, boolean bothShouldBeConcrete) {
        return Formatter.of("Abstract delegation: %%'s %% method is abstract, but %% is not.\n%%", c.getSimpleName(), isEqualsAbstract ? "equals" : "hashCode", isEqualsAbstract ? "hashCode" : "equals", bothShouldBeConcrete ? "Both should be concrete." : "Both should be either abstract or concrete.");
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="These exceptions will re-occur and be handled later.")
    private <S> void checkAbstractMethods(Class<?> instanceClass, S instance, S copy, boolean prefabPossible) {
        try {
            instance.equals(copy);
        }
        catch (AbstractMethodError e) {
            Assert.fail(this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "equals", e.getMessage()), e);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.cachedHashCodeInitializer.getInitializedHashCode(instance);
        }
        catch (AbstractMethodError e) {
            Assert.fail(this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "hashCode", e.getMessage()), e);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    private Formatter buildAbstractDelegationErrorMessage(Class<?> c, boolean prefabPossible, String method, String originalMessage) {
        Formatter prefabFormatter = Formatter.of("\nAdd prefab values for %%.", c.getName());
        return Formatter.of("Abstract delegation: %%'s %% method delegates to an abstract method:\n %%%%", c.getSimpleName(), method, originalMessage, prefabPossible ? prefabFormatter.format() : "");
    }
}

