/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationValueFilter;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.FieldVisitor;

public interface FieldAttributeAppender {
    public void apply(FieldVisitor var1, FieldDescription var2, AnnotationValueFilter var3);

    public static class Compound
    implements FieldAttributeAppender {
        private final List<? extends FieldAttributeAppender> fieldAttributeAppenders;

        public Compound(FieldAttributeAppender ... fieldAttributeAppender) {
            this(Arrays.asList(fieldAttributeAppender));
        }

        public Compound(List<? extends FieldAttributeAppender> fieldAttributeAppenders) {
            this.fieldAttributeAppenders = fieldAttributeAppenders;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            for (FieldAttributeAppender fieldAttributeAppender : this.fieldAttributeAppenders) {
                fieldAttributeAppender.apply(fieldVisitor, fieldDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldAttributeAppenders.equals(((Compound)other).fieldAttributeAppenders);
        }

        public int hashCode() {
            return this.fieldAttributeAppenders.hashCode();
        }

        public String toString() {
            return "FieldAttributeAppender.Compound{fieldAttributeAppenders=" + this.fieldAttributeAppenders + '}';
        }
    }

    public static class Explicit
    implements FieldAttributeAppender,
    Factory {
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((Explicit)other).annotations);
        }

        public int hashCode() {
            return this.annotations.hashCode();
        }

        public String toString() {
            return "FieldAttributeAppender.Explicit{annotations=" + this.annotations + '}';
        }
    }

    public static enum ForInstrumentedField implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            annotationAppender = fieldDescription.getType().accept(AnnotationAppender.ForTypeAnnotations.ofFieldType(annotationAppender, annotationValueFilter));
            for (AnnotationDescription annotation : fieldDescription.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public String toString() {
            return "FieldAttributeAppender.ForInstrumentedField." + this.name();
        }
    }

    public static interface Factory {
        public FieldAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final List<? extends Factory> factories;

            public Compound(Factory ... factory) {
                this(Arrays.asList(factory));
            }

            public Compound(List<? extends Factory> factories) {
                this.factories = factories;
            }

            @Override
            public FieldAttributeAppender make(TypeDescription typeDescription) {
                ArrayList<FieldAttributeAppender> fieldAttributeAppenders = new ArrayList<FieldAttributeAppender>(this.factories.size());
                for (Factory factory : this.factories) {
                    fieldAttributeAppenders.add(factory.make(typeDescription));
                }
                return new nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.FieldAttributeAppender$Compound(fieldAttributeAppenders);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.factories.equals(((Compound)other).factories);
            }

            public int hashCode() {
                return this.factories.hashCode();
            }

            public String toString() {
                return "FieldAttributeAppender.Factory.Compound{factories=" + this.factories + '}';
            }
        }
    }

    public static enum NoOp implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
        }

        public String toString() {
            return "FieldAttributeAppender.NoOp." + this.name();
        }
    }
}

