/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class DescendantTokenCheck
extends AbstractCheck {
    public static final String MSG_KEY_MIN = "descendant.token.min";
    public static final String MSG_KEY_MAX = "descendant.token.max";
    public static final String MSG_KEY_SUM_MIN = "descendant.token.sum.min";
    public static final String MSG_KEY_SUM_MAX = "descendant.token.sum.max";
    private int minimumDepth;
    private int maximumDepth = Integer.MAX_VALUE;
    private int minimumNumber;
    private int maximumNumber = Integer.MAX_VALUE;
    private boolean sumTokenCounts;
    private int[] limitedTokens = ArrayUtils.EMPTY_INT_ARRAY;
    private String minimumMessage;
    private String maximumMessage;
    private int[] counts = ArrayUtils.EMPTY_INT_ARRAY;

    @Override
    public int[] getDefaultTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        Arrays.fill(this.counts, 0);
        this.countTokens(ast, 0);
        if (this.sumTokenCounts) {
            this.logAsTotal(ast);
        } else {
            this.logAsSeparated(ast);
        }
    }

    private void logAsSeparated(DetailAST ast) {
        String name = TokenUtils.getTokenName(ast.getType());
        for (int element : this.limitedTokens) {
            String descendantName;
            int tokenCount = this.counts[element - 1];
            if (tokenCount < this.minimumNumber) {
                descendantName = TokenUtils.getTokenName(element);
                if (this.minimumMessage == null) {
                    this.minimumMessage = MSG_KEY_MIN;
                }
                this.log(ast.getLineNo(), ast.getColumnNo(), this.minimumMessage, String.valueOf(tokenCount), String.valueOf(this.minimumNumber), name, descendantName);
            }
            if (tokenCount <= this.maximumNumber) continue;
            descendantName = TokenUtils.getTokenName(element);
            if (this.maximumMessage == null) {
                this.maximumMessage = MSG_KEY_MAX;
            }
            this.log(ast.getLineNo(), ast.getColumnNo(), this.maximumMessage, String.valueOf(tokenCount), String.valueOf(this.maximumNumber), name, descendantName);
        }
    }

    private void logAsTotal(DetailAST ast) {
        String name = TokenUtils.getTokenName(ast.getType());
        int total = 0;
        for (int element : this.limitedTokens) {
            total += this.counts[element - 1];
        }
        if (total < this.minimumNumber) {
            if (this.minimumMessage == null) {
                this.minimumMessage = MSG_KEY_SUM_MIN;
            }
            this.log(ast.getLineNo(), ast.getColumnNo(), this.minimumMessage, String.valueOf(total), String.valueOf(this.minimumNumber), name);
        }
        if (total > this.maximumNumber) {
            if (this.maximumMessage == null) {
                this.maximumMessage = MSG_KEY_SUM_MAX;
            }
            this.log(ast.getLineNo(), ast.getColumnNo(), this.maximumMessage, String.valueOf(total), String.valueOf(this.maximumNumber), name);
        }
    }

    private void countTokens(AST ast, int depth) {
        if (depth <= this.maximumDepth) {
            int type;
            if (depth >= this.minimumDepth && (type = ast.getType()) <= this.counts.length) {
                int n = type - 1;
                this.counts[n] = this.counts[n] + 1;
            }
            int nextDepth = depth + 1;
            for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.countTokens(child, nextDepth);
            }
        }
    }

    @Override
    public int[] getAcceptableTokens() {
        Set<String> tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int index = 0;
        for (String name : tokenNames) {
            result[index] = TokenUtils.getTokenId(name);
            ++index;
        }
        return result;
    }

    public void setLimitedTokens(String ... limitedTokensParam) {
        this.limitedTokens = new int[limitedTokensParam.length];
        int maxToken = 0;
        for (int i = 0; i < limitedTokensParam.length; ++i) {
            this.limitedTokens[i] = TokenUtils.getTokenId(limitedTokensParam[i]);
            if (this.limitedTokens[i] <= maxToken) continue;
            maxToken = this.limitedTokens[i];
        }
        this.counts = new int[maxToken];
    }

    public void setMinimumDepth(int minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public void setMaximumDepth(int maximumDepth) {
        this.maximumDepth = maximumDepth;
    }

    public void setMinimumNumber(int minimumNumber) {
        this.minimumNumber = minimumNumber;
    }

    public void setMaximumNumber(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    public void setMinimumMessage(String message) {
        this.minimumMessage = message;
    }

    public void setMaximumMessage(String message) {
        this.maximumMessage = message;
    }

    public void setSumTokenCounts(boolean sum) {
        this.sumTokenCounts = sum;
    }
}

