/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.MethodConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public abstract class InvocationHandlerAdapter
implements Implementation {
    private static final boolean NO_CACHING = false;
    protected static final boolean CACHING = true;
    private static final String PREFIX = "invocationHandler";
    private static final TypeDescription.Generic INVOCATION_HANDLER_TYPE = new TypeDescription.Generic.OfNonGenericType.ForLoadedType(InvocationHandler.class);
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods, Assigner assigner) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = assigner;
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%d", PREFIX, Math.abs(invocationHandler.hashCode() % Integer.MAX_VALUE)));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForStaticDelegation(fieldName, false, Assigner.DEFAULT, invocationHandler);
    }

    public static InvocationHandlerAdapter toInstanceField(String fieldName) {
        return new ForInstanceDelegation(fieldName, false, Assigner.DEFAULT);
    }

    private List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList.Generic parameterTypes = instrumentedMethod.getParameters().asTypeList();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        int currentIndex = 1;
        for (TypeDescription.Generic parameterType : parameterTypes) {
            instruction.add(new StackManipulation.Compound(MethodVariableAccess.of(parameterType).loadOffset(currentIndex), this.assigner.assign(parameterType, TypeDescription.Generic.OBJECT, Assigner.Typing.STATIC)));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract AssignerConfigurable withMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription instrumentedType, StackManipulation preparingManipulation) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter(), MethodVariableAccess.REFERENCE.loadOffset(0), this.cacheMethods ? MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()).cached() : MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()), ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(this.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke((MethodDescription)INVOCATION_HANDLER_TYPE.getDeclaredMethods().getOnly()), this.assigner.assign(TypeDescription.Generic.OBJECT, instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.returning(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvocationHandlerAdapter that = (InvocationHandlerAdapter)other;
        return this.cacheMethods == that.cacheMethods && this.assigner.equals(that.assigner) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + (this.cacheMethods ? 1 : 0);
        return result;
    }

    protected static class ForInstanceDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected ForInstanceDelegation(String fieldName, boolean cacheMethods, Assigner assigner) {
            super(fieldName, cacheMethods, assigner);
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForInstanceDelegation(this.fieldName, true, this.assigner);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForInstanceDelegation(this.fieldName, this.cacheMethods, assigner);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4097, INVOCATION_HANDLER_TYPE));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForInstanceDelegation{fieldName=" + this.fieldName + "cacheMethods=" + this.cacheMethods + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForInstanceDelegation.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.instrumentedType, MethodVariableAccess.of(this.instrumentedType).loadOffset(0));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstanceDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstanceDelegation.this;
            }

            public int hashCode() {
                return 31 * ForInstanceDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForInstanceDelegation.Appender{invocationHandlerAdapter=" + ForInstanceDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static class ForStaticDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected final InvocationHandler invocationHandler;

        protected ForStaticDelegation(String fieldName, boolean cacheMethods, Assigner assigner, InvocationHandler invocationHandler) {
            super(fieldName, cacheMethods, assigner);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForStaticDelegation(this.fieldName, true, this.assigner, this.invocationHandler);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForStaticDelegation(this.fieldName, this.cacheMethods, assigner, this.invocationHandler);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, INVOCATION_HANDLER_TYPE)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.invocationHandler.equals(((ForStaticDelegation)other).invocationHandler);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.invocationHandler.hashCode();
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForStaticDelegation{fieldName=" + this.fieldName + ", cacheMethods=" + this.cacheMethods + ", invocationHandler=" + this.invocationHandler + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForStaticDelegation.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.instrumentedType, StackManipulation.Trivial.INSTANCE);
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForStaticDelegation.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForStaticDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForStaticDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForStaticDelegation.Appender{invocationHandlerAdapter=" + ForStaticDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1);
    }
}

