/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.MethodTransformer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodGraph;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeValidation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeWriter;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.MethodAttributeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.LatentMatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.CompoundList;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, MethodTransformer var4);

    public MethodRegistry append(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, MethodTransformer var4);

    public Prepared prepare(InstrumentedType var1, MethodGraph.Compiler var2, TypeValidation var3, LatentMatcher<? super MethodDescription> var4);

    public static class Default
    implements MethodRegistry {
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry prepend(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodTransformer methodTransformer) {
            return new Default(CompoundList.of(new Entry(matcher, handler, attributeAppenderFactory, methodTransformer), this.entries));
        }

        @Override
        public MethodRegistry append(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodTransformer methodTransformer) {
            return new Default(CompoundList.of(this.entries, new Entry(matcher, handler, attributeAppenderFactory, methodTransformer)));
        }

        @Override
        public nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared prepare(InstrumentedType instrumentedType, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods) {
            LinkedHashMap<MethodDescription, Prepared.Entry> implementations = new LinkedHashMap<MethodDescription, Prepared.Entry>();
            HashSet<Handler> handlers = new HashSet<Handler>();
            MethodList<MethodDescription.InDefinedShape> helperMethods = instrumentedType.getDeclaredMethods();
            for (Entry entry : this.entries) {
                if (!handlers.add(entry.getHandler())) continue;
                instrumentedType = entry.getHandler().prepare(instrumentedType);
                ElementMatcher.Junction handledMethods = ElementMatchers.noneOf(helperMethods);
                helperMethods = instrumentedType.getDeclaredMethods();
                for (MethodDescription helperMethod : (MethodList)helperMethods.filter(handledMethods)) {
                    implementations.put(helperMethod, entry.asSupplementaryEntry(helperMethod));
                }
            }
            MethodGraph.Linked methodGraph = methodGraphCompiler.compile(instrumentedType);
            ElementMatcher.Junction<? super MethodDescription> relevanceMatcher = ElementMatchers.not(ElementMatchers.anyOf(implementations.keySet())).and(ElementMatchers.returns(ElementMatchers.isVisibleTo(instrumentedType))).and(ElementMatchers.hasParameters(ElementMatchers.whereNone(ElementMatchers.hasType(ElementMatchers.not(ElementMatchers.isVisibleTo(instrumentedType)))))).and(ignoredMethods.resolve(instrumentedType));
            for (MethodGraph.Node node : methodGraph.listNodes()) {
                boolean visibilityBridge;
                MethodDescription methodDescription = node.getRepresentative();
                boolean bl = visibilityBridge = instrumentedType.isPublic() && !instrumentedType.isInterface();
                if (relevanceMatcher.matches(methodDescription)) {
                    for (Entry entry : this.entries) {
                        if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                        implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription, node.getMethodTypes()));
                        visibilityBridge = false;
                        break;
                    }
                }
                if (!visibilityBridge || !methodDescription.isPublic() || methodDescription.isAbstract() || methodDescription.isFinal() || node.getSort().isMadeVisible() || !methodDescription.getDeclaringType().asErasure().isPackagePrivate()) continue;
                implementations.put(methodDescription, Prepared.Entry.forVisibilityBridge(methodDescription));
            }
            block4: for (MethodDescription methodDescription : CompoundList.of(instrumentedType.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isVirtual()).and(relevanceMatcher)), new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
                for (Entry entry : this.entries) {
                    if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                    implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription));
                    continue block4;
                }
            }
            return new Prepared(implementations, instrumentedType.getLoadedTypeInitializer(), instrumentedType.getTypeInitializer(), typeValidation.isEnabled() ? instrumentedType.validated() : instrumentedType, methodGraph);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "MethodRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final LinkedHashMap<MethodDescription, Entry> implementations;

            protected Compiled(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, LinkedHashMap<MethodDescription, Entry> implementations) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.implementations = implementations;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public TypeWriter.MethodPool.Record target(MethodDescription methodDescription) {
                Entry entry = this.implementations.get(methodDescription);
                return entry == null ? TypeWriter.MethodPool.Record.ForNonDefinedMethod.INSTANCE : entry.bind(this.instrumentedType);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compiled compiled = (Compiled)other;
                return this.instrumentedType.equals(compiled.instrumentedType) && this.loadedTypeInitializer.equals(compiled.loadedTypeInitializer) && this.typeInitializer.equals(compiled.typeInitializer) && this.implementations.equals(compiled.implementations);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.implementations.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Compiled{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", implementations=" + this.implementations + '}';
            }

            protected static class Entry {
                private final Handler.Compiled handler;
                private final MethodAttributeAppender attributeAppender;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> bridgeTypes;

                protected Entry(Handler.Compiled handler, MethodAttributeAppender attributeAppender, MethodDescription methodDescription, Set<MethodDescription.TypeToken> bridgeTypes) {
                    this.handler = handler;
                    this.attributeAppender = attributeAppender;
                    this.methodDescription = methodDescription;
                    this.bridgeTypes = bridgeTypes;
                }

                protected TypeWriter.MethodPool.Record bind(TypeDescription instrumentedType) {
                    return TypeWriter.MethodPool.Record.AccessBridgeWrapper.of(this.handler.assemble(this.methodDescription, this.attributeAppender), instrumentedType, this.methodDescription, this.bridgeTypes, this.attributeAppender);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.handler.equals(entry.handler) && this.attributeAppender.equals(entry.attributeAppender) && this.methodDescription.equals(entry.methodDescription) && this.bridgeTypes.equals(entry.bridgeTypes);
                }

                public int hashCode() {
                    int result = this.handler.hashCode();
                    result = 31 * result + this.attributeAppender.hashCode();
                    result = 31 * result + this.methodDescription.hashCode();
                    result = 31 * result + this.bridgeTypes.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodRegistry.Default.Compiled.Entry{handler=" + this.handler + ", attributeAppender=" + this.attributeAppender + ", methodDescription=" + this.methodDescription + ", bridgeTypes=" + this.bridgeTypes + '}';
                }
            }
        }

        protected static class Prepared
        implements nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared {
            private final LinkedHashMap<MethodDescription, Entry> implementations;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final TypeDescription instrumentedType;
            private final MethodGraph.Linked methodGraph;

            protected Prepared(LinkedHashMap<MethodDescription, Entry> implementations, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeDescription instrumentedType, MethodGraph.Linked methodGraph) {
                this.implementations = implementations;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.instrumentedType = instrumentedType;
                this.methodGraph = methodGraph;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(Implementation.Target.Factory implementationTargetFactory) {
                HashMap<Handler, Handler.Compiled> compilationCache = new HashMap<Handler, Handler.Compiled>();
                HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender> attributeAppenderCache = new HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender>();
                LinkedHashMap<MethodDescription, Compiled.Entry> entries = new LinkedHashMap<MethodDescription, Compiled.Entry>();
                Implementation.Target implementationTarget = implementationTargetFactory.make(this.instrumentedType, this.methodGraph);
                for (Map.Entry<MethodDescription, Entry> entry : this.implementations.entrySet()) {
                    MethodAttributeAppender cachedAttributeAppender;
                    Handler.Compiled cachedHandler = (Handler.Compiled)compilationCache.get(entry.getValue().getHandler());
                    if (cachedHandler == null) {
                        cachedHandler = entry.getValue().getHandler().compile(implementationTarget);
                        compilationCache.put(entry.getValue().getHandler(), cachedHandler);
                    }
                    if ((cachedAttributeAppender = (MethodAttributeAppender)attributeAppenderCache.get(entry.getValue().getAppenderFactory())) == null) {
                        cachedAttributeAppender = entry.getValue().getAppenderFactory().make(this.instrumentedType);
                        attributeAppenderCache.put(entry.getValue().getAppenderFactory(), cachedAttributeAppender);
                    }
                    entries.put(entry.getKey(), new Compiled.Entry(cachedHandler, cachedAttributeAppender, entry.getValue().getMethodDescription(), entry.getValue().resolveBridgeTypes()));
                }
                return new Compiled(this.instrumentedType, this.loadedTypeInitializer, this.typeInitializer, entries);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Prepared prepared = (Prepared)other;
                return this.implementations.equals(prepared.implementations) && this.loadedTypeInitializer.equals(prepared.loadedTypeInitializer) && this.typeInitializer.equals(prepared.typeInitializer) && this.instrumentedType.equals(prepared.instrumentedType) && this.methodGraph.equals(prepared.methodGraph);
            }

            public int hashCode() {
                int result = this.implementations.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.instrumentedType.hashCode();
                result = 31 * result + this.methodGraph.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Prepared{implementations=" + this.implementations + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", instrumentedType=" + this.instrumentedType + ", methodGraph=" + this.methodGraph + '}';
            }

            protected static class Entry {
                private final Handler handler;
                private final MethodAttributeAppender.Factory attributeAppenderFactory;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> typeTokens;

                protected Entry(Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodDescription methodDescription, Set<MethodDescription.TypeToken> typeTokens) {
                    this.handler = handler;
                    this.attributeAppenderFactory = attributeAppenderFactory;
                    this.methodDescription = methodDescription;
                    this.typeTokens = typeTokens;
                }

                protected static Entry forVisibilityBridge(MethodDescription bridgeTarget) {
                    return new Entry(Handler.ForVisibilityBridge.INSTANCE, MethodAttributeAppender.Explicit.of(bridgeTarget), bridgeTarget, Collections.<MethodDescription.TypeToken>emptySet());
                }

                protected Handler getHandler() {
                    return this.handler;
                }

                protected MethodAttributeAppender.Factory getAppenderFactory() {
                    return this.attributeAppenderFactory;
                }

                protected MethodDescription getMethodDescription() {
                    return this.methodDescription;
                }

                protected Set<MethodDescription.TypeToken> resolveBridgeTypes() {
                    HashSet<MethodDescription.TypeToken> typeTokens = new HashSet<MethodDescription.TypeToken>(this.typeTokens);
                    typeTokens.remove(this.methodDescription.asTypeToken());
                    return typeTokens;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.handler.equals(entry.handler) && this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.methodDescription.equals(entry.methodDescription) && this.typeTokens.equals(entry.typeTokens);
                }

                public int hashCode() {
                    int result = this.handler.hashCode();
                    result = 31 * result + this.attributeAppenderFactory.hashCode();
                    result = 31 * result + this.methodDescription.hashCode();
                    result = 31 * result + this.typeTokens.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodRegistry.Default.Prepared.Entry{handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + ", methodDescription=" + this.methodDescription + ", typeTokens=" + this.typeTokens + '}';
                }
            }
        }

        protected static class Entry
        implements LatentMatcher<MethodDescription> {
            private final LatentMatcher<? super MethodDescription> matcher;
            private final Handler handler;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;
            private final MethodTransformer methodTransformer;

            protected Entry(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodTransformer methodTransformer) {
                this.matcher = matcher;
                this.handler = handler;
                this.attributeAppenderFactory = attributeAppenderFactory;
                this.methodTransformer = methodTransformer;
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription) {
                return this.asPreparedEntry(instrumentedType, methodDescription, Collections.<MethodDescription.TypeToken>emptySet());
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription, Set<MethodDescription.TypeToken> methodTypes) {
                return new Prepared.Entry(this.handler, this.attributeAppenderFactory, this.methodTransformer.transform(instrumentedType, methodDescription), methodTypes);
            }

            protected Prepared.Entry asSupplementaryEntry(MethodDescription methodDescription) {
                return new Prepared.Entry(this.handler, MethodAttributeAppender.Explicit.of(methodDescription), methodDescription, Collections.<MethodDescription.TypeToken>emptySet());
            }

            protected Handler getHandler() {
                return this.handler;
            }

            @Override
            public ElementMatcher<? super MethodDescription> resolve(TypeDescription instrumentedType) {
                return this.matcher.resolve(instrumentedType);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.handler.equals(entry.handler) && this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.methodTransformer.equals(entry.methodTransformer);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.handler.hashCode();
                result = 31 * result + this.attributeAppenderFactory.hashCode();
                result = 31 * result + this.methodTransformer.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Entry{matcher=" + this.matcher + ", handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + ", methodTransformer=" + this.methodTransformer + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public TypeDescription getInstrumentedType();

        public MethodList getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();
    }

    public static interface Prepared {
        public TypeDescription getInstrumentedType();

        public MethodList<?> getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();

        public Compiled compile(Implementation.Target.Factory var1);
    }

    public static interface Handler
    extends InstrumentedType.Prepareable {
        public Compiled compile(Implementation.Target var1);

        public static class ForAnnotationValue
        implements Handler,
        Compiled {
            private final Object annotationValue;

            protected ForAnnotationValue(Object annotationValue) {
                this.annotationValue = annotationValue;
            }

            public static Handler of(Object annotationValue) {
                TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(annotationValue.getClass());
                if (!typeDescription.isAnnotationValue() && !typeDescription.isPrimitiveWrapper()) {
                    throw new IllegalArgumentException("Does not describe an annotation value: " + annotationValue);
                }
                return new ForAnnotationValue(annotationValue);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithAnnotationDefaultValue(methodDescription, this.annotationValue, attributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.annotationValue.equals(((ForAnnotationValue)other).annotationValue);
            }

            public int hashCode() {
                return this.annotationValue.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAnnotationValue{annotationValue=" + this.annotationValue + '}';
            }
        }

        public static class ForImplementation
        implements Handler {
            private final Implementation implementation;

            public ForImplementation(Implementation implementation) {
                this.implementation = implementation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return this.implementation.prepare(instrumentedType);
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(this.implementation.appender(implementationTarget));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.implementation.equals(((ForImplementation)other).implementation);
            }

            public int hashCode() {
                return this.implementation.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForImplementation{implementation=" + this.implementation + '}';
            }

            protected static class Compiled
            implements nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final ByteCodeAppender byteCodeAppender;

                protected Compiled(ByteCodeAppender byteCodeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                    return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithBody(methodDescription, this.byteCodeAppender, attributeAppender);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Compiled)other).byteCodeAppender);
                }

                public int hashCode() {
                    return this.byteCodeAppender.hashCode();
                }

                public String toString() {
                    return "MethodRegistry.Handler.ForImplementation.Compiled{byteCodeAppender=" + this.byteCodeAppender + '}';
                }
            }
        }

        public static interface Compiled {
            public TypeWriter.MethodPool.Record assemble(MethodDescription var1, MethodAttributeAppender var2);
        }

        public static enum ForVisibilityBridge implements Handler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                throw new IllegalStateException("A visibility bridge handler must not apply any preparations");
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(implementationTarget.getInstrumentedType());
            }

            public String toString() {
                return "MethodRegistry.Handler.ForVisibilityBridge." + this.name();
            }

            protected static class Compiled
            implements nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final TypeDescription instrumentedType;

                protected Compiled(TypeDescription instrumentedType) {
                    this.instrumentedType = instrumentedType;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                    return TypeWriter.MethodPool.Record.ForDefinedMethod.OfVisibilityBridge.of(this.instrumentedType, methodDescription, attributeAppender);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Compiled)other).instrumentedType);
                }

                public int hashCode() {
                    return this.instrumentedType.hashCode();
                }

                public String toString() {
                    return "MethodRegistry.Handler.ForVisibilityBridge.Compiled{instrumentedType=" + this.instrumentedType + '}';
                }
            }
        }

        public static enum ForAbstractMethod implements Handler,
        Compiled
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithoutBody(methodDescription, attributeAppender);
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAbstractMethod." + this.name();
            }
        }
    }
}

