/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class AvoidStarImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.avoidStar";
    private static final String STAR_IMPORT_SUFFIX = ".*";
    private final List<String> excludes = Lists.newArrayList();
    private boolean allowClassImports;
    private boolean allowStaticMemberImports;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 151};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 151};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 151};
    }

    public void setExcludes(String ... excludesParam) {
        this.excludes.clear();
        for (String exclude : excludesParam) {
            if (exclude.endsWith(STAR_IMPORT_SUFFIX)) {
                this.excludes.add(exclude);
                continue;
            }
            this.excludes.add(exclude + STAR_IMPORT_SUFFIX);
        }
    }

    public void setAllowClassImports(boolean allow) {
        this.allowClassImports = allow;
    }

    public void setAllowStaticMemberImports(boolean allow) {
        this.allowStaticMemberImports = allow;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!this.allowClassImports && ast.getType() == 30) {
            DetailAST startingDot = ast.getFirstChild();
            this.logsStarredImportViolation(startingDot);
        } else if (!this.allowStaticMemberImports && ast.getType() == 151) {
            DetailAST startingDot = ast.getFirstChild().getNextSibling();
            this.logsStarredImportViolation(startingDot);
        }
    }

    private void logsStarredImportViolation(DetailAST startingDot) {
        FullIdent name = FullIdent.createFullIdent(startingDot);
        String importText = name.getText();
        if (importText.endsWith(STAR_IMPORT_SUFFIX) && !this.excludes.contains(importText)) {
            this.log(startingDot.getLineNo(), MSG_KEY, importText);
        }
    }
}

