/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import antlr.collections.AST;
import com.google.common.collect.ImmutableList;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class VisibilityModifierCheck
extends AbstractCheck {
    public static final String MSG_KEY = "variable.notPrivate";
    private static final List<String> DEFAULT_IMMUTABLE_TYPES = ImmutableList.of("java.lang.String", "java.lang.Integer", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Boolean", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.StackTraceElement", "java.math.BigInteger", "java.math.BigDecimal", new String[]{"java.io.File", "java.util.Locale", "java.util.UUID", "java.net.URL", "java.net.URI", "java.net.Inet4Address", "java.net.Inet6Address", "java.net.InetSocketAddress"});
    private static final List<String> DEFAULT_IGNORE_ANNOTATIONS = ImmutableList.of("org.junit.Rule", "com.google.common.annotations.VisibleForTesting");
    private static final String PUBLIC_ACCESS_MODIFIER = "public";
    private static final String PRIVATE_ACCESS_MODIFIER = "private";
    private static final String PROTECTED_ACCESS_MODIFIER = "protected";
    private static final String PACKAGE_ACCESS_MODIFIER = "package";
    private static final String STATIC_KEYWORD = "static";
    private static final String FINAL_KEYWORD = "final";
    private static final String[] EXPLICIT_MODS = new String[]{"public", "private", "protected"};
    private String publicMemberFormat = "^serialVersionUID$";
    private Pattern publicMemberPattern = Pattern.compile(this.publicMemberFormat);
    private final List<String> ignoreAnnotationShortNames = VisibilityModifierCheck.getClassShortNames(DEFAULT_IGNORE_ANNOTATIONS);
    private final List<String> immutableClassShortNames = VisibilityModifierCheck.getClassShortNames(DEFAULT_IMMUTABLE_TYPES);
    private List<String> ignoreAnnotationCanonicalNames = new ArrayList<String>(DEFAULT_IGNORE_ANNOTATIONS);
    private boolean protectedAllowed;
    private boolean packageAllowed;
    private boolean allowPublicImmutableFields = true;
    private List<String> immutableClassCanonicalNames = new ArrayList<String>(DEFAULT_IMMUTABLE_TYPES);

    public void setIgnoreAnnotationCanonicalNames(String ... annotationNames) {
        this.ignoreAnnotationCanonicalNames = Arrays.asList(annotationNames);
    }

    public void setProtectedAllowed(boolean protectedAllowed) {
        this.protectedAllowed = protectedAllowed;
    }

    public void setPackageAllowed(boolean packageAllowed) {
        this.packageAllowed = packageAllowed;
    }

    public void setPublicMemberPattern(String pattern) {
        this.publicMemberPattern = CommonUtils.createPattern(pattern);
        this.publicMemberFormat = pattern;
    }

    public void setAllowPublicImmutableFields(boolean allow) {
        this.allowPublicImmutableFields = allow;
    }

    public void setImmutableClassCanonicalNames(String ... classNames) {
        this.immutableClassCanonicalNames = Arrays.asList(classNames);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 30};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAst) {
        this.immutableClassShortNames.clear();
        List<String> classShortNames = VisibilityModifierCheck.getClassShortNames(this.immutableClassCanonicalNames);
        this.immutableClassShortNames.addAll(classShortNames);
        this.ignoreAnnotationShortNames.clear();
        List<String> annotationShortNames = VisibilityModifierCheck.getClassShortNames(this.ignoreAnnotationCanonicalNames);
        this.ignoreAnnotationShortNames.addAll(annotationShortNames);
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 10: {
                if (VisibilityModifierCheck.isAnonymousClassVariable(ast)) break;
                this.visitVariableDef(ast);
                break;
            }
            case 30: {
                this.visitImport(ast);
                break;
            }
            default: {
                String exceptionMsg = "Unexpected token type: " + ast.getText();
                throw new IllegalArgumentException(exceptionMsg);
            }
        }
    }

    private static boolean isAnonymousClassVariable(DetailAST variableDef) {
        return variableDef.getParent().getType() != 6;
    }

    private void visitVariableDef(DetailAST variableDef) {
        DetailAST varNameAST;
        String varName;
        boolean inInterfaceOrAnnotationBlock = ScopeUtils.isInInterfaceOrAnnotationBlock(variableDef);
        if (!(inInterfaceOrAnnotationBlock || this.hasIgnoreAnnotation(variableDef) || this.hasProperAccessModifier(variableDef, varName = (varNameAST = variableDef.findFirstToken(13).getNextSibling()).getText()))) {
            this.log(varNameAST.getLineNo(), varNameAST.getColumnNo(), MSG_KEY, varName);
        }
    }

    private boolean hasIgnoreAnnotation(DetailAST variableDef) {
        DetailAST firstIgnoreAnnotation = this.findMatchingAnnotation(variableDef);
        return firstIgnoreAnnotation != null;
    }

    private void visitImport(DetailAST importAst) {
        if (!VisibilityModifierCheck.isStarImport(importAst)) {
            DetailAST type = importAst.getFirstChild();
            String canonicalName = VisibilityModifierCheck.getCanonicalName(type);
            String shortName = VisibilityModifierCheck.getClassShortName(canonicalName);
            if (!this.immutableClassCanonicalNames.contains(canonicalName) && this.immutableClassShortNames.contains(shortName)) {
                this.immutableClassShortNames.remove(shortName);
            }
            if (!this.ignoreAnnotationCanonicalNames.contains(canonicalName) && this.ignoreAnnotationShortNames.contains(shortName)) {
                this.ignoreAnnotationShortNames.remove(shortName);
            }
        }
    }

    private static boolean isStarImport(DetailAST importAst) {
        boolean result = false;
        DetailAST toVisit = importAst;
        while (toVisit != null) {
            if ((toVisit = VisibilityModifierCheck.getNextSubTreeNode(toVisit, importAst)) == null || toVisit.getType() != 60) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasProperAccessModifier(DetailAST variableDef, String variableName) {
        boolean result = true;
        String variableScope = VisibilityModifierCheck.getVisibilityScope(variableDef);
        if (!PRIVATE_ACCESS_MODIFIER.equals(variableScope)) {
            result = VisibilityModifierCheck.isStaticFinalVariable(variableDef) || this.packageAllowed && PACKAGE_ACCESS_MODIFIER.equals(variableScope) || this.protectedAllowed && PROTECTED_ACCESS_MODIFIER.equals(variableScope) || this.isIgnoredPublicMember(variableName, variableScope) || this.allowPublicImmutableFields && this.isImmutableFieldDefinedInFinalClass(variableDef);
        }
        return result;
    }

    private static boolean isStaticFinalVariable(DetailAST variableDef) {
        Set<String> modifiers = VisibilityModifierCheck.getModifiers(variableDef);
        return modifiers.contains(STATIC_KEYWORD) && modifiers.contains(FINAL_KEYWORD);
    }

    private boolean isIgnoredPublicMember(String variableName, String variableScope) {
        return PUBLIC_ACCESS_MODIFIER.equals(variableScope) && this.publicMemberPattern.matcher(variableName).find();
    }

    private boolean isImmutableFieldDefinedInFinalClass(DetailAST variableDef) {
        DetailAST classDef = variableDef.getParent().getParent();
        Set<String> classModifiers = VisibilityModifierCheck.getModifiers(classDef);
        return (classModifiers.contains(FINAL_KEYWORD) || classDef.getType() == 153) && this.isImmutableField(variableDef);
    }

    private static Set<String> getModifiers(DetailAST defAST) {
        DetailAST modifiersAST = defAST.findFirstToken(5);
        HashSet<String> modifiersSet = new HashSet<String>();
        if (modifiersAST != null) {
            for (AST modifier = modifiersAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
                modifiersSet.add(modifier.getText());
            }
        }
        return modifiersSet;
    }

    private static String getVisibilityScope(DetailAST variableDef) {
        Set<String> modifiers = VisibilityModifierCheck.getModifiers(variableDef);
        String accessModifier = PACKAGE_ACCESS_MODIFIER;
        for (String modifier : EXPLICIT_MODS) {
            if (!modifiers.contains(modifier)) continue;
            accessModifier = modifier;
            break;
        }
        return accessModifier;
    }

    private boolean isImmutableField(DetailAST variableDef) {
        boolean result = false;
        DetailAST modifiers = variableDef.findFirstToken(5);
        boolean isFinal = modifiers.branchContains(39);
        if (isFinal) {
            DetailAST type = variableDef.findFirstToken(13);
            boolean isCanonicalName = type.getFirstChild().getType() == 59;
            String typeName = VisibilityModifierCheck.getTypeName(type, isCanonicalName);
            result = !isCanonicalName && VisibilityModifierCheck.isPrimitive(type) || this.immutableClassShortNames.contains(typeName) || isCanonicalName && this.immutableClassCanonicalNames.contains(typeName);
        }
        return result;
    }

    private static String getTypeName(DetailAST type, boolean isCanonicalName) {
        String typeName = isCanonicalName ? VisibilityModifierCheck.getCanonicalName(type) : type.getFirstChild().getText();
        return typeName;
    }

    private static boolean isPrimitive(DetailAST type) {
        return type.getFirstChild().getType() != 58;
    }

    private static String getCanonicalName(DetailAST type) {
        StringBuilder canonicalNameBuilder = new StringBuilder();
        DetailAST toVisit = type.getFirstChild();
        while (toVisit != null) {
            if ((toVisit = VisibilityModifierCheck.getNextSubTreeNode(toVisit, type)) == null || toVisit.getType() != 58) continue;
            canonicalNameBuilder.append(toVisit.getText());
            DetailAST nextSubTreeNode = VisibilityModifierCheck.getNextSubTreeNode(toVisit, type);
            if (nextSubTreeNode == null) continue;
            canonicalNameBuilder.append('.');
        }
        return canonicalNameBuilder.toString();
    }

    private static DetailAST getNextSubTreeNode(DetailAST currentNodeAst, DetailAST subTreeRootAst) {
        DetailAST currentNode = currentNodeAst;
        DetailAST toVisitAst = currentNode.getFirstChild();
        while (toVisitAst == null) {
            toVisitAst = currentNode.getNextSibling();
            if (toVisitAst != null) continue;
            if (currentNode.getParent().equals(subTreeRootAst) && currentNode.getParent().getColumnNo() == subTreeRootAst.getColumnNo()) break;
            currentNode = currentNode.getParent();
        }
        return toVisitAst;
    }

    private static List<String> getClassShortNames(List<String> canonicalClassNames) {
        ArrayList<String> shortNames = new ArrayList<String>();
        for (String canonicalClassName : canonicalClassNames) {
            String shortClassName = canonicalClassName.substring(canonicalClassName.lastIndexOf(46) + 1, canonicalClassName.length());
            shortNames.add(shortClassName);
        }
        return shortNames;
    }

    private static String getClassShortName(String canonicalClassName) {
        return canonicalClassName.substring(canonicalClassName.lastIndexOf(46) + 1, canonicalClassName.length());
    }

    private DetailAST findMatchingAnnotation(DetailAST variableDef) {
        DetailAST matchingAnnotation = null;
        DetailAST holder = AnnotationUtility.getAnnotationHolder(variableDef);
        for (DetailAST child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST ast;
            String name;
            if (child.getType() != 158 || !this.ignoreAnnotationCanonicalNames.contains(name = FullIdent.createFullIdent((ast = child.getFirstChild()).getNextSibling()).getText()) && !this.ignoreAnnotationShortNames.contains(name)) continue;
            matchingAnnotation = child;
            break;
        }
        return matchingAnnotation;
    }
}

