/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class RequireThisCheck
extends AbstractCheck {
    public static final String MSG_METHOD = "require.this.method";
    public static final String MSG_VARIABLE = "require.this.variable";
    private static final ImmutableSet<Integer> DECLARATION_TOKENS = ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(14), Integer.valueOf(153), Integer.valueOf(15), new Integer[]{21, 163});
    private Map<DetailAST, AbstractFrame> frames;
    private AbstractFrame current;
    private boolean checkFields = true;
    private boolean checkMethods = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 153, 8, 9, 7, 58};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        LinkedList<AbstractFrame> frameStack = Lists.newLinkedList();
        this.frames = Maps.newHashMap();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            RequireThisCheck.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                this.processIdent(ast);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 153: 
            case 156: {
                this.current = this.frames.get(ast);
                break;
            }
        }
    }

    private void processIdent(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 158: 
            case 159: 
            case 160: {
                break;
            }
            case 27: {
                AbstractFrame frame;
                if (!this.checkMethods || (frame = this.checkMethod(ast)) == null) break;
                this.logViolation(MSG_METHOD, ast, frame);
                break;
            }
            default: {
                AbstractFrame frame;
                if (!this.checkFields || (frame = this.processField(ast, parentType)) == null) break;
                this.logViolation(MSG_VARIABLE, ast, frame);
            }
        }
    }

    private void logViolation(String msgKey, DetailAST ast, AbstractFrame frame) {
        if (frame.getFrameName().equals(this.getNearestClassFrameName())) {
            this.log(ast, msgKey, ast.getText(), "");
        } else {
            this.log(ast, msgKey, ast.getText(), frame.getFrameName() + '.');
        }
    }

    private AbstractFrame processField(DetailAST ast, int parentType) {
        boolean importOrPackage = ScopeUtils.getSurroundingScope(ast) == null;
        boolean methodNameInMethodCall = parentType == 59 && ast.getPreviousSibling() != null;
        boolean typeName = parentType == 13 || parentType == 136;
        AbstractFrame frame = null;
        if (!(importOrPackage || methodNameInMethodCall || typeName || RequireThisCheck.isDeclarationToken(parentType))) {
            frame = this.checkField(ast);
        }
        return frame;
    }

    private static void collectDeclarations(Deque<AbstractFrame> frameStack, DetailAST ast) {
        AbstractFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                RequireThisCheck.collectVariableDeclarations(ast, frame);
                break;
            }
            case 21: {
                DetailAST parameterIdent = ast.findFirstToken(58);
                frame.addIdent(parameterIdent);
                break;
            }
            case 14: 
            case 15: 
            case 153: 
            case 156: {
                DetailAST classIdent = ast.findFirstToken(58);
                frameStack.addFirst(new ClassFrame(frame, classIdent.getText()));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame));
                break;
            }
            case 9: {
                DetailAST ident = ast.findFirstToken(58);
                if (frame.getType() == FrameType.CLASS_FRAME) {
                    DetailAST mods = ast.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMethod(ident);
                    } else {
                        ((ClassFrame)frame).addInstanceMethod(ident);
                    }
                }
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
            case 8: {
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
        }
    }

    private static void collectVariableDeclarations(DetailAST ast, AbstractFrame frame) {
        DetailAST ident = ast.findFirstToken(58);
        if (frame.getType() == FrameType.CLASS_FRAME) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtils.isInInterfaceBlock(ast) || mods.branchContains(64)) {
                ((ClassFrame)frame).addStaticMember(ident);
            } else {
                ((ClassFrame)frame).addInstanceMember(ident);
            }
        } else {
            frame.addIdent(ident);
        }
    }

    private void endCollectingDeclarations(Queue<AbstractFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 153: 
            case 156: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    private AbstractFrame checkField(DetailAST ast) {
        AbstractFrame frame = this.findFrame(ast, false);
        if (frame != null && frame.getType() == FrameType.CLASS_FRAME && ((ClassFrame)frame).hasInstanceMember(ast)) {
            return frame;
        }
        return null;
    }

    private AbstractFrame checkMethod(DetailAST ast) {
        AbstractFrame frame = this.findFrame(ast, true);
        if (frame != null && ((ClassFrame)frame).hasInstanceMethod(ast) && !((ClassFrame)frame).hasStaticMethod(ast)) {
            return frame;
        }
        return null;
    }

    private AbstractFrame findFrame(DetailAST name, boolean lookForMethod) {
        if (this.current == null) {
            return null;
        }
        return this.current.getIfContains(name, lookForMethod);
    }

    private static boolean isDeclarationToken(int parentType) {
        return DECLARATION_TOKENS.contains(parentType);
    }

    private String getNearestClassFrameName() {
        AbstractFrame frame = this.current;
        while (frame.getType() != FrameType.CLASS_FRAME) {
            frame = frame.getParent();
        }
        return frame.getFrameName();
    }

    private static class BlockFrame
    extends AbstractFrame {
        protected BlockFrame(AbstractFrame parent) {
            super(parent, null);
        }

        @Override
        protected FrameType getType() {
            return FrameType.BLOCK_FRAME;
        }
    }

    private static class ClassFrame
    extends AbstractFrame {
        private final Set<DetailAST> instanceMembers = Sets.newHashSet();
        private final Set<DetailAST> instanceMethods = Sets.newHashSet();
        private final Set<DetailAST> staticMembers = Sets.newHashSet();
        private final Set<DetailAST> staticMethods = Sets.newHashSet();

        ClassFrame(AbstractFrame parent, String frameName) {
            super(parent, frameName);
        }

        @Override
        protected FrameType getType() {
            return FrameType.CLASS_FRAME;
        }

        public void addStaticMember(DetailAST ident) {
            this.staticMembers.add(ident);
        }

        public void addStaticMethod(DetailAST ident) {
            this.staticMethods.add(ident);
        }

        public void addInstanceMember(DetailAST ident) {
            this.instanceMembers.add(ident);
        }

        public void addInstanceMethod(DetailAST ident) {
            this.instanceMethods.add(ident);
        }

        public boolean hasInstanceMember(DetailAST ident) {
            return this.containsFieldOrVariableDef(this.instanceMembers, ident);
        }

        public boolean hasInstanceMethod(DetailAST ident) {
            return this.containsMethodDef(this.instanceMethods, ident);
        }

        public boolean hasStaticMethod(DetailAST ident) {
            return this.containsMethodDef(this.staticMethods, ident);
        }

        @Override
        protected boolean containsFieldOrVariable(DetailAST nameToFind) {
            return this.containsFieldOrVariableDef(this.instanceMembers, nameToFind) || this.containsFieldOrVariableDef(this.staticMembers, nameToFind);
        }

        @Override
        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText());
        }

        @Override
        protected AbstractFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            AbstractFrame frame = null;
            if (lookForMethod && this.containsMethod(nameToFind) || this.containsFieldOrVariable(nameToFind)) {
                frame = this;
            } else if (this.getParent() != null) {
                frame = this.getParent().getIfContains(nameToFind, lookForMethod);
            }
            return frame;
        }

        private boolean containsMethod(DetailAST methodToFind) {
            return this.containsMethodDef(this.instanceMethods, methodToFind) || this.containsMethodDef(this.staticMethods, methodToFind);
        }

        private boolean containsMethodDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isSimilarSignature(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        private boolean isSimilarSignature(DetailAST ident, DetailAST ast) {
            boolean result = false;
            if (ident.getText().equals(ast.getText())) {
                int argsNumber;
                int paramsNumber = ast.getParent().findFirstToken(20).getChildCount();
                result = paramsNumber == (argsNumber = ident.getParent().findFirstToken(34).getChildCount());
            }
            return result;
        }
    }

    private static class MethodFrame
    extends AbstractFrame {
        protected MethodFrame(AbstractFrame parent) {
            super(parent, null);
        }

        @Override
        protected FrameType getType() {
            return FrameType.METHOD_FRAME;
        }
    }

    private static abstract class AbstractFrame {
        private final Set<DetailAST> varIdents;
        private final AbstractFrame parent;
        private final String frameName;

        protected AbstractFrame(AbstractFrame parent, String frameName) {
            this.parent = parent;
            this.frameName = frameName;
            this.varIdents = Sets.newHashSet();
        }

        protected abstract FrameType getType();

        private void addIdent(DetailAST identToAdd) {
            this.varIdents.add(identToAdd);
        }

        protected AbstractFrame getParent() {
            return this.parent;
        }

        protected String getFrameName() {
            return this.frameName;
        }

        protected boolean containsFieldOrVariable(DetailAST nameToFind) {
            return this.containsFieldOrVariableDef(this.varIdents, nameToFind);
        }

        protected AbstractFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            AbstractFrame frame = !lookForMethod && this.containsFieldOrVariable(nameToFind) ? this : this.parent.getIfContains(nameToFind, lookForMethod);
            return frame;
        }

        protected boolean containsFieldOrVariableDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isProperDefinition(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText()) && AbstractFrame.checkPosition(ast, ident);
        }

        private static boolean checkPosition(DetailAST ast1, DetailAST ast2) {
            boolean result = false;
            if (ast1.getLineNo() < ast2.getLineNo() || ast1.getLineNo() == ast2.getLineNo() && ast1.getColumnNo() < ast2.getColumnNo()) {
                result = true;
            }
            return result;
        }
    }

    private static enum FrameType {
        CLASS_FRAME,
        METHOD_FRAME,
        BLOCK_FRAME;

    }
}

