/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.AstTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Main {
    private static final int HELP_WIDTH = 100;
    private static final int EXIT_WITH_CHECKSTYLE_EXCEPTION_CODE = -2;
    private static final String OPTION_V_NAME = "v";
    private static final String OPTION_C_NAME = "c";
    private static final String OPTION_F_NAME = "f";
    private static final String OPTION_P_NAME = "p";
    private static final String OPTION_O_NAME = "o";
    private static final String OPTION_T_NAME = "t";
    private static final String OPTION_TREE_NAME = "tree";
    private static final String OPTION_CAPITAL_T_NAME = "T";
    private static final String OPTION_TREE_COMMENT_NAME = "treeWithComments";
    private static final String XML_FORMAT_NAME = "xml";
    private static final String PLAIN_FORMAT_NAME = "plain";

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String ... args) throws IOException {
        int exitStatus;
        block20: {
            int errorCounter = 0;
            boolean cliViolations = false;
            int exitWithCliViolation = -1;
            exitStatus = 0;
            try {
                CommandLine commandLine = Main.parseCli(args);
                if (commandLine.hasOption(OPTION_V_NAME)) {
                    System.out.println("Checkstyle version: " + Main.class.getPackage().getImplementationVersion());
                    exitStatus = 0;
                } else {
                    List<File> filesToProcess = Main.getFilesToProcess(commandLine.getArgs());
                    List<String> messages = Main.validateCli(commandLine, filesToProcess);
                    boolean bl = cliViolations = !messages.isEmpty();
                    if (cliViolations) {
                        exitStatus = -1;
                        errorCounter = 1;
                        for (String message : messages) {
                            System.out.println(message);
                        }
                    } else {
                        CliOptions config = Main.convertCliToPojo(commandLine, filesToProcess);
                        if (commandLine.hasOption(OPTION_T_NAME)) {
                            File file = (File)config.files.get(0);
                            String stringAst = AstTreeStringPrinter.printFileAst(file, false);
                            System.out.print(stringAst);
                        } else if (commandLine.hasOption(OPTION_CAPITAL_T_NAME)) {
                            File file = (File)config.files.get(0);
                            String stringAst = AstTreeStringPrinter.printFileAst(file, true);
                            System.out.print(stringAst);
                        } else {
                            exitStatus = errorCounter = Main.runCheckstyle(config);
                        }
                    }
                }
                if (errorCounter == 0 || cliViolations) break block20;
            }
            catch (ParseException pex) {
                block21: {
                    cliViolations = true;
                    exitStatus = -1;
                    errorCounter = 1;
                    System.out.println(pex.getMessage());
                    Main.printUsage();
                    if (errorCounter == 0 || cliViolations) break block21;
                    System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            catch (CheckstyleException ex) {
                block22: {
                    exitStatus = -2;
                    errorCounter = 1;
                    ex.printStackTrace();
                    if (errorCounter == 0 || cliViolations) break block22;
                    {
                        catch (Throwable throwable) {
                            if (errorCounter != 0 && !cliViolations) {
                                System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                            }
                            if (exitStatus != 0) {
                                System.exit(exitStatus);
                            }
                            throw throwable;
                        }
                    }
                    System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                }
                if (exitStatus != 0) {
                    System.exit(exitStatus);
                }
            }
            System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
        }
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private static CommandLine parseCli(String ... args) throws ParseException {
        DefaultParser clp = new DefaultParser();
        return clp.parse(Main.buildOptions(), args);
    }

    private static List<String> validateCli(CommandLine cmdLine, List<File> filesToProcess) {
        ArrayList<String> result = new ArrayList<String>();
        if (filesToProcess.isEmpty()) {
            result.add("Files to process must be specified, found 0.");
        } else if (cmdLine.hasOption(OPTION_T_NAME) || cmdLine.hasOption(OPTION_CAPITAL_T_NAME)) {
            if (cmdLine.hasOption(OPTION_C_NAME) || cmdLine.hasOption(OPTION_P_NAME) || cmdLine.hasOption(OPTION_F_NAME) || cmdLine.hasOption(OPTION_O_NAME)) {
                result.add("Option '-t' cannot be used with other options.");
            } else if (filesToProcess.size() > 1) {
                result.add("Printing AST is allowed for only one file.");
            }
        } else if (cmdLine.hasOption(OPTION_C_NAME)) {
            String outputLocation;
            String propertiesLocation;
            File file;
            String format;
            String configLocation = cmdLine.getOptionValue(OPTION_C_NAME);
            try {
                CommonUtils.getUriByFilename(configLocation);
            }
            catch (CheckstyleException ignored) {
                result.add(String.format("Could not find config XML file '%s'.", configLocation));
            }
            if (cmdLine.hasOption(OPTION_F_NAME) && !PLAIN_FORMAT_NAME.equals(format = cmdLine.getOptionValue(OPTION_F_NAME)) && !XML_FORMAT_NAME.equals(format)) {
                result.add(String.format("Invalid output format. Found '%s' but expected '%s' or '%s'.", format, PLAIN_FORMAT_NAME, XML_FORMAT_NAME));
            }
            if (cmdLine.hasOption(OPTION_P_NAME) && !(file = new File(propertiesLocation = cmdLine.getOptionValue(OPTION_P_NAME))).exists()) {
                result.add(String.format("Could not find file '%s'.", propertiesLocation));
            }
            if (cmdLine.hasOption(OPTION_O_NAME) && (file = new File(outputLocation = cmdLine.getOptionValue(OPTION_O_NAME))).exists() && !file.canWrite()) {
                result.add(String.format("Permission denied : '%s'.", outputLocation));
            }
        } else {
            result.add("Must specify a config XML file.");
        }
        return result;
    }

    private static CliOptions convertCliToPojo(CommandLine cmdLine, List<File> filesToProcess) {
        CliOptions conf = new CliOptions();
        conf.format = cmdLine.getOptionValue(OPTION_F_NAME);
        if (conf.format == null) {
            conf.format = PLAIN_FORMAT_NAME;
        }
        conf.outputLocation = cmdLine.getOptionValue(OPTION_O_NAME);
        conf.configLocation = cmdLine.getOptionValue(OPTION_C_NAME);
        conf.propertiesLocation = cmdLine.getOptionValue(OPTION_P_NAME);
        conf.files = filesToProcess;
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runCheckstyle(CliOptions cliOptions) throws CheckstyleException, FileNotFoundException {
        Properties props = cliOptions.propertiesLocation == null ? System.getProperties() : Main.loadProperties(new File(cliOptions.propertiesLocation));
        Configuration config = ConfigurationLoader.loadConfiguration(cliOptions.configLocation, new PropertiesExpander(props));
        AuditListener listener = Main.createListener(cliOptions.format, cliOptions.outputLocation);
        int errorCounter = 0;
        Checker checker = new Checker();
        try {
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            checker.setModuleClassLoader(moduleClassLoader);
            checker.configure(config);
            checker.addListener(listener);
            errorCounter = checker.process(cliOptions.files);
        }
        finally {
            checker.destroy();
        }
        return errorCounter;
    }

    private static Properties loadProperties(File file) throws CheckstyleException {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException(String.format("Unable to load properties from file '%s'.", file.getAbsolutePath()), ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fis);
                throw throwable;
            }
        }
        Closeables.closeQuietly(fis);
        return properties;
    }

    private static AuditListener createListener(String format, String outputLocation) throws FileNotFoundException {
        AutomaticBean listener;
        boolean closeOutputStream;
        OutputStream out;
        if (outputLocation == null) {
            out = System.out;
            closeOutputStream = false;
        } else {
            out = new FileOutputStream(outputLocation);
            closeOutputStream = true;
        }
        if (XML_FORMAT_NAME.equals(format)) {
            listener = new XMLLogger(out, closeOutputStream);
        } else if (PLAIN_FORMAT_NAME.equals(format)) {
            listener = new DefaultLogger(out, closeOutputStream, out, false);
        } else {
            if (closeOutputStream) {
                CommonUtils.close(out);
            }
            throw new IllegalStateException(String.format("Invalid output format. Found '%s' but expected '%s' or '%s'.", format, PLAIN_FORMAT_NAME, XML_FORMAT_NAME));
        }
        return listener;
    }

    private static List<File> getFilesToProcess(String ... filesToProcess) {
        LinkedList<File> files = Lists.newLinkedList();
        for (String element : filesToProcess) {
            files.addAll(Main.listFiles(new File(element)));
        }
        return files;
    }

    private static List<File> listFiles(File node) {
        LinkedList<File> result = Lists.newLinkedList();
        if (node.canRead()) {
            if (node.isDirectory()) {
                File[] files = node.listFiles();
                if (files != null) {
                    for (File element : files) {
                        result.addAll(Main.listFiles(element));
                    }
                }
            } else if (node.isFile()) {
                result.add(node);
            }
        }
        return result;
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp(String.format("java %s [options] -c <config.xml> file...", Main.class.getName()), Main.buildOptions());
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption(OPTION_C_NAME, true, "Sets the check configuration file to use.");
        options.addOption(OPTION_O_NAME, true, "Sets the output file. Defaults to stdout");
        options.addOption(OPTION_P_NAME, true, "Loads the properties file");
        options.addOption(OPTION_F_NAME, true, String.format("Sets the output format. (%s|%s). Defaults to %s", PLAIN_FORMAT_NAME, XML_FORMAT_NAME, PLAIN_FORMAT_NAME));
        options.addOption(OPTION_V_NAME, false, "Print product version and exit");
        options.addOption(OPTION_T_NAME, OPTION_TREE_NAME, false, "Print Abstract Syntax Tree(AST) of the file");
        options.addOption(OPTION_CAPITAL_T_NAME, OPTION_TREE_COMMENT_NAME, false, "Print Abstract Syntax Tree(AST) of the file including comments");
        return options;
    }

    private static class CliOptions {
        private String propertiesLocation;
        private String configLocation;
        private String format;
        private String outputLocation;
        private List<File> files;

        private CliOptions() {
        }
    }
}

