/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    public static final Set<String> NAMED_WAYS = new HashSet<String>();

    public UntaggedWay() {
        super(I18n.tr((String)"Untagged, empty, and one node ways."), I18n.tr((String)"This test checks for untagged, empty and one node ways."));
    }

    public void visit(Way w) {
        String highway;
        if (w.deleted || w.incomplete) {
            return;
        }
        Map tags = w.keys;
        if (tags != null && (highway = (String)tags.get("highway")) != null && NAMED_WAYS.contains(highway) && !tags.containsKey("name") && !tags.containsKey("ref")) {
            String key;
            boolean hasName = false;
            Iterator i$ = w.keySet().iterator();
            while (i$.hasNext() && !(hasName = (key = (String)i$.next()).startsWith("name:") || key.endsWith("_name") || key.endsWith("_ref"))) {
            }
            if (!hasName) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unnamed ways"), 303, (OsmPrimitive)w));
            }
        }
        if (!w.tagged) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Untagged ways"), 302, (OsmPrimitive)w));
        }
        if (w.nodes.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Empty ways"), 301, (OsmPrimitive)w));
        } else if (w.nodes.size() == 1) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"One node ways"), 304, (OsmPrimitive)w));
        }
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    public Command fixError(TestError testError) {
        return new DeleteCommand(testError.getPrimitives());
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
    }
}

