/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    Bag<Way, Way> _errorWays;

    public UnclosedWays() {
        super(I18n.tr((String)"Unclosed Ways."), I18n.tr((String)"This tests if ways which should be circular are closed."));
    }

    public void startTest() {
        this._errorWays = new Bag();
    }

    public void endTest() {
        this._errorWays = null;
    }

    public void visit(Way w) {
        LatLon e;
        LatLon s;
        Boolean btest;
        boolean force = false;
        String type = null;
        int mode = 0;
        if (w.deleted || w.incomplete) {
            return;
        }
        String test = w.get("natural");
        if (test != null) {
            if (!"coastline".equals(test)) {
                force = true;
            }
            type = I18n.tr((String)"natural type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1101;
        }
        if ((test = w.get("landuse")) != null) {
            force = true;
            type = I18n.tr((String)"landuse type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1102;
        }
        if ((test = w.get("amenities")) != null) {
            force = true;
            type = I18n.tr((String)"amenities type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1103;
        }
        if ((test = w.get("sport")) != null) {
            force = true;
            type = I18n.tr((String)"sport type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1104;
        }
        if ((test = w.get("tourism")) != null) {
            force = true;
            type = I18n.tr((String)"tourism type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1105;
        }
        if ((test = w.get("shop")) != null) {
            force = true;
            type = I18n.tr((String)"shop type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1106;
        }
        if ((test = w.get("leisure")) != null) {
            force = true;
            type = I18n.tr((String)"leisure type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1107;
        }
        if ((test = w.get("waterway")) != null && test.equals("riverbank")) {
            force = true;
            type = I18n.tr((String)"waterway type {0}", (Object[])new Object[]{I18n.tr((String)test)});
            mode = 1108;
        }
        if ((btest = OsmUtils.getOsmBoolean((String)w.get("building"))) != null && btest.booleanValue()) {
            force = true;
            type = I18n.tr((String)"building");
            mode = 1120;
        }
        if ((btest = OsmUtils.getOsmBoolean((String)w.get("area"))) != null && btest.booleanValue()) {
            force = true;
            type = I18n.tr((String)"area");
            mode = 1130;
        }
        if (type != null && (s = ((Node)w.nodes.get((int)0)).coor) != (e = ((Node)w.nodes.get((int)(w.nodes.size() - 1))).coor) && (force || s.greatCircleDistance(e) < 10000.0)) {
            ArrayList<Way> primitives = new ArrayList<Way>();
            primitives.add(w);
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Unclosed way"), type, mode, primitives));
            this._errorWays.add(w, w);
        }
    }
}

