/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int aZoomlevel) {
        return (double)TILE_SIZE * Math.pow(2.0, aZoomlevel) / (Math.PI * 2);
    }

    public static int getMaxPixels(int aZoomlevel) {
        return (int)((double)TILE_SIZE * Math.pow(2.0, aZoomlevel));
    }

    public static int falseEasting(int aZoomlevel) {
        return OsmMercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int falseNorthing(int aZoomlevel) {
        return -1 * OsmMercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int LonToX(double aLongitude, int aZoomlevel) {
        double longitude = Math.toRadians(aLongitude);
        return (int)(OsmMercator.radius(aZoomlevel) * longitude + (double)OsmMercator.falseEasting(aZoomlevel));
    }

    public static int LatToY(double aLat, int aZoomlevel) {
        if (aLat < -85.05112877980659) {
            aLat = -85.05112877980659;
        } else if (aLat > 85.05112877980659) {
            aLat = 85.05112877980659;
        }
        double latitude = Math.toRadians(aLat);
        return (int)(-1.0 * (OsmMercator.radius(aZoomlevel) / 2.0 * Math.log((1.0 + Math.sin(latitude)) / (1.0 - Math.sin(latitude)))) - (double)OsmMercator.falseNorthing(aZoomlevel));
    }

    public static double XToLon(int aX, int aZoomlevel) {
        double longRadians = (double)(aX -= OsmMercator.falseEasting(aZoomlevel)) / OsmMercator.radius(aZoomlevel);
        double longDegrees = Math.toDegrees(longRadians);
        double rotations = Math.floor((longDegrees + 180.0) / 360.0);
        double longitude = longDegrees - rotations * 360.0;
        return longitude;
    }

    public static double YToLat(int aY, int aZoomlevel) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(aY += OsmMercator.falseNorthing(aZoomlevel)) / OsmMercator.radius(aZoomlevel)));
        return -1.0 * Math.toDegrees(latitude);
    }
}

