/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class DuplicateNode
extends Test {
    protected static int DUPLICATE_NODE = 1;
    Bag<LatLon, OsmPrimitive> nodes;

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes."), I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    public void startTest() {
        this.nodes = new Bag(1000);
    }

    public void endTest() {
        for (List duplicated : this.nodes.values()) {
            if (duplicated.size() <= 1) continue;
            TestError testError = new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, duplicated);
            this.errors.add(testError);
        }
        this.nodes = null;
    }

    public void visit(Node n) {
        if (!n.deleted && !n.incomplete) {
            this.nodes.add(n.coor, (OsmPrimitive)n);
        }
    }

    public Command fixError(TestError testError) {
        List<? extends OsmPrimitive> sel = testError.getPrimitives();
        ArrayList<OsmPrimitive> nodes = new ArrayList<OsmPrimitive>();
        Node target = null;
        for (OsmPrimitive osmPrimitive : sel) {
            nodes.add(osmPrimitive);
        }
        if (nodes.size() < 2) {
            return null;
        }
        for (OsmPrimitive osmPrimitive : nodes) {
            Node n = (Node)osmPrimitive;
            if (target == null || target.id == 0L) {
                target = n;
                continue;
            }
            if (n.id == 0L || n.id >= target.id) continue;
            target = n;
        }
        if (target == null) {
            return null;
        }
        nodes.remove(target);
        Node newtarget = new Node(target);
        for (OsmPrimitive o : nodes) {
            Node n = (Node)o;
            for (String key : n.keySet()) {
                if (newtarget.keySet().contains(key) && !newtarget.get(key).equals(n.get(key))) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nodes have conflicting key: {0} [{1}, {2}]", (Object[])new Object[]{key, newtarget.get(key), n.get(key)}));
                    return null;
                }
                newtarget.put(key, n.get(key));
            }
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Way w : Main.ds.ways) {
            if (w.deleted || w.incomplete) continue;
            Way wnew = null;
            int len = w.nodes.size();
            for (int i = 0; i < len; ++i) {
                if (!nodes.contains(w.nodes.get(i))) continue;
                if (wnew == null) {
                    wnew = new Way(w);
                }
                wnew.nodes.set(i, target);
            }
            if (wnew == null) continue;
            linkedList.add(new ChangeCommand((OsmPrimitive)w, wnew));
        }
        linkedList.add(new DeleteCommand(nodes));
        linkedList.add(new ChangeCommand((OsmPrimitive)target, (OsmPrimitive)newtarget));
        return new SequenceCommand(I18n.tr((String)"Merge Nodes"), linkedList);
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }
}

