/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LineWrappingHandler {
    private final IndentationCheck indentCheck;
    private final DetailAST firstNode;
    private final DetailAST lastNode;
    private final int indentLevel;
    private final boolean forceStrictCondition;

    public LineWrappingHandler(IndentationCheck instance, DetailAST firstNode, DetailAST lastNode) {
        this.indentCheck = instance;
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.indentLevel = this.indentCheck.getLineWrappingIndentation();
        this.forceStrictCondition = this.indentCheck.isForceStrictCondition();
    }

    protected final DetailAST getLastNode() {
        return this.lastNode;
    }

    public void checkIndentation() {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes();
        DetailAST firstLineNode = (DetailAST)firstNodesOnLines.get(firstNodesOnLines.firstKey());
        if (firstLineNode.getType() == 170) {
            this.checkAnnotationIndentation(firstLineNode, firstNodesOnLines);
        }
        firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        int firstNodeIndent = LineWrappingHandler.getFirstNodeIndent(firstLineNode);
        int currentIndent = firstNodeIndent + this.indentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (currentType == 73 || currentType == 77 || currentType == 29) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            this.logWarningMessage(node, currentIndent);
        }
    }

    private static int getFirstNodeIndent(DetailAST node) {
        int indentLevel = node.getColumnNo();
        if (node.getType() == 83 && node.getParent().getType() == 92) {
            DetailAST lcurly = node.getParent().getPreviousSibling();
            DetailAST rcurly = lcurly.getLastChild();
            indentLevel = lcurly.getType() == 7 && rcurly.getLineNo() == node.getLineNo() ? rcurly.getColumnNo() : node.getParent().getColumnNo();
        }
        return indentLevel;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes() {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(this.firstNode.getLineNo(), this.firstNode);
        DetailAST curNode = this.firstNode.getFirstChild();
        while (curNode != null && curNode != this.lastNode) {
            if (curNode.getType() == 6 || curNode.getType() == 7) {
                curNode = curNode.getNextSibling();
            }
            if (curNode == null) continue;
            DetailAST firstTokenOnLine = (DetailAST)result.get(curNode.getLineNo());
            if (firstTokenOnLine == null || firstTokenOnLine.getColumnNo() >= curNode.getColumnNo()) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = LineWrappingHandler.getNextCurNode(curNode);
        }
        return result;
    }

    private static DetailAST getNextCurNode(DetailAST curNode) {
        DetailAST nodeToVisit = curNode.getFirstChild();
        DetailAST currentNode = curNode;
        while (nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST atNode, NavigableMap<Integer, DetailAST> firstNodesOnLines) {
        DetailAST node;
        int currentIndent = atNode.getColumnNo() + this.indentLevel;
        int firstNodeIndent = atNode.getColumnNo();
        Collection values = firstNodesOnLines.values();
        DetailAST lastAnnotationNode = LineWrappingHandler.getLastAnnotationNode(atNode);
        int lastAnnotationLine = lastAnnotationNode.getLineNo();
        Iterator itr = values.iterator();
        while (firstNodesOnLines.size() > 1 && (node = (DetailAST)itr.next()).getLineNo() <= lastAnnotationLine) {
            boolean isCurrentNodeCloseAnnotationAloneInLine;
            DetailAST parentNode = node.getParent();
            boolean bl = isCurrentNodeCloseAnnotationAloneInLine = node.getLineNo() == lastAnnotationLine && node.equals(lastAnnotationNode);
            if (isCurrentNodeCloseAnnotationAloneInLine || node.getType() == 170 && parentNode.getParent().getType() == 5) {
                this.logWarningMessage(node, firstNodeIndent);
            } else {
                this.logWarningMessage(node, currentIndent);
            }
            itr.remove();
        }
    }

    private static DetailAST getLastAnnotationNode(DetailAST atNode) {
        DetailAST lastAnnotation = atNode.getParent();
        while (lastAnnotation.getNextSibling() != null && lastAnnotation.getNextSibling().getType() == 159) {
            lastAnnotation = lastAnnotation.getNextSibling();
        }
        return lastAnnotation.getLastChild();
    }

    private void logWarningMessage(DetailAST currentNode, int currentIndent) {
        if (this.forceStrictCondition) {
            if (currentNode.getColumnNo() != currentIndent) {
                this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), currentNode.getColumnNo(), currentIndent);
            }
        } else if (currentNode.getColumnNo() < currentIndent) {
            this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), currentNode.getColumnNo(), currentIndent);
        }
    }
}

