/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.gui.JTreeTable;
import com.puppycrawl.tools.checkstyle.gui.MainFrameModel;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 7970053543351871890L;
    private final transient MainFrameModel model = new MainFrameModel();
    private final ReloadAction reloadAction = new ReloadAction();
    private transient ParseTreeTableModel parseTreeTableModel;
    private JTextArea textArea;
    private JTreeTable treeTable;

    public MainFrame() {
        this.createContent();
    }

    private void createContent() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea(20, 15);
        this.textArea.setEditable(false);
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
        this.parseTreeTableModel = new ParseTreeTableModel(null);
        this.treeTable = new JTreeTable(this.parseTreeTableModel);
        this.treeTable.setEditor(this.textArea);
        this.treeTable.setLinePositionMap(this.model.getLinesToPosition());
        JScrollPane treeTableScrollPane = new JScrollPane(this.treeTable);
        JSplitPane splitPane = new JSplitPane(0, treeTableScrollPane, textAreaScrollPane);
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.7);
        this.add((Component)this.createButtonsPanel(), "Last");
        this.pack();
    }

    private JPanel createButtonsPanel() {
        JButton openFileButton = new JButton(new FileSelectionAction());
        openFileButton.setMnemonic(83);
        openFileButton.setText("Open File");
        this.reloadAction.setEnabled(false);
        JButton reloadFileButton = new JButton(this.reloadAction);
        reloadFileButton.setMnemonic(82);
        reloadFileButton.setText("Reload File");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(openFileButton);
        buttonPanel.add(reloadFileButton);
        return buttonPanel;
    }

    public void openFile(File sourceFile) {
        if (sourceFile != null) {
            try {
                this.setTitle("Checkstyle : " + sourceFile.getName());
                DetailAST parseTree = this.model.parseFile(sourceFile);
                this.parseTreeTableModel.setParseTree(parseTree);
                this.reloadAction.setEnabled(true);
                String[] sourceLines = this.model.getFileText(sourceFile).toLinesArray();
                this.model.clearLinesToPosition();
                this.model.addLineToPosition(0);
                this.textArea.setText("");
                for (String element : sourceLines) {
                    this.model.addLineToPosition(this.textArea.getText().length());
                    this.textArea.append(element + System.lineSeparator());
                }
                this.treeTable.setLinePositionMap(this.model.getLinesToPosition());
            }
            catch (ANTLRException | IOException ex) {
                JOptionPane.showMessageDialog(this, "Could not parse" + sourceFile + ": " + ex.getMessage());
            }
        }
    }

    private static class JavaFileFilter
    extends FileFilter {
        private JavaFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".java");
        }

        @Override
        public String getDescription() {
            return "Java Source File";
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -890320994114628011L;

        private ReloadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainFrame.this.openFile(MainFrame.this.model.getCurrentFile());
        }
    }

    private class FileSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1762396148873280589L;

        private FileSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser = new JFileChooser(MainFrame.this.model.getLastDirectory());
            JavaFileFilter filter = new JavaFileFilter();
            fileChooser.setFileFilter(filter);
            int returnCode = fileChooser.showOpenDialog(MainFrame.this);
            if (returnCode == 0) {
                File file = fileChooser.getSelectedFile();
                MainFrame.this.openFile(file);
            }
        }
    }
}

