/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavadocMethodCheck
extends AbstractTypeAwareCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    public static final String MSG_CLASS_INFO = "javadoc.classInfo";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    public static final String MSG_INVALID_INHERIT_DOC = "javadoc.invalidInheritDoc";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_EXPECTED_TAG = "javadoc.expectedTag";
    public static final String MSG_RETURN_EXPECTED = "javadoc.return.expected";
    public static final String MSG_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final Pattern MATCH_JAVADOC_ARG = CommonUtils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MULTILINE_START = CommonUtils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = CommonUtils.createPattern("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final Pattern MATCH_JAVADOC_NOARG = CommonUtils.createPattern("@(return|see)\\s+\\S");
    private static final Pattern MATCH_JAVADOC_NOARG_MULTILINE_START = CommonUtils.createPattern("@(return|see)\\s*$");
    private static final Pattern MATCH_JAVADOC_NOARG_CURLY = CommonUtils.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private static final int DEFAULT_MIN_LINE_COUNT = -1;
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private int minLineCount = -1;
    private boolean allowUndeclaredRTE;
    private boolean validateThrows;
    private boolean allowThrowsTagsForSubclasses;
    private boolean allowMissingParamTags;
    private boolean allowMissingThrowsTags;
    private boolean allowMissingReturnTag;
    private boolean allowMissingJavadoc;
    private boolean allowMissingPropertyJavadoc;
    private List<String> allowedAnnotations = Collections.singletonList("Override");
    private Pattern ignoreMethodNamesRegex;

    public void setIgnoreMethodNamesRegex(String regex) {
        this.ignoreMethodNamesRegex = CommonUtils.createPattern(regex);
    }

    public void setMinLineCount(int value) {
        this.minLineCount = value;
    }

    public void setValidateThrows(boolean value) {
        this.validateThrows = value;
    }

    public void setAllowedAnnotations(String userAnnotations) {
        ArrayList<String> annotations = new ArrayList<String>();
        String[] sAnnotations = userAnnotations.split(",");
        for (int i = 0; i < sAnnotations.length; ++i) {
            sAnnotations[i] = sAnnotations[i].trim();
        }
        Collections.addAll(annotations, sAnnotations);
        this.allowedAnnotations = annotations;
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String excludeScope) {
        this.excludeScope = Scope.getInstance(excludeScope);
    }

    public void setAllowUndeclaredRTE(boolean flag) {
        this.allowUndeclaredRTE = flag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean flag) {
        this.allowThrowsTagsForSubclasses = flag;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowMissingThrowsTags(boolean flag) {
        this.allowMissingThrowsTags = flag;
    }

    public void setAllowMissingReturnTag(boolean flag) {
        this.allowMissingReturnTag = flag;
    }

    public void setAllowMissingJavadoc(boolean flag) {
        this.allowMissingJavadoc = flag;
    }

    public void setAllowMissingPropertyJavadoc(boolean flag) {
        this.allowMissingPropertyJavadoc = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 14, 154, 15, 9, 8, 161};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    protected final void processAST(DetailAST ast) {
        Scope theScope = JavadocMethodCheck.calculateScope(ast);
        if (this.shouldCheck(ast, theScope)) {
            FileContents contents = this.getFileContents();
            TextBlock textBlock = contents.getJavadocBefore(ast.getLineNo());
            if (textBlock == null) {
                if (!this.isMissingJavadocAllowed(ast)) {
                    this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
                }
            } else {
                this.checkComment(ast, textBlock);
            }
        }
    }

    private boolean hasAllowedAnnotations(DetailAST methodDef) {
        DetailAST modifiersNode = methodDef.findFirstToken(5);
        for (DetailAST annotationNode = modifiersNode.findFirstToken(159); annotationNode != null && annotationNode.getType() == 159; annotationNode = annotationNode.getNextSibling()) {
            DetailAST identNode = annotationNode.findFirstToken(58);
            if (identNode == null) {
                identNode = annotationNode.findFirstToken(59).findFirstToken(58);
            }
            if (!this.allowedAnnotations.contains(identNode.getText())) continue;
            return true;
        }
        return false;
    }

    private static int getMethodsNumberOfLine(DetailAST methodDef) {
        DetailAST lcurly = methodDef.getLastChild();
        DetailAST rcurly = lcurly.getLastChild();
        int numberOfLines = lcurly.getFirstChild() == rcurly ? 1 : rcurly.getLineNo() - lcurly.getLineNo() - 1;
        return numberOfLines;
    }

    @Override
    protected final void logLoadError(AbstractTypeAwareCheck.Token ident) {
        this.logLoadErrorImpl(ident.getLineNo(), ident.getColumnNo(), MSG_CLASS_INFO, JavadocTagInfo.THROWS.getText(), ident.getText());
    }

    protected boolean isMissingJavadocAllowed(DetailAST ast) {
        return this.allowMissingJavadoc || this.allowMissingPropertyJavadoc && (CheckUtils.isSetterMethod(ast) || CheckUtils.isGetterMethod(ast)) || this.matchesSkipRegex(ast) || this.isContentsAllowMissingJavadoc(ast);
    }

    private boolean isContentsAllowMissingJavadoc(DetailAST ast) {
        return !(ast.getType() != 9 && ast.getType() != 8 || JavadocMethodCheck.getMethodsNumberOfLine(ast) > this.minLineCount && !this.hasAllowedAnnotations(ast));
    }

    private boolean matchesSkipRegex(DetailAST methodDef) {
        DetailAST ident;
        String methodName;
        Matcher matcher;
        return this.ignoreMethodNamesRegex != null && (matcher = this.ignoreMethodNamesRegex.matcher(methodName = (ident = methodDef.findFirstToken(58)).getText())).matches();
    }

    private boolean shouldCheck(DetailAST ast, Scope nodeScope) {
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return (this.excludeScope == null || nodeScope != this.excludeScope && surroundingScope != this.excludeScope) && nodeScope.isIn(this.scope) && surroundingScope.isIn(this.scope);
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        List<JavadocTag> tags = JavadocMethodCheck.getMethodTags(comment);
        if (this.hasShortCircuitTag(ast, tags)) {
            return;
        }
        Iterator<JavadocTag> it = tags.iterator();
        if (ast.getType() == 161) {
            this.checkReturnTag(tags, ast.getLineNo(), true);
        } else {
            boolean hasInheritDocTag = false;
            while (!hasInheritDocTag && it.hasNext()) {
                hasInheritDocTag = it.next().isInheritDocTag();
            }
            this.checkParamTags(tags, ast, !hasInheritDocTag);
            this.checkThrowsTags(tags, this.getThrows(ast), !hasInheritDocTag);
            if (CheckUtils.isNonVoidMethod(ast)) {
                this.checkReturnTag(tags, ast.getLineNo(), !hasInheritDocTag);
            }
        }
        for (JavadocTag javadocTag : tags) {
            if (javadocTag.isSeeOrInheritDocTag()) continue;
            this.log(javadocTag.getLineNo(), MSG_UNUSED_TAG_GENERAL, new Object[0]);
        }
    }

    private boolean hasShortCircuitTag(DetailAST ast, List<JavadocTag> tags) {
        if (tags.size() != 1 || !tags.get(0).isInheritDocTag()) {
            return false;
        }
        if (!JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
            this.log(ast, MSG_INVALID_INHERIT_DOC, new Object[0]);
        }
        return true;
    }

    private static Scope calculateScope(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        if (ScopeUtils.isInInterfaceOrAnnotationBlock(ast)) {
            return Scope.PUBLIC;
        }
        return declaredScope;
    }

    private static List<JavadocTag> getMethodTags(TextBlock comment) {
        String[] lines = comment.getText();
        ArrayList<JavadocTag> tags = Lists.newArrayList();
        int currentLine = comment.getStartLineNo() - 1;
        int startColumnNumber = comment.getStartColNo();
        for (int i = 0; i < lines.length; ++i) {
            int col;
            ++currentLine;
            Matcher javadocArgMatcher = MATCH_JAVADOC_ARG.matcher(lines[i]);
            Matcher javadocNoargMatcher = MATCH_JAVADOC_NOARG.matcher(lines[i]);
            Matcher noargCurlyMatcher = MATCH_JAVADOC_NOARG_CURLY.matcher(lines[i]);
            Matcher argMultilineStart = MATCH_JAVADOC_ARG_MULTILINE_START.matcher(lines[i]);
            Matcher noargMultilineStart = MATCH_JAVADOC_NOARG_MULTILINE_START.matcher(lines[i]);
            if (javadocArgMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocArgMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocArgMatcher.group(1), javadocArgMatcher.group(2)));
                continue;
            }
            if (javadocNoargMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocNoargMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocNoargMatcher.group(1)));
                continue;
            }
            if (noargCurlyMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(noargCurlyMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, noargCurlyMatcher.group(1)));
                continue;
            }
            if (argMultilineStart.find()) {
                col = JavadocMethodCheck.calculateTagColumn(argMultilineStart, i, startColumnNumber);
                tags.addAll(JavadocMethodCheck.getMultilineArgTags(argMultilineStart, col, lines, i, currentLine));
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            tags.addAll(JavadocMethodCheck.getMultilineNoArgTags(noargMultilineStart, lines, i, currentLine));
        }
        return tags;
    }

    private static int calculateTagColumn(Matcher javadocTagMatcher, int lineNumber, int startColumnNumber) {
        int col = javadocTagMatcher.start(1) - 1;
        if (lineNumber == 0) {
            col += startColumnNumber;
        }
        return col;
    }

    private static List<JavadocTag> getMultilineArgTags(Matcher argMultilineStart, int column, String[] lines, int lineIndex, int tagLine) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        String param1 = argMultilineStart.group(1);
        String param2 = argMultilineStart.group(2);
        for (int remIndex = lineIndex + 1; remIndex < lines.length; ++remIndex) {
            Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
            if (!multilineCont.find()) continue;
            remIndex = lines.length;
            String lFin = multilineCont.group(1);
            if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
            tags.add(new JavadocTag(tagLine, column, param1, param2));
        }
        return tags;
    }

    private static List<JavadocTag> getMultilineNoArgTags(Matcher noargMultilineStart, String[] lines, int lineIndex, int tagLine) {
        String param1 = noargMultilineStart.group(1);
        int col = noargMultilineStart.start(1) - 1;
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        for (int remIndex = lineIndex + 1; remIndex < lines.length; ++remIndex) {
            Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
            if (!multilineCont.find()) continue;
            remIndex = lines.length;
            String lFin = multilineCont.group(1);
            if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
            tags.add(new JavadocTag(tagLine, col, param1));
        }
        return tags;
    }

    private static List<DetailAST> getParameters(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        ArrayList<DetailAST> returnValue = Lists.newArrayList();
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            DetailAST ident = child.findFirstToken(58);
            returnValue.add(ident);
        }
        return returnValue;
    }

    private List<ExceptionInfo> getThrows(DetailAST ast) {
        ArrayList<ExceptionInfo> returnValue = Lists.newArrayList();
        DetailAST throwsAST = ast.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent ident = FullIdent.createFullIdent(child);
                ExceptionInfo exceptionInfo = new ExceptionInfo(this.createClassInfo(new AbstractTypeAwareCheck.Token(ident), this.getCurrentClassName()));
                returnValue.add(exceptionInfo);
            }
        }
        return returnValue;
    }

    private void checkParamTags(List<JavadocTag> tags, DetailAST parent, boolean reportExpectedTags) {
        List<DetailAST> params = JavadocMethodCheck.getParameters(parent);
        List<DetailAST> typeParams = CheckUtils.getTypeParameters(parent);
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            String arg1 = tag.getFirstArg();
            boolean found = JavadocMethodCheck.removeMatchingParam(params, arg1);
            if (CommonUtils.startsWithChar(arg1, '<') && CommonUtils.endsWithChar(arg1, '>')) {
                found = JavadocMethodCheck.searchMatchingTypeParameter(typeParams, arg1.substring(1, arg1.length() - 1));
            }
            if (found) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, "@param", arg1);
        }
        if (!this.allowMissingParamTags && reportExpectedTags) {
            for (DetailAST param : params) {
                this.log(param, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), param.getText());
            }
            for (DetailAST typeParam : typeParams) {
                this.log(typeParam, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), "<" + typeParam.findFirstToken(58).getText() + ">");
            }
        }
    }

    private static boolean searchMatchingTypeParameter(List<DetailAST> typeParams, String requiredTypeName) {
        Iterator<DetailAST> typeParamsIt = typeParams.iterator();
        boolean found = false;
        while (typeParamsIt.hasNext()) {
            DetailAST typeParam = typeParamsIt.next();
            if (!typeParam.findFirstToken(58).getText().equals(requiredTypeName)) continue;
            found = true;
            typeParamsIt.remove();
            break;
        }
        return found;
    }

    private static boolean removeMatchingParam(List<DetailAST> params, String paramName) {
        boolean found = false;
        Iterator<DetailAST> paramIt = params.iterator();
        while (paramIt.hasNext()) {
            DetailAST param = paramIt.next();
            if (!param.getText().equals(paramName)) continue;
            found = true;
            paramIt.remove();
            break;
        }
        return found;
    }

    private void checkReturnTag(List<JavadocTag> tags, int lineNo, boolean reportExpectedTags) {
        boolean found = false;
        ListIterator<JavadocTag> it = tags.listIterator();
        while (it.hasNext()) {
            JavadocTag javadocTag = it.next();
            if (!javadocTag.isReturnTag()) continue;
            if (found) {
                this.log(javadocTag.getLineNo(), javadocTag.getColumnNo(), MSG_DUPLICATE_TAG, JavadocTagInfo.RETURN.getText());
            }
            found = true;
            it.remove();
        }
        if (!found && !this.allowMissingReturnTag && reportExpectedTags) {
            this.log(lineNo, MSG_RETURN_EXPECTED, new Object[0]);
        }
    }

    private void checkThrowsTags(List<JavadocTag> tags, List<ExceptionInfo> throwsList, boolean reportExpectedTags) {
        AbstractTypeAwareCheck.Token token;
        HashSet<String> foundThrows = Sets.newHashSet();
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getFirstArg();
            token = new AbstractTypeAwareCheck.Token(tag.getFirstArg(), tag.getLineNo(), tag.getColumnNo());
            AbstractTypeAwareCheck.AbstractClassInfo documentedClassInfo = this.createClassInfo(token, this.getCurrentClassName());
            boolean found = foundThrows.contains(documentedEx) || this.isInThrows(throwsList, documentedClassInfo, foundThrows);
            if (found) continue;
            boolean reqd = true;
            if (this.allowUndeclaredRTE) {
                boolean bl = reqd = !JavadocMethodCheck.isUnchecked(documentedClassInfo.getClazz());
            }
            if (!reqd || !this.validateThrows) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.THROWS.getText(), tag.getFirstArg());
        }
        if (!this.allowMissingThrowsTags && reportExpectedTags) {
            for (ExceptionInfo exceptionInfo : throwsList) {
                if (exceptionInfo.isFound()) continue;
                token = exceptionInfo.getName();
                this.log(token.getLineNo(), token.getColumnNo(), MSG_EXPECTED_TAG, JavadocTagInfo.THROWS.getText(), token.getText());
            }
        }
    }

    private boolean isInThrows(List<ExceptionInfo> throwsList, AbstractTypeAwareCheck.AbstractClassInfo documentedClassInfo, Set<String> foundThrows) {
        boolean found = false;
        ExceptionInfo foundException = null;
        ListIterator<ExceptionInfo> throwIt = throwsList.listIterator();
        while (!found && throwIt.hasNext()) {
            ExceptionInfo exceptionInfo = throwIt.next();
            if (!exceptionInfo.getName().getText().equals(documentedClassInfo.getName().getText())) continue;
            found = true;
            foundException = exceptionInfo;
        }
        ListIterator<ExceptionInfo> exceptionInfoIt = throwsList.listIterator();
        while (!found && exceptionInfoIt.hasNext()) {
            ExceptionInfo exceptionInfo = exceptionInfoIt.next();
            if (documentedClassInfo.getClazz() == exceptionInfo.getClazz()) {
                found = true;
                foundException = exceptionInfo;
                continue;
            }
            if (!this.allowThrowsTagsForSubclasses) continue;
            found = JavadocMethodCheck.isSubclass(documentedClassInfo.getClazz(), exceptionInfo.getClazz());
        }
        if (foundException != null) {
            foundException.setFound();
            foundThrows.add(documentedClassInfo.getName().getText());
        }
        return found;
    }

    private static class ExceptionInfo {
        private final AbstractTypeAwareCheck.AbstractClassInfo classInfo;
        private boolean found;

        ExceptionInfo(AbstractTypeAwareCheck.AbstractClassInfo classInfo) {
            this.classInfo = classInfo;
        }

        private void setFound() {
            this.found = true;
        }

        private boolean isFound() {
            return this.found;
        }

        private AbstractTypeAwareCheck.Token getName() {
            return this.classInfo.getName();
        }

        private Class<?> getClazz() {
            return this.classInfo.getClazz();
        }
    }
}

