/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "translation.missingKey";
    public static final String MSG_KEY_MISSING_TRANSLATION_FILE = "translation.missingTranslationFile";
    private static final Log LOG = LogFactory.getLog(TranslationCheck.class);
    private final List<File> propertyFiles = Lists.newArrayList();
    private String basenameSeparator;
    private SortedSet<String> requiredTranslations = ImmutableSortedSet.of();

    public TranslationCheck() {
        this.setFileExtensions("properties");
        this.basenameSeparator = "_";
    }

    public void setRequiredTranslations(String translationCodes) {
        this.requiredTranslations = Sets.newTreeSet(Splitter.on(',').trimResults().omitEmptyStrings().split(translationCodes));
    }

    @Override
    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        this.propertyFiles.clear();
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        this.propertyFiles.add(file);
    }

    @Override
    public void finishProcessing() {
        super.finishProcessing();
        SetMultimap<String, File> propFilesMap = TranslationCheck.arrangePropertyFiles(this.propertyFiles, this.basenameSeparator);
        this.checkExistenceOfTranslations(propFilesMap);
        this.checkPropertyFileSets(propFilesMap);
    }

    private void checkExistenceOfTranslations(SetMultimap<String, File> translations) {
        for (String fullyQualifiedBundleName : translations.keySet()) {
            String bundleBaseName = TranslationCheck.extractName(fullyQualifiedBundleName);
            if (!bundleBaseName.contains("messages")) continue;
            Set<File> filesInBundle = translations.get(fullyQualifiedBundleName);
            this.checkExistenceOfDefaultTranslation(filesInBundle);
            this.checkExistenceOfRequiredTranslations(filesInBundle);
        }
    }

    private void checkExistenceOfDefaultTranslation(Set<File> filesInResourceBundle) {
        String fullBundleName = this.getFullBundleName(filesInResourceBundle);
        String extension = this.getFileExtensions()[0];
        String defaultTranslationFileName = fullBundleName + extension;
        boolean missing = TranslationCheck.isMissing(defaultTranslationFileName, filesInResourceBundle);
        if (missing) {
            this.logMissingTranslation(defaultTranslationFileName);
        }
    }

    private void checkExistenceOfRequiredTranslations(Set<File> filesInResourceBundle) {
        String fullBundleName = this.getFullBundleName(filesInResourceBundle);
        String extension = this.getFileExtensions()[0];
        for (String languageCode : this.requiredTranslations) {
            String translationFileName = fullBundleName + '_' + languageCode + extension;
            boolean missing = TranslationCheck.isMissing(translationFileName, filesInResourceBundle);
            if (!missing) continue;
            String missingTranslationFileName = this.formMissingTranslationName(fullBundleName, languageCode);
            this.logMissingTranslation(missingTranslationFileName);
        }
    }

    private String getFullBundleName(Set<File> filesInResourceBundle) {
        File firstTranslationFile = Collections.min(filesInResourceBundle);
        String translationPath = firstTranslationFile.getPath();
        String extension = this.getFileExtensions()[0];
        Pattern pattern = Pattern.compile("^.+_[a-z]{2}" + extension + "$");
        Matcher matcher = pattern.matcher(translationPath);
        String fullBundleName = matcher.matches() ? translationPath.substring(0, translationPath.lastIndexOf(95)) : translationPath.substring(0, translationPath.lastIndexOf(46));
        return fullBundleName;
    }

    private static boolean isMissing(String fileName, Set<File> filesInResourceBundle) {
        File file;
        String currentFileName;
        boolean missing = false;
        Iterator<File> iterator = filesInResourceBundle.iterator();
        while (iterator.hasNext() && (missing = !(currentFileName = (file = iterator.next()).getPath()).equals(fileName))) {
        }
        return missing;
    }

    private String formMissingTranslationName(String fullBundleName, String languageCode) {
        String extension = this.getFileExtensions()[0];
        return String.format(Locale.ROOT, "%s_%s%s", fullBundleName, languageCode, extension);
    }

    private void logMissingTranslation(String fullyQualifiedFileName) {
        String filePath = TranslationCheck.extractPath(fullyQualifiedFileName);
        MessageDispatcher dispatcher = this.getMessageDispatcher();
        dispatcher.fireFileStarted(filePath);
        this.log(0, MSG_KEY_MISSING_TRANSLATION_FILE, TranslationCheck.extractName(fullyQualifiedFileName));
        this.fireErrors(filePath);
        dispatcher.fireFileFinished(filePath);
    }

    private static String extractPath(String fullyQualifiedFileName) {
        return fullyQualifiedFileName.substring(0, fullyQualifiedFileName.lastIndexOf(File.separator));
    }

    private static String extractName(String fullyQualifiedFileName) {
        return fullyQualifiedFileName.substring(fullyQualifiedFileName.lastIndexOf(File.separator) + 1);
    }

    private static String extractPropertyIdentifier(File file, String basenameSeparator) {
        String filePath = file.getPath();
        int dirNameEnd = filePath.lastIndexOf(File.separatorChar);
        int baseNameStart = dirNameEnd + 1;
        int underscoreIdx = filePath.indexOf(basenameSeparator, baseNameStart);
        int dotIdx = filePath.indexOf(46, baseNameStart);
        int cutoffIdx = underscoreIdx == -1 ? dotIdx : underscoreIdx;
        return filePath.substring(0, cutoffIdx);
    }

    public final void setBasenameSeparator(String basenameSeparator) {
        this.basenameSeparator = basenameSeparator;
    }

    private static SetMultimap<String, File> arrangePropertyFiles(List<File> propFiles, String basenameSeparator) {
        HashMultimap<String, File> propFileMap = HashMultimap.create();
        for (File file : propFiles) {
            String identifier = TranslationCheck.extractPropertyIdentifier(file, basenameSeparator);
            Set fileSet = propFileMap.get(identifier);
            fileSet.add(file);
        }
        return propFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> loadKeys(File file) {
        HashSet<Object> keys = Sets.newHashSet();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            Properties props = new Properties();
            props.load(inStream);
            Enumeration<?> element = props.propertyNames();
            while (element.hasMoreElements()) {
                keys.add(element.nextElement());
            }
        }
        catch (IOException ex) {
            try {
                this.logIoException(ex, file);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
            Closeables.closeQuietly(inStream);
        }
        Closeables.closeQuietly(inStream);
        return keys;
    }

    private void logIoException(IOException exception, File file) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(exception instanceof FileNotFoundException)) {
            args = new String[]{exception.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getId(), this.getClass(), null);
        TreeSet<LocalizedMessage> messages = Sets.newTreeSet();
        messages.add(message);
        this.getMessageDispatcher().fireErrors(file.getPath(), messages);
        LOG.debug("IOException occurred.", exception);
    }

    private void compareKeySets(Set<Object> keys, SetMultimap<File, Object> fileMap) {
        for (File currentFile : fileMap.keySet()) {
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = currentFile.getPath();
            dispatcher.fireFileStarted(path);
            Set<Object> currentKeys = fileMap.get(currentFile);
            HashSet<Object> keysClone = Sets.newHashSet(keys);
            keysClone.removeAll(currentKeys);
            if (!keysClone.isEmpty()) {
                for (Object e : keysClone) {
                    this.log(0, MSG_KEY, e);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void checkPropertyFileSets(SetMultimap<String, File> propFiles) {
        for (String key : propFiles.keySet()) {
            Set<File> files = propFiles.get(key);
            if (files.size() < 2) continue;
            HashSet<Object> keys = Sets.newHashSet();
            HashMultimap<File, Object> fileMap = HashMultimap.create();
            for (File file : files) {
                Set<Object> fileKeys = this.loadKeys(file);
                keys.addAll(fileKeys);
                fileMap.putAll(file, fileKeys);
            }
            this.compareKeySets(keys, fileMap);
        }
    }
}

