/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.google.common.collect.ImmutableList;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MainFrameModel {
    private final List<Integer> linesToPosition = new ArrayList<Integer>();
    private File currentFile;

    public DetailAST parseFile(File file) throws IOException, ANTLRException {
        this.currentFile = file;
        FileText text = this.getFileText(file);
        FileContents contents = new FileContents(text);
        return TreeWalker.parse(contents);
    }

    public FileText getFileText(File file) throws IOException {
        return new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
    }

    public File getLastDirectory() {
        File lastDirectory = null;
        if (this.currentFile != null) {
            lastDirectory = new File(this.currentFile.getParent());
        }
        return lastDirectory;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public List<Integer> getLinesToPosition() {
        return ImmutableList.copyOf(this.linesToPosition);
    }

    public void addLineToPosition(int value) {
        this.linesToPosition.add(value);
    }

    public void clearLinesToPosition() {
        this.linesToPosition.clear();
    }
}

