/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;

public class Tile {
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected boolean loaded = false;
    protected boolean loading = false;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 256;

    public Tile(int xtile, int ytile, int zoom) {
        this.xtile = xtile;
        this.ytile = ytile;
        this.zoom = zoom;
        this.image = null;
        this.key = Tile.getTileKey(xtile, ytile, zoom);
    }

    public Tile(int xtile, int ytile, int zoom, BufferedImage image) {
        this(xtile, ytile, zoom);
        this.image = image;
    }

    public void loadPlaceholderFromCache(TileCache cache) {
        BufferedImage tmpImage = new BufferedImage(256, 256, 1);
        Graphics2D g = (Graphics2D)tmpImage.getGraphics();
        for (int zoomDiff = 1; zoomDiff < 5; ++zoomDiff) {
            int zoom_low;
            int zoom_high = this.zoom + zoomDiff;
            if (zoomDiff < 3 && zoom_high <= 18) {
                int factor = 1 << zoomDiff;
                int xtile_high = this.xtile << zoomDiff;
                int ytile_high = this.ytile << zoomDiff;
                double scale = 1.0 / (double)factor;
                g.setTransform(AffineTransform.getScaleInstance(scale, scale));
                int paintedTileCount = 0;
                for (int x = 0; x < factor; ++x) {
                    for (int y = 0; y < factor; ++y) {
                        Tile tile = cache.getTile(xtile_high + x, ytile_high + y, zoom_high);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++paintedTileCount;
                        tile.paint(g, x * 256, y * 256);
                    }
                }
                if (paintedTileCount == factor * factor) {
                    this.image = tmpImage;
                    return;
                }
            }
            if ((zoom_low = this.zoom - zoomDiff) < 0) continue;
            int xtile_low = this.xtile >> zoomDiff;
            int ytile_low = this.ytile >> zoomDiff;
            int factor = 1 << zoomDiff;
            double scale = factor;
            AffineTransform at = new AffineTransform();
            int translate_x = this.xtile % factor * 256;
            int translate_y = this.ytile % factor * 256;
            at.setTransform(scale, 0.0, 0.0, scale, -translate_x, -translate_y);
            g.setTransform(at);
            Tile tile = cache.getTile(xtile_low, ytile_low, zoom_low);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(g, 0, 0);
            this.image = tmpImage;
            return;
        }
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void paint(Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, null);
    }

    public String toString() {
        return "Tile " + Tile.getTileKey(this.xtile, this.ytile, this.zoom);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)obj;
        return this.xtile == tile.xtile && this.ytile == tile.ytile && this.zoom == tile.zoom;
    }

    public static String getTileKey(int xtile, int ytile, int zoom) {
        return zoom + "/" + xtile + "/" + ytile;
    }
}

