/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.Job;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;

public class OsmTileLoader
implements TileLoader {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    public static final String MAP_OSMA = "http://tah.openstreetmap.org/Tiles/tile";
    protected String baseUrl;
    protected JMapViewer map;

    public OsmTileLoader(JMapViewer map) {
        this(map, MAP_MAPNIK);
    }

    public OsmTileLoader(JMapViewer map, String baseUrl) {
        this.map = map;
        this.baseUrl = baseUrl;
    }

    public void addLoadRequest(final int tilex, final int tiley, final int zoom) {
        this.map.jobDispatcher.addJob(new Job(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile;
                TileCache cache;
                TileCache tileCache = cache = OsmTileLoader.this.map.getTileCache();
                synchronized (tileCache) {
                    tile = cache.getTile(tilex, tiley, zoom);
                    if (tile == null || tile.isLoaded() || tile.loading) {
                        return;
                    }
                    tile.loading = true;
                }
                try {
                    this.input = OsmTileLoader.this.loadTileFromOsm(tile).getInputStream();
                    tile.setImage(ImageIO.read(this.input));
                    tile.setLoaded(true);
                    OsmTileLoader.this.map.repaint();
                    this.input.close();
                    this.input = null;
                }
                catch (Exception e) {
                    if (this.input == null) {
                        System.err.println("failed loading " + zoom + "/" + tilex + "/" + tiley + " " + e.getMessage());
                    }
                }
                finally {
                    tile.loading = false;
                }
            }

            public void stop() {
            }
        });
    }

    protected HttpURLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL url = new URL(this.baseUrl + "/" + tile.getKey() + ".png");
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setReadTimeout(30000);
        return urlConn;
    }
}

