/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final String FILE_EXT = ".png";
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String tileCacheDir;
    protected long maxFileAge = 604800000L;

    public OsmFileCacheTileLoader(JMapViewer map, String baseUrl) {
        super(map, baseUrl);
        String tempDir = System.getProperty("java.io.tmpdir");
        try {
            if (tempDir == null) {
                throw new IOException();
            }
            File cacheDir = new File(tempDir, "JMapViewerTiles");
            if (!(cacheDir = new File(cacheDir, Integer.toString(baseUrl.hashCode()))).exists() && !cacheDir.mkdirs()) {
                throw new IOException();
            }
            this.tileCacheDir = cacheDir.getAbsolutePath();
        }
        catch (Exception e) {
            this.tileCacheDir = "tiles";
        }
    }

    public OsmFileCacheTileLoader(JMapViewer map) {
        this(map, "http://tile.openstreetmap.org");
    }

    public void addLoadRequest(int tilex, int tiley, int zoom) {
        this.map.jobDispatcher.addJob(new FileLoadJob(tilex, tiley, zoom));
    }

    public long getMaxFileAge() {
        return this.maxFileAge;
    }

    public void setMaxFileAge(long maxFileAge) {
        this.maxFileAge = maxFileAge;
    }

    public String getTileCacheDir() {
        return this.tileCacheDir;
    }

    public void setTileCacheDir(String tileCacheDir) {
        this.tileCacheDir = tileCacheDir;
    }

    protected class FileLoadJob
    implements Runnable {
        InputStream input = null;
        int tilex;
        int tiley;
        int zoom;

        public FileLoadJob(int tilex, int tiley, int zoom) {
            this.tilex = tilex;
            this.tiley = tiley;
            this.zoom = zoom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Tile tile;
            TileCache cache;
            TileCache tileCache = cache = OsmFileCacheTileLoader.this.map.getTileCache();
            synchronized (tileCache) {
                tile = cache.getTile(this.tilex, this.tiley, this.zoom);
                if (tile == null || tile.isLoaded() || tile.loading) {
                    return;
                }
                tile.loading = true;
            }
            try {
                File f;
                FileInputStream fin;
                block17: {
                    long fileAge = 0L;
                    fin = null;
                    f = null;
                    f = this.getTileFile(tile);
                    fin = new FileInputStream(f);
                    tile.setImage(ImageIO.read(fin));
                    fin.close();
                    fileAge = f.lastModified();
                    boolean oldTile = System.currentTimeMillis() - fileAge > OsmFileCacheTileLoader.this.maxFileAge;
                    System.out.println("Loaded from file: " + tile);
                    if (oldTile) break block17;
                    tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.map.repaint();
                    return;
                }
                try {
                    OsmFileCacheTileLoader.this.map.repaint();
                }
                catch (Exception e) {
                    try {
                        if (fin != null) {
                            fin.close();
                            f.delete();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                HttpURLConnection urlConn = OsmFileCacheTileLoader.this.loadTileFromOsm(tile);
                byte[] buffer = this.loadTileInBuffer(urlConn);
                tile.setImage(ImageIO.read(new ByteArrayInputStream(buffer)));
                tile.setLoaded(true);
                OsmFileCacheTileLoader.this.map.repaint();
                this.input = null;
                this.saveTileToFile(tile, buffer);
            }
            catch (Exception e) {
                if (this.input == null) {
                    System.err.println("failed loading " + this.zoom + "/" + this.tilex + "/" + this.tiley + " " + e.getMessage());
                }
            }
            finally {
                tile.loading = false;
            }
        }

        protected byte[] loadTileInBuffer(URLConnection urlConn) throws IOException {
            this.input = urlConn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.input.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = this.input.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            return bout.toByteArray();
        }

        protected boolean isOsmTileNewer(Tile tile, long fileAge) throws IOException {
            URL url = new URL(OsmFileCacheTileLoader.this.baseUrl + "/" + tile.getKey() + OsmFileCacheTileLoader.FILE_EXT);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            long lastModified = urlConn.getLastModified();
            if (lastModified == 0L) {
                return true;
            }
            return lastModified > fileAge;
        }

        protected File getTileFile(Tile tile) throws IOException {
            return new File(OsmFileCacheTileLoader.this.tileCacheDir + "/" + tile.getZoom() + "_" + tile.getXtile() + "_" + tile.getYtile() + OsmFileCacheTileLoader.FILE_EXT);
        }

        protected void saveTileToFile(Tile tile, byte[] rawData) {
            try {
                FileOutputStream f = new FileOutputStream(OsmFileCacheTileLoader.this.tileCacheDir + "/" + tile.getZoom() + "_" + tile.getXtile() + "_" + tile.getYtile() + OsmFileCacheTileLoader.FILE_EXT);
                f.write(rawData);
                f.close();
            }
            catch (Exception e) {
                System.err.println("Failed to save tile content: " + e.getLocalizedMessage());
            }
        }
    }
}

