/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.openstreetmap.gui.jmapviewer.interfaces.Job;

public class JobDispatcher {
    protected BlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue<Runnable>();
    JobThread[] threads;

    public JobDispatcher(int threadCound) {
        this.threads = new JobThread[threadCound];
        for (int i = 0; i < threadCound; ++i) {
            this.threads[i] = new JobThread(i + 1);
        }
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                Runnable job = this.threads[i].getJob();
                if (job == null || !(job instanceof Job)) continue;
                ((Job)job).stop();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addJob(Runnable job) {
        try {
            this.jobQueue.put(job);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected class JobThread
    extends Thread {
        Runnable job;

        public JobThread(int threadId) {
            super("OSMJobThread " + threadId);
            this.setDaemon(true);
            this.job = null;
            this.start();
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    this.job = JobDispatcher.this.jobQueue.take();
                }
                catch (InterruptedException e1) {
                    return;
                }
                try {
                    this.job.run();
                    this.job = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public Runnable getJob() {
            return this.job;
        }
    }
}

